/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.CHARACTER_PROCESSING})
class CharacterSetAL16UTF16LE
extends CharacterSet
implements CharacterRepConstants {
    CharacterSetAL16UTF16LE(int n2) {
        super(n2);
        this.rep = 5;
    }

    @Override
    public boolean isLossyFrom(CharacterSet characterSet) {
        return !characterSet.isUnicode();
    }

    @Override
    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = characterSet.rep <= 1024;
        return bl;
    }

    @Override
    public boolean isUnicode() {
        return true;
    }

    @Override
    @DisableTrace
    public String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        try {
            char[] cArray = new char[Math.min(byArray.length - n2 >>> 1, n3 >>> 1)];
            int n4 = CharacterSet.convertAL16UTF16LEBytesToJavaChars(byArray, n2, cArray, 0, n3, true);
            return new String(cArray, 0, n4);
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    @Override
    @DisableTrace
    public String toString(byte[] byArray, int n2, int n3) throws SQLException {
        try {
            char[] cArray = new char[Math.min(byArray.length - n2 >>> 1, n3 >>> 1)];
            int n4 = CharacterSet.convertAL16UTF16LEBytesToJavaChars(byArray, n2, cArray, 0, n3, false);
            return new String(cArray, 0, n4);
        }
        catch (SQLException sQLException) {
            CharacterSetAL16UTF16LE.failUTFConversion();
            return "";
        }
    }

    @Override
    public byte[] convert(String string) throws SQLException {
        return CharacterSetAL16UTF16LE.stringToAL16UTF16LEBytes(string);
    }

    @Override
    public byte[] convertWithReplacement(String string) {
        return CharacterSetAL16UTF16LE.stringToAL16UTF16LEBytes(string);
    }

    @Override
    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 5) {
            byArray2 = CharacterSetAL16UTF16LE.useOrCopy(byArray, n2, n3);
        } else {
            String string = characterSet.toString(byArray, n2, n3);
            byArray2 = CharacterSetAL16UTF16LE.stringToAL16UTF16LEBytes(string);
        }
        return byArray2;
    }

    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        int n2;
        byte[] byArray = characterWalker.bytes;
        int n3 = characterWalker.next;
        int n4 = characterWalker.end;
        if (n3 + 1 >= n4) {
            CharacterSetAL16UTF16LE.failUTFConversion();
        }
        byte by = byArray[n3++];
        byte by2 = byArray[n3++];
        int n5 = n2 = (int)(by2 << 8 | by & 0xFF);
        if (Character.isHighSurrogate((char)n2)) {
            if (n3 + 1 >= n4) {
                CharacterSetAL16UTF16LE.failUTFConversion();
            }
            by = byArray[n3++];
            by2 = byArray[n3++];
            char c2 = (char)(by2 << 8 & 0xFF00 | by & 0xFF);
            n5 = Character.toCodePoint((char)n2, c2);
        }
        characterWalker.next = n3;
        return n5;
    }

    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        boolean bl = Character.isSupplementaryCodePoint(n2);
        if (n2 > 65535 && !bl) {
            CharacterSetAL16UTF16LE.failUTFConversion();
        } else if (!bl) {
            CharacterSetAL16UTF16LE.need(characterBuffer, 2);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 & 0xFF);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 >> 8 & 0xFF);
        } else {
            CharacterSetAL16UTF16LE.need(characterBuffer, 4);
            char[] cArray = Character.toChars(n2);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(cArray[0] & 0xFF);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(cArray[0] >> 8 & 0xFF);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(cArray[1] & 0xFF);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(cArray[1] >> 8 & 0xFF);
        }
    }
}

