/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.snowflake;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.AbstractJdbcQuery;
import io.kestra.plugin.jdbc.AutoCommitInterface;
import io.kestra.plugin.jdbc.snowflake.SnowflakeCellConverter;
import io.kestra.plugin.jdbc.snowflake.SnowflakeInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.Properties;
import lombok.Generated;
import net.snowflake.client.jdbc.SnowflakeDriver;

@Schema(title="Query a Snowflake server")
@Plugin(examples={@Example(full=true, title="Execute a query and fetch results on another task to update another table", code={"tasks:", "- id: select", "  type: io.kestra.plugin.jdbc.snowflake.Query", "  url: jdbc:snowflake://<account_identifier>.snowflakecomputing.com", "  username: snowflake", "  password: snowflake_passwd", "  sql: select * from source", "  fetch: true", "- id: generate-update", "  type: io.kestra.plugin.jdbc.snowflake.Query", "  url: jdbc:snowflake://<account_identifier>.snowflakecomputing.com", "  username: snowflake", "  password: snowflake_passwd", "  sql:  \"{% for row in outputs.update.rows %} INSERT INTO destination (year_month, store_code, update_date) values ({{row.year_month}}, {{row.store_code}}, TO_DATE('{{row.date}}', 'MONTH DD, YYYY') ); {% endfor %}\""})})
public class Query
extends AbstractJdbcQuery
implements RunnableTask<AbstractJdbcQuery.Output>,
SnowflakeInterface,
AutoCommitInterface {
    protected final Boolean autoCommit = true;
    private String database;
    private String warehouse;
    private String schema;
    private String role;

    @Override
    protected Properties connectionProperties(RunContext runContext) throws IllegalVariableEvaluationException, IOException {
        Properties properties = super.connectionProperties(runContext);
        this.renderProperties(runContext, properties);
        return properties;
    }

    @Override
    protected AbstractCellConverter getCellConverter(ZoneId zoneId) {
        return new SnowflakeCellConverter(zoneId);
    }

    @Override
    protected void registerDriver() throws SQLException {
        DriverManager.registerDriver(new SnowflakeDriver());
    }

    @Generated
    protected Query(QueryBuilder<?, ?> b) {
        super((AbstractJdbcQuery.AbstractJdbcQueryBuilder<?, ?>)b);
        this.database = b.database;
        this.warehouse = b.warehouse;
        this.schema = b.schema;
        this.role = b.role;
    }

    @Generated
    public static QueryBuilder<?, ?> builder() {
        return new QueryBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Query(super=" + super.toString() + ", autoCommit=" + this.getAutoCommit() + ", database=" + this.getDatabase() + ", warehouse=" + this.getWarehouse() + ", schema=" + this.getSchema() + ", role=" + this.getRole() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$autoCommit = this.getAutoCommit();
        Boolean other$autoCommit = other.getAutoCommit();
        if (this$autoCommit == null ? other$autoCommit != null : !((Object)this$autoCommit).equals(other$autoCommit)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        return !(this$role == null ? other$role != null : !this$role.equals(other$role));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Query;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $autoCommit = this.getAutoCommit();
        result = result * 59 + ($autoCommit == null ? 43 : ((Object)$autoCommit).hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        return result;
    }

    @Override
    @Generated
    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Override
    @Generated
    public String getWarehouse() {
        return this.warehouse;
    }

    @Override
    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Override
    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public Query() {
    }

    @Generated
    private static final class QueryBuilderImpl
    extends QueryBuilder<Query, QueryBuilderImpl> {
        @Generated
        private QueryBuilderImpl() {
        }

        @Override
        @Generated
        protected QueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Query build() {
            return new Query(this);
        }
    }

    @Generated
    public static abstract class QueryBuilder<C extends Query, B extends QueryBuilder<C, B>>
    extends AbstractJdbcQuery.AbstractJdbcQueryBuilder<C, B> {
        @Generated
        private String database;
        @Generated
        private String warehouse;
        @Generated
        private String schema;
        @Generated
        private String role;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B database(String database) {
            this.database = database;
            return (B)((Object)this.self());
        }

        @Generated
        public B warehouse(String warehouse) {
            this.warehouse = warehouse;
            return (B)((Object)this.self());
        }

        @Generated
        public B schema(String schema) {
            this.schema = schema;
            return (B)((Object)this.self());
        }

        @Generated
        public B role(String role) {
            this.role = role;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        public String toString() {
            return "Query.QueryBuilder(super=" + super.toString() + ", database=" + this.database + ", warehouse=" + this.warehouse + ", schema=" + this.schema + ", role=" + this.role + ")";
        }
    }
}

