/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.snowflake;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.jdbc.snowflake.AbstractSnowflakeConnection;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.net.URI;
import java.sql.Connection;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import net.snowflake.client.jdbc.SnowflakeConnection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Schema(title="Upload data to an internal stage")
@Plugin(examples={@Example(code={"stageName: MYSTAGE", "prefix: testUploadStream", "fileName: destFile.csv"})})
public class Upload
extends AbstractSnowflakeConnection
implements RunnableTask<Output> {
    private String database;
    private String warehouse;
    private String schema;
    private String role;
    @Schema(title="The file to copy")
    @PluginProperty(dynamic=true)
    @NotNull
    private String from;
    @Schema(title="The stage name", description="~ or table name or stage name")
    @PluginProperty(dynamic=true)
    @NotNull
    private String stageName;
    @Schema(title="path / prefix under which the data should be uploaded on the stage")
    @PluginProperty(dynamic=true)
    @NotNull
    private String prefix;
    @Schema(title="destination file name to use")
    @PluginProperty(dynamic=true)
    @NotNull
    private String fileName;
    @Schema(title="compress data or not before uploading stream")
    @PluginProperty(dynamic=false)
    @NotNull
    private Boolean compress;

    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        URI from = new URI(runContext.render(this.from));
        try (Connection conn = this.connection(runContext);){
            Output output;
            block12: {
                InputStream inputStream = runContext.uriToInputStream(from);
                try {
                    String stageName = runContext.render(this.stageName);
                    String prefix = runContext.render(this.prefix);
                    String filename = runContext.render(this.fileName);
                    logger.info("Starting upload to stage '{}' on '{}' with name '{}'", new Object[]{stageName, prefix, filename});
                    conn.unwrap(SnowflakeConnection.class).uploadStream(stageName, prefix, inputStream, filename, this.compress);
                    output = Output.builder().uri(URI.create(StringUtils.stripEnd((String)prefix, (String)"/") + "/" + filename + (this.compress != false ? ".gz" : ""))).build();
                    if (inputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return output;
        }
    }

    @Generated
    private static Boolean $default$compress() {
        return true;
    }

    @Generated
    protected Upload(UploadBuilder<?, ?> b) {
        super((AbstractSnowflakeConnection.AbstractSnowflakeConnectionBuilder<?, ?>)b);
        this.database = b.database;
        this.warehouse = b.warehouse;
        this.schema = b.schema;
        this.role = b.role;
        this.from = b.from;
        this.stageName = b.stageName;
        this.prefix = b.prefix;
        this.fileName = b.fileName;
        this.compress = b.compress$set ? b.compress$value : Upload.$default$compress();
    }

    @Generated
    public static UploadBuilder<?, ?> builder() {
        return new UploadBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Upload(super=" + super.toString() + ", database=" + this.getDatabase() + ", warehouse=" + this.getWarehouse() + ", schema=" + this.getSchema() + ", role=" + this.getRole() + ", from=" + this.getFrom() + ", stageName=" + this.getStageName() + ", prefix=" + this.getPrefix() + ", fileName=" + this.getFileName() + ", compress=" + this.getCompress() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Upload)) {
            return false;
        }
        Upload other = (Upload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$compress = this.getCompress();
        Boolean other$compress = other.getCompress();
        if (this$compress == null ? other$compress != null : !((Object)this$compress).equals(other$compress)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$stageName = this.getStageName();
        String other$stageName = other.getStageName();
        if (this$stageName == null ? other$stageName != null : !this$stageName.equals(other$stageName)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        return !(this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Upload;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $compress = this.getCompress();
        result = result * 59 + ($compress == null ? 43 : ((Object)$compress).hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $stageName = this.getStageName();
        result = result * 59 + ($stageName == null ? 43 : $stageName.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Override
    @Generated
    public String getWarehouse() {
        return this.warehouse;
    }

    @Override
    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Override
    @Generated
    public String getRole() {
        return this.role;
    }

    @NotNull
    @Generated
    public String getFrom() {
        return this.from;
    }

    @NotNull
    @Generated
    public String getStageName() {
        return this.stageName;
    }

    @NotNull
    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @NotNull
    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @NotNull
    @Generated
    public Boolean getCompress() {
        return this.compress;
    }

    @Generated
    public Upload() {
        this.compress = Upload.$default$compress();
    }

    @Generated
    private static final class UploadBuilderImpl
    extends UploadBuilder<Upload, UploadBuilderImpl> {
        @Generated
        private UploadBuilderImpl() {
        }

        @Override
        @Generated
        protected UploadBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Upload build() {
            return new Upload(this);
        }
    }

    @Generated
    public static abstract class UploadBuilder<C extends Upload, B extends UploadBuilder<C, B>>
    extends AbstractSnowflakeConnection.AbstractSnowflakeConnectionBuilder<C, B> {
        @Generated
        private String database;
        @Generated
        private String warehouse;
        @Generated
        private String schema;
        @Generated
        private String role;
        @Generated
        private String from;
        @Generated
        private String stageName;
        @Generated
        private String prefix;
        @Generated
        private String fileName;
        @Generated
        private boolean compress$set;
        @Generated
        private Boolean compress$value;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B database(String database) {
            this.database = database;
            return (B)((Object)this.self());
        }

        @Generated
        public B warehouse(String warehouse) {
            this.warehouse = warehouse;
            return (B)((Object)this.self());
        }

        @Generated
        public B schema(String schema) {
            this.schema = schema;
            return (B)((Object)this.self());
        }

        @Generated
        public B role(String role) {
            this.role = role;
            return (B)((Object)this.self());
        }

        @Generated
        public B from(@NotNull String from) {
            this.from = from;
            return (B)((Object)this.self());
        }

        @Generated
        public B stageName(@NotNull String stageName) {
            this.stageName = stageName;
            return (B)((Object)this.self());
        }

        @Generated
        public B prefix(@NotNull String prefix) {
            this.prefix = prefix;
            return (B)((Object)this.self());
        }

        @Generated
        public B fileName(@NotNull String fileName) {
            this.fileName = fileName;
            return (B)((Object)this.self());
        }

        @Generated
        public B compress(@NotNull Boolean compress) {
            this.compress$value = compress;
            this.compress$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        public String toString() {
            return "Upload.UploadBuilder(super=" + super.toString() + ", database=" + this.database + ", warehouse=" + this.warehouse + ", schema=" + this.schema + ", role=" + this.role + ", from=" + this.from + ", stageName=" + this.stageName + ", prefix=" + this.prefix + ", fileName=" + this.fileName + ", compress$value=" + this.compress$value + ")";
        }
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The url of the staged files")
        private final URI uri;

        @ConstructorProperties(value={"uri"})
        @Generated
        Output(URI uri) {
            this.uri = uri;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI uri;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uri);
            }

            @Generated
            public String toString() {
                return "Upload.Output.OutputBuilder(uri=" + this.uri + ")";
            }
        }
    }
}

