/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import net.snowflake.client.core.BasicEvent;
import net.snowflake.client.core.ChunkDownloader;
import net.snowflake.client.core.DownloaderMetrics;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFBaseStatement;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFJsonResultSet;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.core.StmtUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.JsonResultChunk;
import net.snowflake.client.jdbc.SnowflakeResultChunk;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryData;
import net.snowflake.client.jdbc.telemetry.TelemetryField;
import net.snowflake.client.jdbc.telemetry.TelemetryUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SFResultSet
extends SFJsonResultSet {
    static final SFLogger logger = SFLoggerFactory.getLogger(SFResultSet.class);
    private int columnCount = 0;
    private int currentChunkRowCount = 0;
    private int currentChunkRowIndex = -1;
    private JsonNode firstChunkRowset = null;
    private JsonResultChunk currentChunk = null;
    private String queryId;
    private SFStatementType statementType;
    private boolean totalRowCountTruncated;
    private boolean sortResult = false;
    private Object[][] firstChunkSortedRowSet;
    private final long firstChunkTime;
    private long chunkCount = 0L;
    private long nextChunkIndex = 0L;
    private ChunkDownloader chunkDownloader;
    protected SFBaseStatement statement;
    private final boolean arrayBindSupported;
    private Telemetry telemetryClient;
    private boolean treatNTZAsUTC;
    private boolean formatDateWithTimezone;

    public SFResultSet(SnowflakeResultSetSerializableV1 resultSetSerializable, SFBaseStatement statement, boolean sortResult) throws SQLException {
        this(resultSetSerializable, statement.getSFBaseSession().getTelemetryClient(), sortResult);
        this.statement = statement;
        SFBaseSession session = statement.getSFBaseSession();
        session.setDatabase(resultSetSerializable.getFinalDatabaseName());
        session.setSchema(resultSetSerializable.getFinalSchemaName());
        session.setRole(resultSetSerializable.getFinalRoleName());
        session.setWarehouse(resultSetSerializable.getFinalWarehouseName());
        this.treatNTZAsUTC = resultSetSerializable.getTreatNTZAsUTC();
        this.formatDateWithTimezone = resultSetSerializable.getFormatDateWithTimeZone();
        SessionUtil.updateSfDriverParamValues(this.parameters, statement.getSFBaseSession());
        if (resultSetSerializable.getSendResultTime() != 0L) {
            long timeConsumeFirstResult = this.firstChunkTime - resultSetSerializable.getSendResultTime();
            this.logMetric(TelemetryField.TIME_CONSUME_FIRST_RESULT, timeConsumeFirstResult);
        }
        StmtUtil.eventHandler.triggerStateTransition(BasicEvent.QueryState.CONSUMING_RESULT, String.format(BasicEvent.QueryState.CONSUMING_RESULT.getArgString(), this.queryId, 0));
    }

    public SFResultSet(SnowflakeResultSetSerializableV1 resultSetSerializable, Telemetry telemetryClient, boolean sortResult) throws SQLException {
        this.resultSetSerializable = resultSetSerializable;
        this.columnCount = 0;
        this.sortResult = sortResult;
        this.firstChunkTime = System.currentTimeMillis();
        this.telemetryClient = telemetryClient;
        this.queryId = resultSetSerializable.getQueryId();
        this.statementType = resultSetSerializable.getStatementType();
        this.totalRowCountTruncated = resultSetSerializable.isTotalRowCountTruncated();
        this.parameters = resultSetSerializable.getParameters();
        this.columnCount = resultSetSerializable.getColumnCount();
        this.firstChunkRowset = resultSetSerializable.getAndClearFirstChunkRowset();
        this.currentChunkRowCount = resultSetSerializable.getFirstChunkRowCount();
        this.chunkCount = resultSetSerializable.getChunkFileCount();
        this.chunkDownloader = resultSetSerializable.getChunkDownloader();
        this.timestampNTZFormatter = resultSetSerializable.getTimestampNTZFormatter();
        this.timestampLTZFormatter = resultSetSerializable.getTimestampLTZFormatter();
        this.timestampTZFormatter = resultSetSerializable.getTimestampTZFormatter();
        this.dateFormatter = resultSetSerializable.getDateFormatter();
        this.timeFormatter = resultSetSerializable.getTimeFormatter();
        this.sessionTimeZone = resultSetSerializable.getTimeZone();
        this.honorClientTZForTimestampNTZ = resultSetSerializable.isHonorClientTZForTimestampNTZ();
        this.binaryFormatter = resultSetSerializable.getBinaryFormatter();
        this.resultVersion = resultSetSerializable.getResultVersion();
        this.numberOfBinds = resultSetSerializable.getNumberOfBinds();
        this.arrayBindSupported = resultSetSerializable.isArrayBindSupported();
        this.metaDataOfBinds = resultSetSerializable.getMetaDataOfBinds();
        this.resultSetMetaData = resultSetSerializable.getSFResultSetMetaData();
        this.treatNTZAsUTC = resultSetSerializable.getTreatNTZAsUTC();
        this.formatDateWithTimezone = resultSetSerializable.getFormatDateWithTimeZone();
        if (sortResult) {
            if (this.chunkCount > 0L) {
                throw new SnowflakeSQLLoggedException(this.session, (int)ErrorCode.CLIENT_SIDE_SORTING_NOT_SUPPORTED.getMessageCode(), "0A000");
            }
            this.sortResultSet();
        }
    }

    private boolean fetchNextRow() throws SFException, SnowflakeSQLException {
        if (this.sortResult) {
            return this.fetchNextRowSorted();
        }
        return this.fetchNextRowUnsorted();
    }

    private boolean fetchNextRowSorted() {
        ++this.currentChunkRowIndex;
        if (this.currentChunkRowIndex < this.currentChunkRowCount) {
            return true;
        }
        this.firstChunkSortedRowSet = null;
        return false;
    }

    private boolean fetchNextRowUnsorted() throws SFException, SnowflakeSQLException {
        ++this.currentChunkRowIndex;
        if (this.currentChunkRowIndex < this.currentChunkRowCount) {
            return true;
        }
        this.firstChunkRowset = null;
        if (this.nextChunkIndex < this.chunkCount) {
            try {
                StmtUtil.eventHandler.triggerStateTransition(BasicEvent.QueryState.CONSUMING_RESULT, String.format(BasicEvent.QueryState.CONSUMING_RESULT.getArgString(), this.queryId, this.nextChunkIndex));
                SnowflakeResultChunk nextChunk = this.chunkDownloader.getNextChunkToConsume();
                if (nextChunk == null) {
                    throw new SnowflakeSQLLoggedException(this.session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Expect chunk but got null for chunk index " + this.nextChunkIndex);
                }
                this.currentChunkRowIndex = 0;
                this.currentChunkRowCount = nextChunk.getRowCount();
                this.currentChunk = (JsonResultChunk)nextChunk;
                logger.debug("Moving to chunk index {}, row count={}", this.nextChunkIndex, this.currentChunkRowCount);
                ++this.nextChunkIndex;
                return true;
            }
            catch (InterruptedException ex) {
                throw new SnowflakeSQLLoggedException(this.session, (int)ErrorCode.INTERRUPTED.getMessageCode(), "57014");
            }
        }
        if (this.chunkCount > 0L) {
            try {
                logger.debug("End of chunks", false);
                DownloaderMetrics metrics = this.chunkDownloader.terminate();
                this.logChunkDownloaderMetrics(metrics);
            }
            catch (InterruptedException ex) {
                throw new SnowflakeSQLLoggedException(this.session, (int)ErrorCode.INTERRUPTED.getMessageCode(), "57014");
            }
        }
        return false;
    }

    private void logMetric(TelemetryField field, long value) {
        TelemetryData data = TelemetryUtil.buildJobData(this.queryId, field, value);
        this.telemetryClient.addLogToBatch(data);
    }

    private void logChunkDownloaderMetrics(DownloaderMetrics metrics) {
        if (metrics != null) {
            this.logMetric(TelemetryField.TIME_WAITING_FOR_CHUNKS, metrics.getMillisWaiting());
            this.logMetric(TelemetryField.TIME_DOWNLOADING_CHUNKS, metrics.getMillisDownloading());
            this.logMetric(TelemetryField.TIME_PARSING_CHUNKS, metrics.getMillisParsing());
        }
    }

    @Override
    public boolean next() throws SFException, SnowflakeSQLException {
        if (this.isClosed()) {
            return false;
        }
        if (this.fetchNextRow()) {
            ++this.row;
            if (this.isLast()) {
                long timeConsumeLastResult = System.currentTimeMillis() - this.firstChunkTime;
                this.logMetric(TelemetryField.TIME_CONSUME_LAST_RESULT, timeConsumeLastResult);
            }
            return true;
        }
        logger.debug("end of result", false);
        if (this.totalRowCountTruncated || Boolean.TRUE.toString().equalsIgnoreCase(SnowflakeUtil.systemGetProperty("snowflake.enable_incident_test2"))) {
            throw new SFException(ErrorCode.MAX_RESULT_LIMIT_EXCEEDED, new Object[0]);
        }
        return false;
    }

    @Override
    protected Object getObjectInternal(int columnIndex) throws SFException {
        Object retValue;
        if (columnIndex <= 0 || columnIndex > this.resultSetMetaData.getColumnCount()) {
            throw new SFException(ErrorCode.COLUMN_DOES_NOT_EXIST, columnIndex);
        }
        int internalColumnIndex = columnIndex - 1;
        if (this.sortResult) {
            retValue = this.firstChunkSortedRowSet[this.currentChunkRowIndex][internalColumnIndex];
        } else if (this.firstChunkRowset != null) {
            retValue = JsonResultChunk.extractCell(this.firstChunkRowset, this.currentChunkRowIndex, internalColumnIndex);
        } else if (this.currentChunk != null) {
            retValue = this.currentChunk.getCell(this.currentChunkRowIndex, internalColumnIndex);
        } else {
            throw new SFException(ErrorCode.COLUMN_DOES_NOT_EXIST, columnIndex);
        }
        this.wasNull = retValue == null;
        return retValue;
    }

    private void sortResultSet() {
        this.firstChunkSortedRowSet = new Object[this.currentChunkRowCount][];
        for (int rowIdx = 0; rowIdx < this.currentChunkRowCount; ++rowIdx) {
            this.firstChunkSortedRowSet[rowIdx] = new Object[this.columnCount];
            for (int colIdx = 0; colIdx < this.columnCount; ++colIdx) {
                this.firstChunkSortedRowSet[rowIdx][colIdx] = JsonResultChunk.extractCell(this.firstChunkRowset, rowIdx, colIdx);
            }
        }
        Arrays.sort(this.firstChunkSortedRowSet, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] a, Object[] b) {
                int numCols = a.length;
                for (int colIdx = 0; colIdx < numCols; ++colIdx) {
                    if (a[colIdx] == null && b[colIdx] == null) continue;
                    if (a[colIdx] == null) {
                        return 1;
                    }
                    if (b[colIdx] == null) {
                        return -1;
                    }
                    int res = a[colIdx].toString().compareTo(b[colIdx].toString());
                    if (res == 0) continue;
                    return res;
                }
                return 0;
            }
        });
    }

    @Override
    public boolean isLast() {
        return this.nextChunkIndex == this.chunkCount && this.currentChunkRowIndex + 1 == this.currentChunkRowCount;
    }

    @Override
    public boolean isAfterLast() {
        return this.nextChunkIndex == this.chunkCount && this.currentChunkRowIndex >= this.currentChunkRowCount;
    }

    @Override
    public void close() throws SnowflakeSQLException {
        super.close();
        try {
            if (this.chunkDownloader != null) {
                DownloaderMetrics metrics = this.chunkDownloader.terminate();
                this.logChunkDownloaderMetrics(metrics);
                this.firstChunkSortedRowSet = null;
                this.firstChunkRowset = null;
                this.currentChunk = null;
            }
        }
        catch (InterruptedException ex) {
            throw new SnowflakeSQLLoggedException(this.session, (int)ErrorCode.INTERRUPTED.getMessageCode(), "57014");
        }
    }

    @Override
    public SFStatementType getStatementType() {
        return this.statementType;
    }

    @Override
    public void setStatementType(SFStatementType statementType) {
        this.statementType = statementType;
    }

    @Override
    public boolean isArrayBindSupported() {
        return this.arrayBindSupported;
    }

    @Override
    public String getQueryId() {
        return this.queryId;
    }
}

