/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.NullCheckingForGet;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TimeStampMicroTZReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampMicroTZHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.TimeStampMicroTZHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.TimeUnit;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;

public final class TimeStampMicroTZVector
extends TimeStampVector {
    private final FieldReader reader;
    private final String timeZone;

    public TimeStampMicroTZVector(String name, BufferAllocator allocator, String timeZone) {
        this(name, FieldType.nullable(new ArrowType.Timestamp(TimeUnit.MICROSECOND, timeZone)), allocator);
    }

    public TimeStampMicroTZVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, fieldType, allocator);
        ArrowType.Timestamp arrowType = (ArrowType.Timestamp)fieldType.getType();
        this.timeZone = arrowType.getTimezone();
        this.reader = new TimeStampMicroTZReaderImpl(this);
    }

    public TimeStampMicroTZVector(Field field, BufferAllocator allocator) {
        super(field, allocator);
        ArrowType.Timestamp arrowType = (ArrowType.Timestamp)field.getFieldType().getType();
        this.timeZone = arrowType.getTimezone();
        this.reader = new TimeStampMicroTZReaderImpl(this);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMESTAMPMICROTZ;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void get(int index, NullableTimeStampMicroTZHolder holder) {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getLong((long)index * 8L);
    }

    @Override
    public Long getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.valueBuffer.getLong((long)index * 8L);
    }

    public void set(int index, NullableTimeStampMicroTZHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, TimeStampMicroTZHolder holder) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, NullableTimeStampMicroTZHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, TimeStampMicroTZHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        TimeStampMicroTZVector to = new TimeStampMicroTZVector(ref, this.field.getFieldType(), allocator);
        return new TimeStampVector.TransferImpl(this, to);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TimeStampVector.TransferImpl(this, (TimeStampMicroTZVector)to);
    }
}

