/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.client.googleapis.apache.v2;

import java.io.IOException;
import java.net.ProxySelector;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import net.snowflake.client.jdbc.internal.apache.http.config.Registry;
import net.snowflake.client.jdbc.internal.apache.http.config.RegistryBuilder;
import net.snowflake.client.jdbc.internal.apache.http.conn.socket.ConnectionSocketFactory;
import net.snowflake.client.jdbc.internal.apache.http.conn.socket.PlainConnectionSocketFactory;
import net.snowflake.client.jdbc.internal.apache.http.conn.ssl.SSLConnectionSocketFactory;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.HttpClientBuilder;
import net.snowflake.client.jdbc.internal.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import net.snowflake.client.jdbc.internal.apache.http.impl.conn.SystemDefaultRoutePlanner;
import net.snowflake.client.jdbc.internal.google.api.client.googleapis.GoogleUtils;
import net.snowflake.client.jdbc.internal.google.api.client.googleapis.mtls.MtlsProvider;
import net.snowflake.client.jdbc.internal.google.api.client.googleapis.mtls.MtlsUtils;
import net.snowflake.client.jdbc.internal.google.api.client.http.apache.v2.ApacheHttpTransport;
import net.snowflake.client.jdbc.internal.google.api.client.util.Beta;
import net.snowflake.client.jdbc.internal.google.api.client.util.SslUtils;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;

public final class GoogleApacheHttpTransport {
    public static ApacheHttpTransport newTrustedTransport() throws GeneralSecurityException, IOException {
        return GoogleApacheHttpTransport.newTrustedTransport(MtlsUtils.getDefaultMtlsProvider());
    }

    @Beta
    public static ApacheHttpTransport newTrustedTransport(MtlsProvider mtlsProvider) throws GeneralSecurityException, IOException {
        SocketFactoryRegistryHandler handler = new SocketFactoryRegistryHandler(mtlsProvider);
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(handler.getSocketFactoryRegistry(), null, null, null, -1L, TimeUnit.MILLISECONDS);
        connectionManager.setValidateAfterInactivity(-1);
        CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().setMaxConnTotal(200).setMaxConnPerRoute(20).setRoutePlanner(new SystemDefaultRoutePlanner(ProxySelector.getDefault())).setConnectionManager(connectionManager).disableRedirectHandling().disableAutomaticRetries().build();
        return new ApacheHttpTransport(client, handler.isMtls());
    }

    private GoogleApacheHttpTransport() {
    }

    @VisibleForTesting
    static class SocketFactoryRegistryHandler {
        private final Registry<ConnectionSocketFactory> socketFactoryRegistry;
        private final boolean isMtls;

        public SocketFactoryRegistryHandler(MtlsProvider mtlsProvider) throws GeneralSecurityException, IOException {
            KeyStore mtlsKeyStore = null;
            String mtlsKeyStorePassword = null;
            if (mtlsProvider.useMtlsClientCertificate()) {
                mtlsKeyStore = mtlsProvider.getKeyStore();
                mtlsKeyStorePassword = mtlsProvider.getKeyStorePassword();
            }
            KeyStore trustStore = GoogleUtils.getCertificateTrustStore();
            SSLContext sslContext = SslUtils.getTlsSslContext();
            if (mtlsKeyStore != null && mtlsKeyStorePassword != null) {
                this.isMtls = true;
                SslUtils.initSslContext(sslContext, trustStore, SslUtils.getPkixTrustManagerFactory(), mtlsKeyStore, mtlsKeyStorePassword, SslUtils.getDefaultKeyManagerFactory());
            } else {
                this.isMtls = false;
                SslUtils.initSslContext(sslContext, trustStore, SslUtils.getPkixTrustManagerFactory());
            }
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext);
            this.socketFactoryRegistry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)socketFactory)).build();
        }

        public Registry<ConnectionSocketFactory> getSocketFactoryRegistry() {
            return this.socketFactoryRegistry;
        }

        public boolean isMtls() {
            return this.isMtls;
        }
    }
}

