/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.snowflake;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.jdbc.snowflake.AbstractSnowflakeConnection;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.sql.Connection;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import net.snowflake.client.jdbc.SnowflakeConnection;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

@Schema(title="Download data to an internal stage")
@Plugin(examples={@Example(code={"stageName: MYSTAGE", "fileName: prefix/destFile.csv"})})
public class Download
extends AbstractSnowflakeConnection
implements RunnableTask<Output> {
    private String database;
    private String warehouse;
    private String schema;
    private String role;
    @Schema(title="The stage name", description="~ or table name or stage name")
    @PluginProperty(dynamic=true)
    @NotNull
    private String stageName;
    @Schema(title="destination file name to use")
    @PluginProperty(dynamic=true)
    @NotNull
    private String fileName;
    @Schema(title="compress data or not before uploading stream")
    @PluginProperty(dynamic=false)
    @NotNull
    private Boolean compress;

    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        File tempFile = runContext.tempFile().toFile();
        try (Connection conn = this.connection(runContext);){
            Output output;
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(tempFile));){
                String stageName = runContext.render(this.stageName);
                String filename = runContext.render(this.fileName);
                logger.info("Starting download from stage '{}' with name '{}'", (Object)stageName, (Object)filename);
                InputStream inputStream = conn.unwrap(SnowflakeConnection.class).downloadStream(stageName, filename, this.compress);
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
                outputStream.flush();
                output = Output.builder().uri(runContext.putTempFile(tempFile)).build();
            }
            return output;
        }
    }

    @Generated
    private static Boolean $default$compress() {
        return true;
    }

    @Generated
    protected Download(DownloadBuilder<?, ?> b) {
        super((AbstractSnowflakeConnection.AbstractSnowflakeConnectionBuilder)b);
        this.database = b.database;
        this.warehouse = b.warehouse;
        this.schema = b.schema;
        this.role = b.role;
        this.stageName = b.stageName;
        this.fileName = b.fileName;
        this.compress = b.compress$set ? b.compress$value : Download.$default$compress();
    }

    @Generated
    public static DownloadBuilder<?, ?> builder() {
        return new DownloadBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Download(super=" + super.toString() + ", database=" + this.getDatabase() + ", warehouse=" + this.getWarehouse() + ", schema=" + this.getSchema() + ", role=" + this.getRole() + ", stageName=" + this.getStageName() + ", fileName=" + this.getFileName() + ", compress=" + this.getCompress() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Download)) {
            return false;
        }
        Download other = (Download)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$compress = this.getCompress();
        Boolean other$compress = other.getCompress();
        if (this$compress == null ? other$compress != null : !((Object)this$compress).equals(other$compress)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$stageName = this.getStageName();
        String other$stageName = other.getStageName();
        if (this$stageName == null ? other$stageName != null : !this$stageName.equals(other$stageName)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        return !(this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Download;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $compress = this.getCompress();
        result = result * 59 + ($compress == null ? 43 : ((Object)$compress).hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $stageName = this.getStageName();
        result = result * 59 + ($stageName == null ? 43 : $stageName.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Override
    @Generated
    public String getWarehouse() {
        return this.warehouse;
    }

    @Override
    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Override
    @Generated
    public String getRole() {
        return this.role;
    }

    @NotNull
    @Generated
    public String getStageName() {
        return this.stageName;
    }

    @NotNull
    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @NotNull
    @Generated
    public Boolean getCompress() {
        return this.compress;
    }

    @Generated
    public Download() {
        this.compress = Download.$default$compress();
    }

    @Generated
    private static final class DownloadBuilderImpl
    extends DownloadBuilder<Download, DownloadBuilderImpl> {
        @Generated
        private DownloadBuilderImpl() {
        }

        @Override
        @Generated
        protected DownloadBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Download build() {
            return new Download(this);
        }
    }

    @Generated
    public static abstract class DownloadBuilder<C extends Download, B extends DownloadBuilder<C, B>>
    extends AbstractSnowflakeConnection.AbstractSnowflakeConnectionBuilder<C, B> {
        @Generated
        private String database;
        @Generated
        private String warehouse;
        @Generated
        private String schema;
        @Generated
        private String role;
        @Generated
        private String stageName;
        @Generated
        private String fileName;
        @Generated
        private boolean compress$set;
        @Generated
        private Boolean compress$value;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B database(String database) {
            this.database = database;
            return (B)((Object)this.self());
        }

        @Generated
        public B warehouse(String warehouse) {
            this.warehouse = warehouse;
            return (B)((Object)this.self());
        }

        @Generated
        public B schema(String schema) {
            this.schema = schema;
            return (B)((Object)this.self());
        }

        @Generated
        public B role(String role) {
            this.role = role;
            return (B)((Object)this.self());
        }

        @Generated
        public B stageName(@NotNull String stageName) {
            this.stageName = stageName;
            return (B)((Object)this.self());
        }

        @Generated
        public B fileName(@NotNull String fileName) {
            this.fileName = fileName;
            return (B)((Object)this.self());
        }

        @Generated
        public B compress(@NotNull Boolean compress) {
            this.compress$value = compress;
            this.compress$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        public String toString() {
            return "Download.DownloadBuilder(super=" + super.toString() + ", database=" + this.database + ", warehouse=" + this.warehouse + ", schema=" + this.schema + ", role=" + this.role + ", stageName=" + this.stageName + ", fileName=" + this.fileName + ", compress$value=" + this.compress$value + ")";
        }
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The url of the file on kestra storage")
        private final URI uri;

        @ConstructorProperties(value={"uri"})
        @Generated
        Output(URI uri) {
            this.uri = uri;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI uri;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uri);
            }

            @Generated
            public String toString() {
                return "Download.Output.OutputBuilder(uri=" + this.uri + ")";
            }
        }
    }
}

