/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob;

import java.util.Locale;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.Utility;

public enum BlobType {
    UNSPECIFIED,
    BLOCK_BLOB,
    PAGE_BLOB,
    APPEND_BLOB;


    protected static BlobType parse(String typeString) {
        if (Utility.isNullOrEmpty(typeString)) {
            return UNSPECIFIED;
        }
        if ("blockblob".equals(typeString.toLowerCase(Locale.US))) {
            return BLOCK_BLOB;
        }
        if ("pageblob".equals(typeString.toLowerCase(Locale.US))) {
            return PAGE_BLOB;
        }
        if ("appendblob".equals(typeString.toLowerCase(Locale.US))) {
            return APPEND_BLOB;
        }
        return UNSPECIFIED;
    }
}

