/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.generators;

import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.KeyGenerationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.params.X25519PublicKeyParameters;

public class X25519KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        X25519PrivateKeyParameters x25519PrivateKeyParameters = new X25519PrivateKeyParameters(this.random);
        X25519PublicKeyParameters x25519PublicKeyParameters = x25519PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(x25519PublicKeyParameters, x25519PrivateKeyParameters);
    }
}

