/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc;

import io.kestra.plugin.jdbc.AbstractJdbcConnection;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.ZoneId;
import java.util.TimeZone;
import lombok.Generated;

public abstract class AbstractJdbcStatement
extends AbstractJdbcConnection {
    @Schema(title="The time zone id to use for date/time manipulation. Default value is the worker default zone id.")
    private String timeZoneId;

    protected ZoneId zoneId() {
        ZoneId zoneId = TimeZone.getDefault().toZoneId();
        if (this.timeZoneId != null) {
            zoneId = ZoneId.of(this.timeZoneId);
        }
        return zoneId;
    }

    @Generated
    protected AbstractJdbcStatement(AbstractJdbcStatementBuilder<?, ?> b) {
        super(b);
        this.timeZoneId = b.timeZoneId;
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractJdbcStatement(super=" + super.toString() + ", timeZoneId=" + this.getTimeZoneId() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractJdbcStatement)) {
            return false;
        }
        AbstractJdbcStatement other = (AbstractJdbcStatement)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$timeZoneId = this.getTimeZoneId();
        String other$timeZoneId = other.getTimeZoneId();
        return !(this$timeZoneId == null ? other$timeZoneId != null : !this$timeZoneId.equals(other$timeZoneId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractJdbcStatement;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $timeZoneId = this.getTimeZoneId();
        result = result * 59 + ($timeZoneId == null ? 43 : $timeZoneId.hashCode());
        return result;
    }

    @Generated
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    @Generated
    public AbstractJdbcStatement() {
    }

    @Generated
    public static abstract class AbstractJdbcStatementBuilder<C extends AbstractJdbcStatement, B extends AbstractJdbcStatementBuilder<C, B>>
    extends AbstractJdbcConnection.AbstractJdbcConnectionBuilder<C, B> {
        @Generated
        private String timeZoneId;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        public String toString() {
            return "AbstractJdbcStatement.AbstractJdbcStatementBuilder(super=" + super.toString() + ", timeZoneId=" + this.timeZoneId + ")";
        }
    }
}

