/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.jdbc.DrvBlob;
import com.ingres.gcf.jdbc.DrvClob;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvLOB;
import com.ingres.gcf.jdbc.DrvNlob;
import com.ingres.gcf.jdbc.JdbcBlob;
import com.ingres.gcf.jdbc.JdbcClob;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.JdbcStmt;
import com.ingres.gcf.jdbc.ParamSet;
import com.ingres.gcf.jdbc.RsltCurs;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.IngresDate;
import com.ingres.gcf.util.SqlBigInt;
import com.ingres.gcf.util.SqlBool;
import com.ingres.gcf.util.SqlByte;
import com.ingres.gcf.util.SqlChar;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDate;
import com.ingres.gcf.util.SqlDecimal;
import com.ingres.gcf.util.SqlDouble;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlInt;
import com.ingres.gcf.util.SqlNChar;
import com.ingres.gcf.util.SqlNVarChar;
import com.ingres.gcf.util.SqlReal;
import com.ingres.gcf.util.SqlSmallInt;
import com.ingres.gcf.util.SqlTime;
import com.ingres.gcf.util.SqlTimestamp;
import com.ingres.gcf.util.SqlTinyInt;
import com.ingres.gcf.util.SqlVarByte;
import com.ingres.gcf.util.SqlVarChar;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class RsltUpd
extends RsltCurs
implements MsgConst,
DbmsConst,
GcfErr {
    protected String table = null;
    protected ParamSet params = null;
    protected boolean insert = false;

    RsltUpd(DrvConn drvConn, JdbcStmt jdbcStmt, JdbcRSMD jdbcRSMD, long l, String string, String string2) throws SQLException {
        super(drvConn, jdbcStmt, jdbcRSMD, l, string, -1, false);
        this.rs_concur = 1008;
        this.table = string2;
        this.params = new ParamSet(drvConn, jdbcRSMD.count);
        this.tr_id = "Upd[" + this.inst_id + "]";
    }

    @Override
    protected void load() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".load(): invalid row");
            }
            throw SqlExFactory.get(ERR_GC4021_INVALID_ROW);
        }
        this.params.clear(false);
        super.load();
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".moveToInsertRow()");
        }
        if (!this.insert) {
            this.flush();
            this.params.clear(false);
            this.insert = true;
        }
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".moveToCurrentRow()");
        }
        if (this.insert) {
            this.params.clear(false);
            this.insert = false;
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".cancelRowUpdates()");
        }
        this.params.clear(false);
    }

    @Override
    public int getRow() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getRow(): insert row!");
            }
            throw SqlExFactory.get(ERR_GC4021_INVALID_ROW);
        }
        return super.getRow();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".isBeforeFirst(): insert row!");
            }
            throw SqlExFactory.get(ERR_GC4021_INVALID_ROW);
        }
        return super.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".isAfterLast(): insert row!");
            }
            throw SqlExFactory.get(ERR_GC4021_INVALID_ROW);
        }
        return super.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".isFirst(): insert row!");
            }
            throw SqlExFactory.get(ERR_GC4021_INVALID_ROW);
        }
        return super.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".isLast(): insert row!");
            }
            throw SqlExFactory.get(ERR_GC4021_INVALID_ROW);
        }
        return super.isLast();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".rowUpdated(): insert row!");
            }
            throw SqlExFactory.get(ERR_GC4021_INVALID_ROW);
        }
        return super.rowUpdated();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".rowDeleted(): insert row!");
            }
            throw SqlExFactory.get(ERR_GC4021_INVALID_ROW);
        }
        return super.rowDeleted();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".rowInserted(): insert row!");
            }
            throw SqlExFactory.get(ERR_GC4021_INVALID_ROW);
        }
        return super.rowInserted();
    }

    @Override
    public void refreshRow() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".refreshRow(): invalid row");
            }
            throw SqlExFactory.get(ERR_GC4021_INVALID_ROW);
        }
        this.params.clear(false);
        super.refreshRow();
    }

    @Override
    public void updateNull(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateNull(" + n + ")");
        }
        n = this.columnMap(n);
        if ((this.rsmd.desc[n].flags & 1) == 0) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setNull(n);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBoolean( " + n + "," + bl + ")");
        }
        n = this.columnMap(n);
        this.initParam(n);
        this.params.setBoolean(n, bl);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateByte(" + n + "," + by + ")");
        }
        n = this.columnMap(n);
        this.initParam(n);
        this.params.setByte(n, by);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateShort(" + n + "," + s + ")");
        }
        n = this.columnMap(n);
        this.initParam(n);
        this.params.setShort(n, s);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateInt(" + n + "," + n2 + ")");
        }
        n = this.columnMap(n);
        this.initParam(n);
        this.params.setInt(n, n2);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateLong(" + n + "," + l + ")");
        }
        n = this.columnMap(n);
        this.initParam(n);
        this.params.setLong(n, l);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateFloat(" + n + "," + f + ")");
        }
        n = this.columnMap(n);
        this.initParam(n);
        this.params.setFloat(n, f);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateDouble(" + n + "," + d + ")");
        }
        n = this.columnMap(n);
        this.initParam(n);
        this.params.setDouble(n, d);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBigDecimal(" + n + "," + bigDecimal + ")");
        }
        n = this.columnMap(n);
        if (bigDecimal == null && (this.rsmd.desc[n].flags & 1) == 0) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setBigDecimal(n, bigDecimal);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateString(" + n + "," + string + ")");
        }
        n = this.columnMap(n);
        if (string == null && (this.rsmd.desc[n].flags & 1) == 0) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setString(n, string);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBytes(" + n + "," + (byArray == null ? "null" : "[" + byArray.length + "]") + ")");
        }
        n = this.columnMap(n);
        if (byArray == null && (this.rsmd.desc[n].flags & 1) == 0) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setBytes(n, byArray);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateDate(" + n + "," + date + ")");
        }
        n = this.columnMap(n);
        if (date == null && (this.rsmd.desc[n].flags & 1) == 0) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setDate(n, date, null);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateTime(" + n + "," + time + ")");
        }
        n = this.columnMap(n);
        if (time == null && (this.rsmd.desc[n].flags & 1) == 0) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setTime(n, time, null);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateTimestamp(" + n + "," + timestamp + ")");
        }
        n = this.columnMap(n);
        if (timestamp == null && (this.rsmd.desc[n].flags & 1) == 0) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setTimestamp(n, timestamp, null);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBinaryStream(" + n + "," + l + ")");
        }
        n = this.columnMap(n);
        if (inputStream == null && (this.rsmd.desc[n].flags & 1) == 0) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setBinaryStream(n, inputStream);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateAsciiStream(" + n + "," + l + ")");
        }
        n = this.columnMap(n);
        if (inputStream == null && (this.rsmd.desc[n].flags & 1) == 0) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setAsciiStream(n, inputStream);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateCharacterStream(" + n + "," + l + ")");
        }
        n = this.columnMap(n);
        if (reader == null && (this.rsmd.desc[n].flags & 1) == 0) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setCharacterStream(n, reader);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBlob(" + n + "," + blob + ")");
        }
        n = this.columnMap(n);
        if (blob == null && (this.rsmd.desc[n].flags & 1) == 0) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        switch (this.rsmd.desc[n].sql_type) {
            case -4: 
            case 2004: {
                if (blob == null) {
                    this.initParam(n);
                    this.params.setNull(n);
                    break;
                }
                if (blob instanceof JdbcBlob && ((JdbcBlob)blob).isValidLocator(this.conn)) {
                    DrvLOB drvLOB = ((JdbcBlob)blob).getLOB();
                    this.params.init(n, drvLOB);
                    if (drvLOB instanceof DrvBlob) {
                        this.params.setBlob(n, (DrvBlob)drvLOB);
                        break;
                    }
                    this.params.setBinaryStream(n, blob.getBinaryStream());
                    break;
                }
                this.initParam(n);
                this.params.setBinaryStream(n, blob.getBinaryStream());
                break;
            }
            default: {
                this.initParam(n);
                if (blob == null) {
                    this.params.setBinaryStream(n, null);
                    break;
                }
                if (blob instanceof JdbcBlob && ((JdbcBlob)blob).isValidLocator(this.conn)) {
                    DrvLOB drvLOB = ((JdbcBlob)blob).getLOB();
                    if (blob instanceof DrvBlob) {
                        this.params.setBlob(n, (DrvBlob)drvLOB);
                        break;
                    }
                    this.params.setBinaryStream(n, blob.getBinaryStream());
                    break;
                }
                this.params.setBinaryStream(n, blob.getBinaryStream());
            }
        }
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateClob(" + n + "," + clob + ")");
        }
        n = this.columnMap(n);
        if (clob == null && (this.rsmd.desc[n].flags & 1) == 0) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        switch (this.rsmd.desc[n].sql_type) {
            case -1: 
            case 2005: {
                if (clob == null) {
                    this.initParam(n);
                    this.params.setNull(n);
                    break;
                }
                if (clob instanceof JdbcClob && ((JdbcClob)clob).isValidLocator(this.conn)) {
                    DrvLOB drvLOB = ((JdbcClob)clob).getLOB();
                    this.params.init(n, drvLOB);
                    if (drvLOB instanceof DrvClob) {
                        this.params.setClob(n, (DrvClob)drvLOB);
                        break;
                    }
                    if (drvLOB instanceof DrvNlob) {
                        this.params.setClob(n, (DrvNlob)drvLOB);
                        break;
                    }
                    this.params.setCharacterStream(n, clob.getCharacterStream());
                    break;
                }
                this.initParam(n);
                this.params.setCharacterStream(n, clob.getCharacterStream());
                break;
            }
            default: {
                this.initParam(n);
                if (clob == null) {
                    this.params.setCharacterStream(n, null);
                    break;
                }
                if (clob instanceof JdbcClob && ((JdbcClob)clob).isValidLocator(this.conn)) {
                    DrvLOB drvLOB = ((JdbcClob)clob).getLOB();
                    if (drvLOB instanceof DrvClob) {
                        this.params.setClob(n, (DrvClob)drvLOB);
                        break;
                    }
                    if (drvLOB instanceof DrvNlob) {
                        this.params.setClob(n, (DrvNlob)drvLOB);
                        break;
                    }
                    this.params.setCharacterStream(n, clob.getCharacterStream());
                    break;
                }
                this.params.setCharacterStream(n, clob.getCharacterStream());
            }
        }
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateObject(" + n + "," + object + ")");
        }
        n = this.columnMap(n);
        if (object == null && (this.rsmd.desc[n].flags & 1) == 0) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        switch (this.rsmd.desc[n].sql_type) {
            case -4: 
            case 2004: {
                if (object == null || !(object instanceof Blob)) {
                    this.initParam(n);
                    break;
                }
                if (object instanceof JdbcBlob && ((JdbcBlob)object).isValidLocator(this.conn)) {
                    object = ((JdbcBlob)object).getLOB();
                    this.params.init(n, object);
                    break;
                }
                object = ((Blob)object).getBinaryStream();
                this.initParam(n);
                break;
            }
            case -1: 
            case 2005: {
                if (object == null || !(object instanceof Clob)) {
                    this.initParam(n);
                    break;
                }
                if (object instanceof JdbcClob && ((JdbcClob)object).isValidLocator(this.conn)) {
                    object = ((JdbcClob)object).getLOB();
                    this.params.init(n, object);
                    break;
                }
                object = ((Clob)object).getCharacterStream();
                this.initParam(n);
                break;
            }
            default: {
                if (object != null) {
                    if (object instanceof Blob) {
                        object = object instanceof JdbcBlob && ((JdbcBlob)object).isValidLocator(this.conn) ? ((JdbcBlob)object).getLOB() : ((Blob)object).getBinaryStream();
                    } else if (object instanceof Clob) {
                        object = object instanceof JdbcClob && ((JdbcClob)object).isValidLocator(this.conn) ? ((JdbcClob)object).getLOB() : ((Clob)object).getCharacterStream();
                    }
                }
                this.initParam(n);
            }
        }
        this.params.setObject(n, object);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateObject(" + n + "," + object + "," + n2 + ")");
        }
        n = this.columnMap(n);
        if (object == null && (this.rsmd.desc[n].flags & 1) == 0) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        int n3 = this.rsmd.desc[n].sql_type;
        switch (n3) {
            case -4: 
            case 2004: {
                if (object == null || !(object instanceof Blob)) {
                    n3 = -4;
                    this.initParam(n);
                    break;
                }
                if (object instanceof JdbcBlob && ((JdbcBlob)object).isValidLocator(this.conn)) {
                    n3 = 2004;
                    object = ((JdbcBlob)object).getLOB();
                    this.params.init(n, object);
                    break;
                }
                n3 = -4;
                object = ((Blob)object).getBinaryStream();
                this.initParam(n);
                break;
            }
            case -1: 
            case 2005: {
                if (object == null || !(object instanceof Clob)) {
                    n3 = -1;
                    this.initParam(n);
                    break;
                }
                if (object instanceof JdbcClob && ((JdbcClob)object).isValidLocator(this.conn)) {
                    n3 = 2005;
                    object = ((JdbcClob)object).getLOB();
                    this.params.init(n, object);
                    break;
                }
                n3 = -1;
                object = ((Clob)object).getCharacterStream();
                this.initParam(n);
                break;
            }
            default: {
                if (object != null) {
                    if (object instanceof Blob) {
                        object = object instanceof JdbcBlob && ((JdbcBlob)object).isValidLocator(this.conn) ? ((JdbcBlob)object).getLOB() : ((Blob)object).getBinaryStream();
                    } else if (object instanceof Clob) {
                        object = object instanceof JdbcClob && ((JdbcClob)object).isValidLocator(this.conn) ? ((JdbcClob)object).getLOB() : ((Clob)object).getCharacterStream();
                    }
                }
                this.initParam(n);
            }
        }
        this.params.setObject(n, object, n3, n2);
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".deleteRow()");
        }
        if (this.insert || this.posStatus != 3 || (this.currentRow.status & 0x40) != 0) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".deleteRow(): invalid row");
            }
            throw SqlExFactory.get(ERR_GC4021_INVALID_ROW);
        }
        try {
            this.flush();
            this.exec((short)7, "delete from " + this.table, null);
            this.currentRow.status |= 0x40;
            this.currentRow.status &= 0xFFFFFFDF;
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".deleteRow(): error deleting row");
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.params.clear(false);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".deleteRow(): row deleted!");
        }
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateRow()");
        }
        if (this.insert || this.posStatus != 3 || (this.currentRow.status & 0x40) != 0) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".updateRow(): invalid row");
            }
            throw SqlExFactory.get(ERR_GC4021_INVALID_ROW);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.rsmd.count; ++i) {
            if (!this.params.isSet(i)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.rsmd.desc[i].name);
            stringBuffer.append(" = ~V ");
        }
        if (stringBuffer.length() <= 0) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".updateRow(): no columns updated, request ignored.");
            }
            return;
        }
        String string = "update " + this.table + " set " + stringBuffer.toString();
        try {
            this.flush();
            this.exec((short)8, string, this.params);
            this.currentRow.status |= 0x20;
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".updateRow(): error updating row");
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.copyParams();
            this.params.clear(false);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateRow(): row updated!");
        }
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".insertRow()");
        }
        if (!this.insert || this.posStatus == 0) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".insertRow(): invalid row");
            }
            throw SqlExFactory.get(ERR_GC4021_INVALID_ROW);
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < this.rsmd.count; ++i) {
            if (!this.params.isSet(i)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
                stringBuffer2.append(",");
            }
            stringBuffer.append(this.rsmd.desc[i].name);
            stringBuffer2.append(" ~V ");
        }
        if (stringBuffer.length() <= 0) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".insertRow(): no values");
            }
            throw SqlExFactory.get(ERR_GC4020_NO_PARAM);
        }
        String string = "insert into " + this.table + "(" + stringBuffer.toString() + ") values(" + stringBuffer2.toString() + ")";
        try {
            this.exec((short)1, string, this.params);
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".insertRow(): error inserting row");
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.params.clear(false);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".insertRow(): row inserted!");
        }
    }

    private void exec(short s, String string, ParamSet paramSet) throws SQLException {
        this.clearResults();
        this.msg.lock();
        try {
            this.msg.begin((byte)4);
            this.msg.write(s);
            if (s == 7 || s == 8) {
                this.msg.write((short)2);
                this.msg.write(this.cursor);
            }
            this.writeQueryText(string);
            if (paramSet == null) {
                this.msg.done(true);
            } else {
                this.msg.done(false);
                paramSet.sendDesc(false);
                paramSet.sendData(true);
            }
            this.readResults();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": error executing query: " + string);
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.msg.unlock();
        }
    }

    private synchronized void initParam(int n) throws SQLException {
        int n2 = this.rsmd.desc[n].sql_type;
        boolean bl = false;
        switch (this.rsmd.desc[n].sql_type) {
            case 1: {
                bl = this.rsmd.desc[n].dbms_type != 26;
                break;
            }
            case 12: {
                bl = this.rsmd.desc[n].dbms_type != 27;
                break;
            }
            case -1: {
                bl = this.rsmd.desc[n].dbms_type != 28;
                break;
            }
            case 2004: {
                n2 = -4;
                break;
            }
            case 2005: {
                n2 = -1;
                bl = this.rsmd.desc[n].dbms_type != 29;
                break;
            }
            case 93: {
                bl = this.rsmd.desc[n].dbms_type == 3;
            }
        }
        this.params.init(n, n2, bl);
    }

    private void copyParams() throws SQLException {
        block23: for (int i = 0; i < this.rsmd.count; ++i) {
            if (!this.params.isSet(i)) continue;
            SqlData sqlData = this.currentRow.columns[i];
            switch (this.rsmd.desc[i].sql_type) {
                case 0: {
                    continue block23;
                }
                case -6: {
                    ((SqlTinyInt)sqlData).set((SqlTinyInt)this.params.getValue(i));
                    continue block23;
                }
                case 5: {
                    ((SqlSmallInt)sqlData).set((SqlSmallInt)this.params.getValue(i));
                    continue block23;
                }
                case 4: {
                    ((SqlInt)sqlData).set((SqlInt)this.params.getValue(i));
                    continue block23;
                }
                case -5: {
                    ((SqlBigInt)sqlData).set((SqlBigInt)this.params.getValue(i));
                    continue block23;
                }
                case 7: {
                    ((SqlReal)sqlData).set((SqlReal)this.params.getValue(i));
                    continue block23;
                }
                case 6: 
                case 8: {
                    ((SqlDouble)sqlData).set((SqlDouble)this.params.getValue(i));
                    continue block23;
                }
                case 2: 
                case 3: {
                    ((SqlDecimal)sqlData).set((SqlDecimal)this.params.getValue(i));
                    continue block23;
                }
                case 16: {
                    ((SqlBool)sqlData).set((SqlBool)this.params.getValue(i));
                    continue block23;
                }
                case 91: {
                    ((SqlDate)sqlData).set((SqlDate)this.params.getValue(i));
                    continue block23;
                }
                case 92: {
                    ((SqlTime)sqlData).set((SqlTime)this.params.getValue(i));
                    continue block23;
                }
                case 93: {
                    switch (this.rsmd.desc[i].dbms_type) {
                        case 3: {
                            ((IngresDate)sqlData).set((IngresDate)this.params.getValue(i));
                            continue block23;
                        }
                    }
                    ((SqlTimestamp)sqlData).set((SqlTimestamp)this.params.getValue(i));
                    continue block23;
                }
                case -2: {
                    ((SqlByte)sqlData).set((SqlByte)this.params.getValue(i));
                    continue block23;
                }
                case -3: {
                    ((SqlVarByte)sqlData).set((SqlVarByte)this.params.getValue(i));
                    continue block23;
                }
                case -15: 
                case 1: {
                    if (this.rsmd.desc[i].dbms_type != 26) {
                        ((SqlChar)sqlData).set((SqlChar)this.params.getValue(i));
                        continue block23;
                    }
                    ((SqlNChar)sqlData).set((SqlNChar)this.params.getValue(i));
                    continue block23;
                }
                case -9: 
                case 12: {
                    if (this.rsmd.desc[i].dbms_type != 27) {
                        ((SqlVarChar)sqlData).set((SqlVarChar)this.params.getValue(i));
                        continue block23;
                    }
                    ((SqlNVarChar)sqlData).set((SqlNVarChar)this.params.getValue(i));
                    continue block23;
                }
                case -16: 
                case -4: 
                case -1: {
                    continue block23;
                }
                case 2004: 
                case 2005: {
                    continue block23;
                }
                default: {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": unexpected SQL type " + this.rsmd.desc[i].sql_type);
                    }
                    throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                }
            }
        }
    }

    @Override
    protected int columnMap(int n) throws SQLException {
        if (!this.insert) {
            return super.columnMap(n);
        }
        if (this.posStatus == 0) {
            throw SqlExFactory.get(ERR_GC401D_RESULTSET_CLOSED);
        }
        if (n < 1 || n > this.rsmd.count) {
            throw SqlExFactory.get(ERR_GC4011_INDEX_RANGE);
        }
        return n - 1;
    }

    @Override
    protected SqlData getSqlData(int n) throws SQLException {
        SqlData sqlData;
        if (this.params.isSet(n)) {
            sqlData = this.params.getValue(n);
        } else if (!this.insert) {
            sqlData = super.getSqlData(n);
        } else {
            throw SqlExFactory.get(ERR_GC4011_INDEX_RANGE);
        }
        return sqlData;
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        this.updateClob(n, (Clob)nClob);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader, -1L);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, l);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        this.updateString(n, string);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader, -1L);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, l);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n, inputStream, -1L);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(n, inputStream, l);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader, -1L);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(n, reader, (long)n2);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader, -1L);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, l);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n, inputStream, -1L);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(n, inputStream, (long)n2);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(n, inputStream, -1L);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(n, inputStream, (long)n2);
    }
}

