/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.ByteBuffer;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlExFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BufferedBlob
implements Blob,
GcfErr {
    private ByteBuffer buff = null;

    public BufferedBlob() {
        this.buff = new ByteBuffer();
    }

    public BufferedBlob(int n) {
        this.buff = new ByteBuffer(n);
    }

    public BufferedBlob(InputStream inputStream) {
        this.buff = new ByteBuffer(inputStream);
    }

    public BufferedBlob(int n, InputStream inputStream) {
        this.buff = new ByteBuffer(n, inputStream);
    }

    public BufferedBlob(ByteBuffer byteBuffer) {
        this.buff = byteBuffer;
    }

    @Override
    public long length() throws SQLException {
        this.checkValid();
        return this.buff.length();
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkValid();
        return this.buff.getIS();
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        this.checkValid();
        return this.buff.getIS(l, l2);
    }

    @Override
    public void free() throws SQLException {
        if (this.buff != null) {
            this.buff.free();
            this.buff = null;
        }
    }

    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        this.checkValid();
        if (l < 1L || n < 0) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        long l2 = this.buff.length();
        l = Math.min(l - 1L, l2);
        n = (int)Math.max(0L, Math.min(l2 - l, (long)n));
        byte[] byArray = new byte[n];
        if (n > 0 && (int)this.buff.read(l, byArray, 0, n) != n) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        return byArray;
    }

    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        this.checkValid();
        if (byArray == null || l < 1L) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        return (l = this.buff.find(byArray, l - 1L)) >= 0L ? l + 1L : -1L;
    }

    @Override
    public long position(Blob blob, long l) throws SQLException {
        long l2;
        if (blob == null || (l2 = blob.length()) > Integer.MAX_VALUE) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        return this.position(blob.getBytes(1L, (int)l2), l);
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        this.checkValid();
        if (byArray == null || n2 < 0 || l < 1L || l > this.buff.length() + 1L || n < 0 || n > byArray.length) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        return (int)this.buff.write(l - 1L, byArray, n, n2);
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        this.checkValid();
        OutputStream outputStream = this.buff.getOS(l - 1L);
        if (outputStream == null) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        return outputStream;
    }

    @Override
    public void truncate(long l) throws SQLException {
        this.checkValid();
        if (l < 0L) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        this.buff.truncate(l);
    }

    private void checkValid() throws SQLException {
        if (this.buff == null) {
            throw SqlExFactory.get(ERR_GC4022_LOB_FREED);
        }
    }
}

