/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.ByteArray;
import com.ingres.gcf.util.SqlData;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public class SqlVarByte
extends SqlData
implements ByteArray {
    private static final byte[] empty = new byte[0];
    protected byte[] value = empty;
    protected int limit = -1;
    protected int length = 0;

    public SqlVarByte() {
        super(true);
    }

    public SqlVarByte(int n) {
        this();
        this.limit = n;
    }

    @Override
    public int capacity() {
        return this.value.length;
    }

    @Override
    public void ensureCapacity(int n) {
        this.ensure(n);
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public void limit(int n) {
        int n2 = this.limit = n < 0 ? -1 : n;
        if (this.limit >= 0 && this.length > this.limit) {
            this.length = this.limit;
        }
    }

    @Override
    public void limit(int n, boolean bl) {
        this.limit(n);
        if (bl) {
            this.ensure(n);
        }
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void clear() {
        this.setNotNull();
        this.length = 0;
    }

    public void set(SqlVarByte sqlVarByte) {
        if (sqlVarByte == null || sqlVarByte.isNull()) {
            this.setNull();
        } else {
            this.clear();
            this.put(sqlVarByte.value, 0, sqlVarByte.length);
        }
    }

    @Override
    public int put(byte by) {
        if (this.limit >= 0 && this.length >= this.limit) {
            return 0;
        }
        this.ensure(this.length + 1);
        this.value[this.length++] = by;
        return 1;
    }

    @Override
    public int put(byte[] byArray) {
        return this.put(byArray, 0, byArray.length);
    }

    @Override
    public int put(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n3 = this.limit < 0 ? n2 : this.limit - this.length;
        if (n2 > n3) {
            n2 = n3;
        }
        this.ensure(this.length + n2);
        System.arraycopy(byArray, n, this.value, this.length, n2);
        this.length += n2;
        return n2;
    }

    @Override
    public byte get(int n) {
        return n >= this.length ? (byte)0 : this.value[n];
    }

    @Override
    public byte[] get() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.value, 0, byArray, 0, this.length);
        return byArray;
    }

    @Override
    public int get(byte[] byArray) {
        return this.get(0, byArray.length, byArray, 0);
    }

    @Override
    public int get(int n, int n2, byte[] byArray, int n3) {
        int n4;
        int n5 = n4 = n >= this.length ? 0 : this.length - n;
        if (n2 > n4) {
            n2 = n4;
        }
        System.arraycopy(this.value, n, byArray, n3, n2);
        return n2;
    }

    protected void ensure(int n) {
        if (this.limit >= 0 && n > this.limit) {
            n = this.limit;
        }
        if (n > this.value.length) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.value, 0, byArray, 0, this.length);
            this.value = byArray;
        }
    }

    @Override
    public void setString(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            this.setBytes(string.getBytes());
        }
    }

    @Override
    public void setBytes(byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull();
        } else {
            this.clear();
            this.put(byArray);
        }
    }

    @Override
    public String getString() throws SQLException {
        return this.getString(this.length);
    }

    @Override
    public String getString(int n) throws SQLException {
        if (n > this.length) {
            n = this.length;
        }
        return SqlVarByte.bin2str(this.value, 0, n);
    }

    @Override
    public byte[] getBytes() throws SQLException {
        return this.getBytes(this.length);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        if (n > this.length) {
            n = this.length;
        }
        byte[] byArray = new byte[n];
        this.get(0, n, byArray, 0);
        return byArray;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return SqlVarByte.getBinary(this.value, 0, this.length);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return SqlVarByte.getAscii(this.getString());
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        return SqlVarByte.getUnicode(this.getString());
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return SqlVarByte.getCharacter(this.getString());
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getBytes();
    }

    @Override
    public Object getObject(int n) throws SQLException {
        return this.getBytes(n);
    }

    public static String bin2str(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        while (n2 > 0) {
            String string = Integer.toHexString(byArray[n] & 0xFF);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            ++n;
            --n2;
        }
        return stringBuffer.toString();
    }
}

