/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.Config;
import com.ingres.gcf.util.ConfigEmpty;
import com.ingres.gcf.util.ConfigKey;
import com.ingres.gcf.util.ConfigSys;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TraceLog {
    private static final String TRACE_KEY_PREFIX = "trace";
    private static final String TRACE_LOG_KEY = "log";
    private static final String TRACE_TIME_KEY = "timestamp";
    private static final int HEXBUFLEN = 68;
    private static Hashtable trace_logs = new Hashtable();
    private static TraceLog default_log = null;
    private static Date now = new Date();
    private static long last_time = 0L;
    private static String last_ts = "";
    private static DateFormat df_ts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static TraceLog getTraceLog() {
        if (default_log == null) {
            default_log = TraceLog.getTraceLog(new ConfigEmpty());
        }
        return default_log;
    }

    public static TraceLog getTraceLog(String string) {
        TraceLog traceLog = (TraceLog)trace_logs.get(string);
        if (traceLog == null) {
            Config config = new ConfigSys();
            config = new ConfigKey(string, config);
            traceLog = TraceLog.getTraceLog(config);
            trace_logs.put(string, traceLog);
        }
        return traceLog;
    }

    public static TraceLog getTraceLog(String string, Config config) {
        TraceLog traceLog = (TraceLog)trace_logs.get(string);
        if (traceLog == null) {
            traceLog = TraceLog.getTraceLog(config);
            trace_logs.put(string, traceLog);
        }
        return traceLog;
    }

    public static TraceLog getTraceLog(Config config) {
        String string = (config = new ConfigKey(TRACE_KEY_PREFIX, config)).get(TRACE_LOG_KEY);
        if (string != null) {
            FileLog fileLog = new FileLog(config);
            ((TraceLog)fileLog).setTraceLog(string);
            return fileLog;
        }
        string = config.getKey(TRACE_LOG_KEY);
        Logger logger = Logger.getLogger(string);
        if (logger != null && logger.getLevel() != null) {
            return new JavaLog(logger, config.getKey());
        }
        return new FileLog(config);
    }

    public abstract boolean enabled();

    public abstract boolean setTraceLog(String var1);

    public abstract TraceLevel getTraceLevel(String var1);

    public abstract void write(String var1);

    public abstract void hexdump(byte[] var1, int var2, int var3);

    private static int hexformat(byte[] byArray, int n, int n2, char[] cArray) {
        if (n2 > 16) {
            n2 = 16;
        }
        Arrays.fill(cArray, ' ');
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3 * 3] = hex[byArray[n] >> 4 & 0xF];
            cArray[n3 * 3 + 1] = hex[byArray[n] & 0xF];
            cArray[52 + n3] = byArray[n] >= 32 && byArray[n] < 127 ? (int)byArray[n] : 46;
            ++n3;
            ++n;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String timestamp() {
        long l = System.currentTimeMillis();
        if (l != last_time) {
            Date date = now;
            synchronized (date) {
                last_time = l;
                now.setTime(last_time);
                last_ts = df_ts.format(now);
            }
        }
        return last_ts;
    }

    private static class JavaLog
    extends TraceLog {
        private Logger java_log = null;
        private String prefix = null;
        private Hashtable levels = new Hashtable();
        private static char[] hex_buff = new char[68];
        private static final int LEVEL1 = Level.INFO.intValue();
        private static final int LEVEL2 = Level.FINE.intValue();
        private static final int LEVEL3 = Level.FINER.intValue();
        private static final int LEVEL4 = Level.FINEST.intValue();
        private static final int LEVEL5 = 0;

        public JavaLog(Logger logger, String string) {
            this.java_log = logger;
            this.prefix = string;
        }

        @Override
        public boolean enabled() {
            return this.java_log != null;
        }

        @Override
        public boolean setTraceLog(String string) {
            return false;
        }

        @Override
        public TraceLevel getTraceLevel(String string) {
            TraceLevel traceLevel = (TraceLevel)this.levels.get(string);
            if (traceLevel == null) {
                Level level;
                int n = 0;
                Logger logger = Logger.getLogger(this.prefix + "." + string);
                Level level2 = level = logger == null ? null : logger.getLevel();
                if (level != null) {
                    int n2 = level.intValue();
                    if (n2 <= 0) {
                        n = 5;
                    } else if (n2 <= LEVEL4) {
                        n = 4;
                    } else if (n2 <= LEVEL3) {
                        n = 3;
                    } else if (n2 <= LEVEL2) {
                        n = 2;
                    } else if (n2 <= LEVEL1) {
                        n = 1;
                    }
                }
                traceLevel = new TraceLevel(n);
                this.levels.put(string, traceLevel);
            }
            return traceLevel;
        }

        @Override
        public void write(String string) {
            if (this.java_log != null) {
                this.java_log.info(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void hexdump(byte[] byArray, int n, int n2) {
            if (this.java_log == null) return;
            char[] cArray = hex_buff;
            synchronized (hex_buff) {
                while (n2 > 0) {
                    int n3 = TraceLog.hexformat(byArray, n, n2, JavaLog.hex_buff);
                    this.java_log.info(new String(hex_buff));
                    n += n3;
                    n2 -= n3;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }
    }

    private static class FileLog
    extends TraceLog {
        private Config config = null;
        private PrintWriter trace_log = null;
        private Hashtable levels = new Hashtable();
        private boolean trace_time = false;
        private static char[] hex_buff = new char[68];

        public FileLog(Config config) {
            this.config = config;
            String string = this.config.get(TraceLog.TRACE_TIME_KEY);
            if (string != null) {
                this.trace_time = string.equalsIgnoreCase("on") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("enable") || string.equalsIgnoreCase("enabled");
            }
        }

        protected void finalize() throws Throwable {
            this.setTraceLog(null);
            super.finalize();
        }

        @Override
        public boolean enabled() {
            return this.trace_log != null;
        }

        @Override
        public boolean setTraceLog(String string) {
            boolean bl = true;
            if (this.trace_log != null) {
                this.trace_log.close();
                this.trace_log = null;
            }
            if (string != null) {
                try {
                    this.trace_log = new PrintWriter(new FileOutputStream(string), true);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.trace_log = null;
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public TraceLevel getTraceLevel(String string) {
            TraceLevel traceLevel = (TraceLevel)this.levels.get(string);
            if (traceLevel == null) {
                int n = 0;
                String string2 = this.config.get(string);
                if (string2 != null) {
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                traceLevel = new TraceLevel(n);
                this.levels.put(string, traceLevel);
            }
            return traceLevel;
        }

        @Override
        public void write(String string) {
            if (this.trace_log != null) {
                if (this.trace_time) {
                    this.trace_log.print(TraceLog.timestamp());
                    this.trace_log.print(": ");
                }
                this.trace_log.println(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void hexdump(byte[] byArray, int n, int n2) {
            if (this.trace_log == null) return;
            char[] cArray = hex_buff;
            synchronized (hex_buff) {
                while (n2 > 0) {
                    int n3 = TraceLog.hexformat(byArray, n, n2, FileLog.hex_buff);
                    this.trace_log.println(hex_buff);
                    n += n3;
                    n2 -= n3;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }
    }

    public static class TraceLevel {
        private int level;

        public TraceLevel(int n) {
            this.level = n;
        }

        public int get() {
            return this.level;
        }

        public synchronized int set(int n) {
            int n2 = this.level;
            this.level = n;
            return n2;
        }
    }
}

