/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvTrace;
import com.ingres.gcf.jdbc.JdbcCPVirt;
import com.ingres.gcf.jdbc.JdbcConn;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlExFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class JdbcCPConn
implements PooledConnection,
ConnectionEventListener,
GcfErr {
    protected JdbcConn physConn = null;
    protected JdbcCPVirt virtConn = null;
    protected DrvTrace trace = null;
    protected String title = null;
    protected String tr_id = "CPConn";
    protected int inst_id = 0;
    private Vector listeners = new Vector();
    private static int inst_count = 0;

    JdbcCPConn(JdbcConn jdbcConn, DrvTrace drvTrace) {
        this.physConn = jdbcConn;
        this.trace = drvTrace;
        this.inst_id = inst_count++;
        this.title = drvTrace.getTraceName() + "-PooledConnection[" + this.inst_id + "]";
        this.tr_id = this.tr_id + "[" + this.inst_id + "]";
    }

    public String toString() {
        return this.title;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.physConn == null) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getConnection(): connection closed!");
            }
            throw SqlExFactory.get(ERR_GC4004_CONNECTION_CLOSED);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getConnection()");
        }
        this.clearConnection();
        this.virtConn = new JdbcCPVirt(this.physConn, this, this, this.trace);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getConnection(): " + this.virtConn);
        }
        return this.virtConn;
    }

    @Override
    public void close() throws SQLException {
        if (this.physConn == null) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".close(): connection closed! ");
            }
        } else {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".close()");
            }
            this.clearConnection();
            this.physConn.close();
            this.physConn = null;
        }
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.addElement(connectionEventListener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.removeElement(connectionEventListener);
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        if (this.virtConn != null) {
            this.virtConn = null;
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ": signalling connection closed");
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.listeners.elementAt(i);
                if (connectionEventListener == null) continue;
                connectionEventListener.connectionClosed(connectionEvent);
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        if (this.virtConn != null) {
            this.virtConn = null;
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ": signalling connection error");
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.listeners.elementAt(i);
                if (connectionEventListener == null) continue;
                connectionEventListener.connectionErrorOccurred(connectionEvent);
            }
        }
    }

    protected void clearConnection() throws SQLException {
        JdbcCPVirt jdbcCPVirt = this.virtConn;
        this.virtConn = null;
        if (jdbcCPVirt != null) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ": forcing virtual connection closed");
            }
            jdbcCPVirt.close();
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
    }
}

