/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvTrace;
import com.ingres.gcf.jdbc.JdbcConn;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlExFactory;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class JdbcCPVirt
implements Connection,
GcfErr {
    protected DrvTrace trace = null;
    protected String title = null;
    protected String tr_id = "CPVirt";
    protected int inst_id = 0;
    protected JdbcConn conn = null;
    private PooledConnection pool = null;
    private ConnectionEventListener listener = null;
    private static int inst_count = 0;

    JdbcCPVirt(JdbcConn jdbcConn, PooledConnection pooledConnection, ConnectionEventListener connectionEventListener, DrvTrace drvTrace) {
        this.conn = jdbcConn;
        this.pool = pooledConnection;
        this.listener = connectionEventListener;
        this.trace = drvTrace;
        this.inst_id = inst_count++;
        this.title = drvTrace.getTraceName() + "-CPVConnection[" + this.inst_id + "]";
        this.tr_id = this.tr_id + "[" + this.inst_id + "]";
    }

    public String toString() {
        return this.title;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn != null ? this.conn.isClosed() : true;
    }

    @Override
    public void close() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".close()");
        }
        if (this.conn != null) {
            this.closeEvent();
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".abort()");
        }
        if (this.conn != null) {
            this.closeEvent();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.conn != null ? this.conn.getWarnings() : null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.conn != null) {
            this.conn.clearWarnings();
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement statement;
        this.checkConn(".createStatement()");
        try {
            statement = this.conn.createStatement();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return statement;
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        Statement statement;
        this.checkConn(".createStatement()");
        try {
            statement = this.conn.createStatement(n, n2);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return statement;
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        Statement statement;
        this.checkConn(".createStatement()");
        try {
            statement = this.conn.createStatement(n, n2, n3);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        PreparedStatement preparedStatement;
        this.checkConn(".prepareStatement()");
        try {
            preparedStatement = this.conn.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return preparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement;
        this.checkConn(".prepareStatement()");
        try {
            preparedStatement = this.conn.prepareStatement(string, n, n2);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return preparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        PreparedStatement preparedStatement;
        this.checkConn(".prepareStatement()");
        try {
            preparedStatement = this.conn.prepareStatement(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return preparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        PreparedStatement preparedStatement;
        this.checkConn(".prepareStatement()");
        try {
            preparedStatement = this.conn.prepareStatement(string, n);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return preparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        PreparedStatement preparedStatement;
        this.checkConn(".prepareStatement()");
        try {
            preparedStatement = this.conn.prepareStatement(string, nArray);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return preparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        PreparedStatement preparedStatement;
        this.checkConn(".prepareStatement()");
        try {
            preparedStatement = this.conn.prepareStatement(string, stringArray);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return preparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        CallableStatement callableStatement;
        this.checkConn(".prepareCall()");
        try {
            callableStatement = this.conn.prepareCall(string);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return callableStatement;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        CallableStatement callableStatement;
        this.checkConn(".prepareCall()");
        try {
            callableStatement = this.conn.prepareCall(string, n, n2);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return callableStatement;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        CallableStatement callableStatement;
        this.checkConn(".prepareCall()");
        try {
            callableStatement = this.conn.prepareCall(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return callableStatement;
    }

    @Override
    public int getHoldability() throws SQLException {
        int n;
        this.checkConn(".getHoldability()");
        try {
            n = this.conn.getHoldability();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return n;
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.checkConn(".setHoldability()");
        try {
            this.conn.setHoldability(n);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        this.checkConn(".nativeSQL()");
        try {
            string = this.conn.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return string;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData databaseMetaData;
        this.checkConn(".getMetaData()");
        try {
            databaseMetaData = this.conn.getMetaData();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return databaseMetaData;
    }

    @Override
    public String getCatalog() throws SQLException {
        String string;
        this.checkConn(".getCatalog()");
        try {
            string = this.conn.getCatalog();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return string;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.checkConn(".setCatalog()");
        try {
            this.conn.setCatalog(string);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public String getSchema() throws SQLException {
        String string;
        this.checkConn(".getSchema()");
        try {
            string = this.conn.getSchema();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return string;
    }

    @Override
    public void setSchema(String string) throws SQLException {
        this.checkConn(".setSchema()");
        try {
            this.conn.setSchema(string);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    public Map getTypeMap() throws SQLException {
        Map map;
        this.checkConn(".getTypeMap()");
        try {
            map = this.conn.getTypeMap();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return map;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkConn(".setTypeMap()");
        try {
            this.conn.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        int n;
        this.checkConn(".getNetworkTimeout()");
        try {
            n = this.conn.getNetworkTimeout();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return n;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        this.checkConn(".setNetworkTimeout()");
        try {
            this.conn.setNetworkTimeout(executor, n);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        boolean bl;
        this.checkConn(".isReadOnly()");
        try {
            bl = this.conn.isReadOnly();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return bl;
    }

    @Override
    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.checkConn(".setReadOnly()");
        try {
            this.conn.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        int n;
        this.checkConn(".getTransactionIsolation()");
        try {
            n = this.conn.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return n;
    }

    @Override
    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.checkConn(".setTransactionIsolation()");
        try {
            this.conn.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        boolean bl;
        this.checkConn(".getAutoCommit()");
        try {
            bl = this.conn.getAutoCommit();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return bl;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkConn(".setAutoCommit()");
        try {
            this.conn.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkConn(".commit()");
        try {
            this.conn.commit();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkConn(".rollback()");
        try {
            this.conn.rollback();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkConn(".rollback()");
        try {
            this.conn.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        Savepoint savepoint;
        this.checkConn(".setSavepoint()");
        try {
            savepoint = this.conn.setSavepoint();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return savepoint;
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        Savepoint savepoint;
        this.checkConn(".setSavepoint()");
        try {
            savepoint = this.conn.setSavepoint(string);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return savepoint;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkConn(".releaseSavepoint()");
        try {
            this.conn.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        Struct struct;
        this.checkConn(".createStruct()");
        try {
            struct = this.conn.createStruct(string, objectArray);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return struct;
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        Array array;
        this.checkConn(".createArrayOf()");
        try {
            array = this.conn.createArrayOf(string, objectArray);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return array;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        Properties properties;
        this.checkConn(".getClientInfo()");
        try {
            properties = this.conn.getClientInfo();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return properties;
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        String string2;
        this.checkConn(".getClientInfo(...)");
        try {
            string2 = this.conn.getClientInfo(string);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return string2;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
        try {
            this.checkConn(".setClientInfo(...)");
        }
        catch (SQLException sQLException) {
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), hashMap);
        }
        try {
            this.conn.setClientInfo(properties);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            try {
                if (this.conn.isClosed()) {
                    this.errorEvent(sQLClientInfoException);
                }
            }
            catch (SQLException sQLException) {
                throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), hashMap);
            }
            throw sQLClientInfoException;
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
        try {
            this.checkConn(".setClientInfo(...)");
        }
        catch (SQLException sQLException) {
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), hashMap);
        }
        try {
            this.conn.setClientInfo(string, string2);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            try {
                if (this.conn.isClosed()) {
                    this.errorEvent(sQLClientInfoException);
                }
            }
            catch (SQLException sQLException) {
                throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), hashMap);
            }
            throw sQLClientInfoException;
        }
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        return this.conn != null ? this.conn.isValid(n) : false;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        SQLXML sQLXML;
        this.checkConn(".createSQLXML()");
        try {
            sQLXML = this.conn.createSQLXML();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return sQLXML;
    }

    @Override
    public NClob createNClob() throws SQLException {
        NClob nClob;
        this.checkConn(".createNClob()");
        try {
            nClob = this.conn.createNClob();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return nClob;
    }

    @Override
    public Blob createBlob() throws SQLException {
        Blob blob;
        this.checkConn(".createBlob()");
        try {
            blob = this.conn.createBlob();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return blob;
    }

    @Override
    public Clob createClob() throws SQLException {
        Clob clob;
        this.checkConn(".createClob()");
        try {
            clob = this.conn.createClob();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return clob;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        this.checkConn(".isWrapperFor()");
        if (clazz != null) {
            return clazz.isInstance(this);
        }
        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        this.checkConn(".unwrap()");
        if (clazz != null) {
            if (!clazz.isInstance(this)) {
                throw SqlExFactory.get(ERR_GC4023_NO_OBJECT);
            }
            return clazz.cast(this);
        }
        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
    }

    protected void checkConn(String string) throws SQLException {
        if (this.conn == null) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + string + ": virtual connection closed!");
            }
            throw SqlExFactory.get(ERR_GC4004_CONNECTION_CLOSED);
        }
    }

    private void closeEvent() {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": closing virtual connection");
        }
        if (this.listener != null) {
            this.listener.connectionClosed(new ConnectionEvent(this.pool));
        }
        this.listener = null;
        this.pool = null;
        this.conn = null;
    }

    private void errorEvent(SQLException sQLException) {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ": virtual connection error");
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
        }
        if (this.listener != null) {
            this.listener.connectionErrorOccurred(new ConnectionEvent(this.pool, sQLException));
        }
        this.listener = null;
        this.pool = null;
        this.conn = null;
    }
}

