/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvObj;
import com.ingres.gcf.jdbc.JdbcBlob;
import com.ingres.gcf.jdbc.JdbcCall;
import com.ingres.gcf.jdbc.JdbcClob;
import com.ingres.gcf.jdbc.JdbcDBMD;
import com.ingres.gcf.jdbc.JdbcNlob;
import com.ingres.gcf.jdbc.JdbcPrep;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.JdbcSP;
import com.ingres.gcf.jdbc.JdbcStmt;
import com.ingres.gcf.jdbc.SqlParse;
import com.ingres.gcf.util.CharSet;
import com.ingres.gcf.util.Config;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.IngXid;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlWarn;
import com.ingres.gcf.util.XaEx;
import com.ingres.gcf.util.XaXid;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Executor;

public class JdbcConn
extends DrvObj
implements Connection,
DbmsConst {
    private boolean closed = false;
    private int isolationLevel = 8;
    private int holdability = 2;
    private JdbcSP savepoints = null;
    private JdbcDBMD dbmd = null;
    private Map type_map = new Hashtable();
    private DbXids dbXids = null;

    JdbcConn(DrvConn drvConn, Config config, int n) throws SQLException {
        this(drvConn);
        this.connect(config, n, null, null);
        drvConn.loadDbCaps();
    }

    JdbcConn(DrvConn drvConn, Config config, IngXid ingXid) throws SQLException {
        this(drvConn);
        this.connect(config, 0, ingXid, null);
    }

    JdbcConn(DrvConn drvConn, Config config, XaXid xaXid) throws SQLException {
        this(drvConn);
        this.connect(config, 0, null, xaXid);
    }

    private JdbcConn(DrvConn drvConn) {
        super(drvConn);
        drvConn.jdbc = this;
        this.title = this.trace.getTraceName() + "-Connection[" + this.msg.connID() + "]";
        this.tr_id = "Conn[" + this.msg.connID() + "]";
    }

    private void connect(Config config, int n, IngXid ingXid, XaXid xaXid) throws SQLException {
        String string = config.get("char_encode");
        if (string != null && string.length() != 0) {
            try {
                this.msg.setCharSet(new CharSet(string));
            }
            catch (Exception exception) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": unknown encoding: " + string);
                }
                throw SqlExFactory.get(ERR_GC4009_BAD_CHARSET);
            }
        } else if (this.msg.getCharSet() == null) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ": failed to establish character encoding!");
            }
            throw SqlExFactory.get(ERR_GC4009_BAD_CHARSET);
        }
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": Connecting to database");
        }
        try {
            this.msg.begin((byte)1);
            this.client_parms(config);
            this.driver_parms(this.checkLocalUser(config), n, ingXid, xaXid);
            this.msg.done(true);
            this.readResults();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": error connecting to database");
            }
            this.conn.close();
            throw sQLException;
        }
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": connected to database");
        }
    }

    private boolean checkLocalUser(Config config) {
        String string;
        return this.msg.isLocal() && !this.conn.is_dtmc && this.conn.msg_protocol_level >= 3 && ((string = config.get("user")) == null || string.length() == 0);
    }

    private void client_parms(Config config) throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ": sending connection parameters");
        }
        for (int i = 0; i < propInfo.length; ++i) {
            String string = config.get(JdbcConn.propInfo[i].name);
            if (string == null || string.length() == 0) continue;
            switch (JdbcConn.propInfo[i].msgID) {
                case 1: {
                    this.conn.database = string;
                    this.msg.write(JdbcConn.propInfo[i].msgID);
                    this.msg.write(string);
                    break;
                }
                case 3: {
                    String string2 = config.get("user");
                    if (string2 != null && string2.length() > 0) {
                        this.msg.write(JdbcConn.propInfo[i].msgID);
                        this.msg.write(this.msg.encode(string2, this.conn.session_mask, string));
                    }
                    string = "*****";
                    break;
                }
                case 7: {
                    this.msg.write(JdbcConn.propInfo[i].msgID);
                    this.msg.write(string);
                    string = "*****";
                    break;
                }
                case 9: {
                    byte by;
                    if (string.equalsIgnoreCase("off")) {
                        by = 0;
                    } else if (string.equalsIgnoreCase("on")) {
                        by = 1;
                    } else {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": connection pool '" + string + "'");
                        }
                        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
                    }
                    this.msg.write(JdbcConn.propInfo[i].msgID);
                    this.msg.write((short)1);
                    this.msg.write(by);
                    break;
                }
                case 10: {
                    byte by;
                    if (string.equalsIgnoreCase("dbms")) {
                        by = 0;
                    } else if (string.equalsIgnoreCase("single")) {
                        by = 1;
                    } else if (string.equalsIgnoreCase("multi")) {
                        by = 2;
                    } else {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": autocommit mode '" + string + "'");
                        }
                        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
                    }
                    if (this.conn.msg_protocol_level >= 2) {
                        this.msg.write(JdbcConn.propInfo[i].msgID);
                        this.msg.write((short)1);
                        this.msg.write(by);
                        break;
                    }
                    if (by == 0) break;
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": autocommit mode '" + string + "' @ proto lvl " + this.conn.msg_protocol_level);
                    }
                    throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
                }
                case 15: {
                    byte by;
                    if (string.equalsIgnoreCase("login")) {
                        by = 0;
                    } else if (string.equalsIgnoreCase("connect")) {
                        by = 1;
                    } else {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": vnode usage '" + string + "'");
                        }
                        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
                    }
                    if (this.conn.msg_protocol_level >= 3) {
                        this.msg.write(JdbcConn.propInfo[i].msgID);
                        this.msg.write((short)1);
                        this.msg.write(by);
                        break;
                    }
                    if (by == 1) break;
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": vnode usage '" + string + "' @ proto lvl " + this.conn.msg_protocol_level);
                    }
                    throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
                }
                case 20: {
                    if (this.conn.msg_protocol_level < 3) break;
                    this.conn.is_gmt = false;
                    this.msg.write(JdbcConn.propInfo[i].msgID);
                    this.msg.write(string);
                    break;
                }
                case 21: 
                case 22: 
                case 23: {
                    if (this.conn.msg_protocol_level < 3) break;
                    this.msg.write(JdbcConn.propInfo[i].msgID);
                    this.msg.write(string);
                    break;
                }
                case 24: {
                    if (this.conn.msg_protocol_level < 3) break;
                    this.msg.write(JdbcConn.propInfo[i].msgID);
                    this.msg.write((short)1);
                    try {
                        this.msg.write(Byte.parseByte(string));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": money prec '" + string + "'");
                        }
                        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
                    }
                }
                case 25: {
                    if (string.equalsIgnoreCase("ingresdate")) {
                        bl3 = true;
                    } else if (!string.equalsIgnoreCase("ansidate")) {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": date alias '" + string + "'");
                        }
                        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
                    }
                    if (this.conn.msg_protocol_level >= 6) {
                        this.msg.write(JdbcConn.propInfo[i].msgID);
                        this.msg.write(string);
                    }
                    bl = true;
                    break;
                }
                case -1: {
                    if (string.equalsIgnoreCase("off")) {
                        this.conn.select_loops = false;
                        break;
                    }
                    if (string.equalsIgnoreCase("on")) {
                        this.conn.select_loops = true;
                        break;
                    }
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": select loop '" + string + "'");
                    }
                    throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
                }
                case -2: {
                    if (string.equalsIgnoreCase("dbms")) {
                        this.conn.cursor_mode = -1;
                        break;
                    }
                    if (string.equalsIgnoreCase("update")) {
                        this.conn.cursor_mode = 1;
                        break;
                    }
                    if (string.equalsIgnoreCase("readonly")) {
                        this.conn.cursor_mode = 0;
                        break;
                    }
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": cursor mode '" + string + "'");
                    }
                    throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
                }
                case -3: {
                    break;
                }
                case -4: {
                    if (string.equalsIgnoreCase("false")) {
                        this.conn.cnf_flags &= ~1024;
                    } else if (string.equalsIgnoreCase("true")) {
                        this.conn.cnf_flags |= 0x400;
                        bl3 = true;
                    } else {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": send ingres dates '" + string + "'");
                        }
                        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
                    }
                    bl2 = true;
                    break;
                }
                case -5: {
                    if (string.equalsIgnoreCase("true")) {
                        this.conn.cnf_flags |= 0x800;
                        break;
                    }
                    if (string.equalsIgnoreCase("false")) {
                        this.conn.cnf_flags &= ~2048;
                        break;
                    }
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": send integer booleans '" + string + "'");
                    }
                    throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
                }
                case -6: {
                    if (string.equalsIgnoreCase("on")) {
                        this.conn.cnf_flags |= 0x1000;
                        break;
                    }
                    if (string.equalsIgnoreCase("off")) {
                        this.conn.cnf_flags &= ~4096;
                        break;
                    }
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": identity query '" + string + "'");
                    }
                    throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
                }
                case -7: {
                    break;
                }
                default: {
                    this.msg.write(JdbcConn.propInfo[i].msgID);
                    this.msg.write(string);
                }
            }
            if (!this.trace.enabled(3)) continue;
            this.trace.write("    " + JdbcConn.propInfo[i].desc + ": '" + string + "'");
        }
        if (!bl && this.conn.msg_protocol_level >= 6) {
            String string = bl3 ? "ingresdate" : "ansidate";
            this.msg.write((short)25);
            this.msg.write(string);
            if (this.trace.enabled(3)) {
                this.trace.write("    Date Alias (default): '" + string + "'");
            }
        }
        if (!bl2) {
            this.conn.cnf_flags = bl3 ? (this.conn.cnf_flags |= 0x400) : (this.conn.cnf_flags &= ~1024);
            if (this.trace.enabled(3)) {
                this.trace.write("    Send Ingres Dates (default): '" + bl3 + "'");
            }
        }
    }

    private void driver_parms(boolean bl, int n, IngXid ingXid, XaXid xaXid) throws SQLException {
        String string = null;
        try {
            string = System.getProperty("user.name");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (bl && string != null) {
            if (this.trace.enabled(3)) {
                this.trace.write("    Login Type: 'user'");
            }
            this.msg.write((short)15);
            this.msg.write((short)1);
            this.msg.write((byte)2);
            this.msg.write((short)2);
            this.msg.write(string);
            this.msg.write((short)3);
            this.msg.write(this.msg.encode(string, this.conn.session_mask, string));
        }
        if (n != 0) {
            if (this.trace.enabled(3)) {
                this.trace.write("    Timeout: " + n);
            }
            n = n < 0 ? -n : n * 1000;
            this.msg.write((short)8);
            this.msg.write((short)4);
            this.msg.write(n);
        }
        if (ingXid != null && this.conn.msg_protocol_level >= 2) {
            if (this.trace.enabled(3)) {
                this.trace.write("    Ingres Transaction ID: " + ingXid);
            }
            this.msg.write((short)11);
            this.msg.write((short)8);
            this.msg.write((int)ingXid.getID());
            this.msg.write((int)(ingXid.getID() >> 32));
            this.conn.autoCommit = false;
        }
        if (xaXid != null && this.conn.msg_protocol_level >= 2) {
            if (this.trace.enabled(3)) {
                this.trace.write("    XA Transaction ID: " + xaXid);
            }
            this.msg.write((short)12);
            this.msg.write((short)4);
            this.msg.write(xaXid.getFormatId());
            this.msg.write((short)13);
            this.msg.write(xaXid.getGlobalTransactionId());
            this.msg.write((short)14);
            this.msg.write(xaXid.getBranchQualifier());
            this.conn.autoCommit = false;
        }
        if (this.conn.msg_protocol_level >= 3) {
            String string2;
            if (this.trace.enabled(3)) {
                this.trace.write("    Autocommit State: " + (this.conn.autoCommit ? "on" : "off"));
            }
            this.msg.write((short)16);
            this.msg.write((short)1);
            this.msg.write(this.conn.autoCommit ? (byte)1 : 0);
            if (string != null) {
                if (this.trace.enabled(3)) {
                    this.trace.write("    Local User ID: " + string);
                }
                this.msg.write((short)17);
                this.msg.write(string);
            }
            if ((string2 = this.msg.getLocalHost()) != null && string2.length() > 0) {
                if (this.trace.enabled(3)) {
                    this.trace.write("    Local Host: " + string2);
                }
                this.msg.write((short)18);
                this.msg.write(string2);
            }
            if ((string2 = this.msg.getLocalAddr()) != null && string2.length() > 0) {
                if (this.trace.enabled(3)) {
                    this.trace.write("    Local Address: " + string2);
                }
                this.msg.write((short)19);
                this.msg.write(string2);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.check(false)) {
            this.msg.abort();
        }
        super.finalize();
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.check(false);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isClosed(): " + this.closed);
        }
        return this.closed;
    }

    @Override
    public void close() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".close()");
        }
        this.warnings = null;
        if (!this.check(false)) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ": connection already closed");
            }
            return;
        }
        this.msg.lock();
        try {
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ": Closing DBMS connection");
            }
            this.msg.begin((byte)2);
            this.msg.done(true);
            this.readResults();
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ": DBMS connection closed");
            }
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".close(): error closing connection");
            }
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.msg.unlock();
            this.conn.close();
        }
        this.conn.autoCommit = false;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        SecurityManager securityManager;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".abort()");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SQLPermission("callAbort"));
        }
        if (this.check(false)) {
            this.closed = true;
            if (executor == null) {
                this.msg.abort();
            } else {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        JdbcConn.this.msg.abort();
                    }
                });
            }
        }
    }

    private boolean check(boolean bl) throws SQLException {
        if (this.closed || this.msg.isClosed()) {
            this.closed = true;
            if (bl) {
                throw SqlExFactory.get(ERR_GC4004_CONNECTION_CLOSED);
            }
            return false;
        }
        return true;
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".createStatement()");
        }
        return this.createStmt(1003, -1, this.holdability);
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".createStatement(" + n + "," + n2 + ")");
        }
        switch (n2) {
            case 1007: {
                n2 = 0;
                break;
            }
            case 1008: {
                n2 = 1;
                break;
            }
            default: {
                this.warnings = null;
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        return this.createStmt(n, n2, this.holdability);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".createStatement(" + n + "," + n2 + "," + n3 + ")");
        }
        switch (n2) {
            case 1007: {
                n2 = 0;
                break;
            }
            case 1008: {
                n2 = 1;
                break;
            }
            default: {
                this.warnings = null;
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        return this.createStmt(n, n2, n3);
    }

    private JdbcStmt createStmt(int n, int n2, int n3) throws SQLException {
        boolean bl = false;
        this.warnings = null;
        this.check(true);
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted when DTMC");
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        switch (n) {
            case 1003: {
                break;
            }
            case 1004: 
            case 1005: {
                if (this.conn.msg_protocol_level >= 6) break;
                if (this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ": ResultSet type SCROLL requested, type FORWARD provided");
                }
                n = 1003;
                bl = true;
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        switch (n2) {
            case -1: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        switch (n3) {
            case 2: {
                break;
            }
            case 1: {
                if (this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ": ResultSet HOLD requested, type CLOSE provided");
                }
                n3 = 2;
                bl = true;
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        JdbcStmt jdbcStmt = new JdbcStmt(this.conn, n, n2, n3);
        if (bl) {
            this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".createStatement(): " + jdbcStmt);
        }
        return jdbcStmt;
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareStatement('" + string + "')");
        }
        return this.createPrep(string, 1003, -1, this.holdability, false);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareStatement('" + string + "'," + n + "," + n2 + ")");
        }
        switch (n2) {
            case 1007: {
                n2 = 0;
                break;
            }
            case 1008: {
                n2 = 1;
                break;
            }
            default: {
                this.warnings = null;
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        return this.createPrep(string, n, n2, this.holdability, false);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareStatement('" + string + "'," + n + "," + n2 + "," + n3 + ")");
        }
        switch (n2) {
            case 1007: {
                n2 = 0;
                break;
            }
            case 1008: {
                n2 = 1;
                break;
            }
            default: {
                this.warnings = null;
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        return this.createPrep(string, n, n2, n3, false);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareStatement('" + string + "'," + n + ")");
        }
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        return this.createPrep(string, 1003, -1, this.holdability, n == 1);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareStatement('" + string + "'," + (nArray == null ? "null" : "[" + nArray.length + "]") + ")");
        }
        return this.createPrep(string, 1003, -1, this.holdability, nArray != null && nArray.length > 0);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareStatement('" + string + "'," + (stringArray == null ? "null" : "[" + stringArray.length + "]") + ")");
        }
        return this.createPrep(string, 1003, -1, this.holdability, stringArray != null && stringArray.length > 0);
    }

    private JdbcPrep createPrep(String string, int n, int n2, int n3, boolean bl) throws SQLException {
        boolean bl2 = false;
        this.warnings = null;
        this.check(true);
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted when DTMC");
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        switch (n) {
            case 1003: {
                break;
            }
            case 1004: 
            case 1005: {
                if (this.conn.msg_protocol_level >= 6) break;
                if (this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ": ResultSet type SCROLL requested, type FORWARD provided");
                }
                n = 1003;
                bl2 = true;
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        switch (n2) {
            case -1: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        switch (n3) {
            case 2: {
                break;
            }
            case 1: {
                if (this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ": ResultSet type HOLD requested, type CLOSE provided");
                }
                n3 = 2;
                bl2 = true;
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        JdbcPrep jdbcPrep = new JdbcPrep(this.conn, string, n, n2, n3, bl);
        if (bl2) {
            this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareStatement(): " + jdbcPrep);
        }
        return jdbcPrep;
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareCall( " + string + " )");
        }
        return this.createCall(string, 1003, 1007, this.holdability);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareCall('" + string + "'," + n + "," + n2 + ")");
        }
        return this.createCall(string, n, n2, this.holdability);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareCall('" + string + "'," + n + "," + n2 + "," + n3 + ")");
        }
        return this.createCall(string, n, n2, n3);
    }

    private JdbcCall createCall(String string, int n, int n2, int n3) throws SQLException {
        boolean bl = false;
        this.warnings = null;
        this.check(true);
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted when DTMC");
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        if (this.conn.msg_protocol_level < 2) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": procedures require protocol level 2");
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        switch (n) {
            case 1003: {
                break;
            }
            case 1004: 
            case 1005: {
                bl = true;
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        switch (n2) {
            case 1007: {
                break;
            }
            case 1008: {
                bl = true;
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        switch (n3) {
            case 2: {
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        JdbcCall jdbcCall = new JdbcCall(this.conn, string);
        if (bl) {
            this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareCall()" + jdbcCall);
        }
        return jdbcCall;
    }

    @Override
    public int getHoldability() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getHoldability(): " + this.holdability);
        }
        this.check(true);
        return this.holdability;
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getHoldability(" + n + ")");
        }
        if (n != 2) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": holdable cursors not supported!");
            }
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        this.check(true);
        this.holdability = n;
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".nativeSQL( " + string + " )");
        }
        this.check(true);
        SqlParse sqlParse = new SqlParse(string, this.conn);
        string = sqlParse.parseSQL(true);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".nativeSQL: " + string);
        }
        return string;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMetaData()");
        }
        this.check(true);
        if (this.dbmd == null) {
            this.dbmd = new JdbcDBMD(this.conn);
        }
        return this.dbmd;
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCatalog(): " + null);
        }
        this.check(true);
        return null;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setCatalog( " + string + " ): ignored");
        }
        this.check(true);
    }

    @Override
    public String getSchema() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSchema(): null");
        }
        this.check(true);
        return null;
    }

    @Override
    public void setSchema(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setSchema( " + string + " ): ignored");
        }
        this.check(true);
    }

    public Map getTypeMap() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTypeMap()");
        }
        this.check(true);
        return this.type_map;
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setTypeMap()");
        }
        this.check(true);
        this.type_map = map;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        int n = this.msg.getNetworkTimeout();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getNetworkTimeout(): " + n);
        }
        this.check(true);
        return n;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setNetworkTimeout(" + n + ")");
        }
        if (n < 0) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        this.check(true);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SQLPermission("setNetworkTimeout"));
        }
        this.msg.setNetworkTimeout(executor, n);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isReadOnly(): " + this.conn.readOnly);
        }
        this.check(true);
        return this.conn.readOnly;
    }

    @Override
    public synchronized void setReadOnly(boolean bl) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setReadOnly( " + bl + " )");
        }
        this.warnings = null;
        this.check(true);
        if (this.conn.readOnly == bl) {
            return;
        }
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted when DTMC");
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        this.sendTransactionQuery(bl, this.isolationLevel);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTransactionIsolation: " + this.isolationLevel);
        }
        this.check(true);
        return this.isolationLevel;
    }

    @Override
    public synchronized void setTransactionIsolation(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setTransactionIsolation( " + n + " )");
        }
        this.warnings = null;
        this.check(true);
        if (n == this.isolationLevel) {
            return;
        }
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted when DTMC");
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        if (n != 8 && this.conn.sqlLevel < 605) {
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": Requested isolation level not supported!");
            }
            this.setWarning(SqlWarn.get(ERR_GC4019_UNSUPPORTED));
            return;
        }
        this.sendTransactionQuery(this.conn.readOnly, n);
    }

    private void sendTransactionQuery(boolean bl, int n) throws SQLException {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".sendTransactionQuery( " + bl + " , " + n + " )");
        }
        String string = "set session read ";
        string = string + (bl ? "only" : "write");
        string = string + ", isolation level ";
        Statement statement = null;
        try {
            switch (n) {
                case 1: {
                    string = string + "read uncommitted";
                    break;
                }
                case 2: {
                    string = string + "read committed";
                    break;
                }
                case 4: {
                    string = string + "repeatable read";
                    break;
                }
                case 8: {
                    string = string + "serializable";
                    break;
                }
                default: {
                    throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
                }
            }
            statement = this.createStatement();
            statement.executeUpdate(string);
            this.warnings = statement.getWarnings();
            this.conn.readOnly = bl;
            this.isolationLevel = n;
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".sendTransactionQuery(): failed!");
            }
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getAutoCommit(): " + this.conn.autoCommit);
        }
        this.check(true);
        return this.conn.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setAutoCommit( " + bl + " )");
        }
        this.warnings = null;
        this.clearSavepoints(null);
        this.check(true);
        if (bl == this.conn.autoCommit) {
            return;
        }
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted when DTMC");
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write(bl ? (short)3 : 4);
            this.msg.done(true);
            this.readResults();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".setAutoCommit(): error changing autocommit");
            }
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.msg.unlock();
        }
        this.conn.autoCommit = bl;
    }

    @Override
    public void commit() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".commit()");
        }
        this.warnings = null;
        this.clearSavepoints(null);
        this.check(true);
        if (this.conn.autoCommit) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted with autocommit enabled");
            }
            throw SqlExFactory.get(ERR_GC401F_XACT_STATE);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)1);
            this.msg.done(true);
            this.readResults();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".commit(): error committing transaction");
            }
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.msg.unlock();
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".rollback()");
        }
        this.warnings = null;
        this.clearSavepoints(null);
        this.check(true);
        if (this.conn.autoCommit) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted with autocommit enabled");
            }
            throw SqlExFactory.get(ERR_GC401F_XACT_STATE);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)2);
            this.msg.done(true);
            this.readResults();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".rollback(): error rolling back transaction");
            }
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.msg.unlock();
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".rollback(" + savepoint + ")");
        }
        this.warnings = null;
        this.check(true);
        if (this.conn.autoCommit) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted with autocommit enabled");
            }
            throw SqlExFactory.get(ERR_GC401F_XACT_STATE);
        }
        JdbcSP jdbcSP = this.savepoints;
        while (true) {
            if (jdbcSP == null) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": savepoint not found");
                }
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
            if (jdbcSP == (JdbcSP)savepoint) break;
            jdbcSP = jdbcSP.getNext();
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)2);
            this.msg.write((short)5);
            this.msg.write(jdbcSP.getName());
            this.msg.done(true);
            this.readResults();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".rollback(): error rolling back savepoint");
            }
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.msg.unlock();
        }
        this.clearSavepoints(jdbcSP);
        this.conn.clearPrepStmts();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setSavepoint()");
        }
        this.warnings = null;
        this.check(true);
        if (this.conn.autoCommit) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted with autocommit enabled");
            }
            throw SqlExFactory.get(ERR_GC401F_XACT_STATE);
        }
        if (this.conn.msg_protocol_level < 3) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": savepoints not supported @ protocol " + this.conn.msg_protocol_level);
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        String string = this.conn.dbCaps.getDbCap("SAVEPOINTS");
        if (string != null && (string.charAt(0) == 'N' || string.charAt(0) == 'n')) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": DBMS doesn't support savepoints");
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        JdbcSP jdbcSP = JdbcSP.getUnnamedSP();
        this.createSavepoint(jdbcSP);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setSavepoint: " + jdbcSP);
        }
        return jdbcSP;
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setSavepoint('" + string + "')");
        }
        this.warnings = null;
        this.check(true);
        if (this.conn.autoCommit) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted with autocommit enabled");
            }
            throw SqlExFactory.get(ERR_GC401F_XACT_STATE);
        }
        if (this.conn.msg_protocol_level < 3) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": savepoints not supported @ protocol " + this.conn.msg_protocol_level);
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        String string2 = this.conn.dbCaps.getDbCap("SAVEPOINTS");
        if (string2 != null && (string2.charAt(0) == 'N' || string2.charAt(0) == 'n')) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": DBMS doesn't support savepoints");
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        JdbcSP jdbcSP = JdbcSP.getNamedSP(string);
        this.createSavepoint(jdbcSP);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setSavepoint: " + jdbcSP);
        }
        return jdbcSP;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".releaseSavepoint(" + savepoint + ")");
        }
        this.check(true);
        JdbcSP jdbcSP = null;
        JdbcSP jdbcSP2 = this.savepoints;
        while (true) {
            if (jdbcSP2 == null) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": savepoint not found");
                }
                throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
            }
            if (jdbcSP2 == (JdbcSP)savepoint) {
                if (jdbcSP == null) {
                    this.savepoints = jdbcSP2.setNext(null);
                    break;
                }
                jdbcSP.setNext(jdbcSP2.setNext(null));
                break;
            }
            jdbcSP = jdbcSP2;
            jdbcSP2 = jdbcSP2.getNext();
        }
    }

    private void createSavepoint(JdbcSP jdbcSP) throws SQLException {
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)7);
            this.msg.write((short)5);
            this.msg.write(jdbcSP.getName());
            this.msg.done(true);
            this.readResults();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".setSavepoint: error creating savepoint");
            }
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.msg.unlock();
        }
        jdbcSP.setNext(this.savepoints);
        this.savepoints = jdbcSP;
    }

    private void clearSavepoints(JdbcSP jdbcSP) {
        while (this.savepoints != null && this.savepoints != jdbcSP) {
            this.savepoints = this.savepoints.setNext(null);
        }
    }

    String getTransactionServer() {
        String string = null;
        if (this.conn.msg_protocol_level >= 4) {
            try {
                string = this.conn.dbInfo.getDbmsInfo("ima_server");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return string;
    }

    public void startTransaction(IngXid ingXid) throws SQLException {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".startTransaction(" + ingXid + ")");
        }
        this.warnings = null;
        this.check(true);
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".startTransaction: not permitted when DTMC");
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        if (this.conn.msg_protocol_level < 2) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".startTransaction: protocol = " + this.conn.msg_protocol_level);
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)5);
            this.msg.write((short)1);
            this.msg.write((short)8);
            this.msg.write((int)ingXid.getID());
            this.msg.write((int)(ingXid.getID() >> 32));
            this.msg.done(true);
            this.readResults();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".startTransaction: error starting xact");
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.msg.unlock();
        }
    }

    public void startTransaction(XaXid xaXid) throws SQLException {
        this.startTransaction(xaXid, 0);
    }

    public void startTransaction(XaXid xaXid, int n) throws SQLException, XaEx {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".startTransaction( " + xaXid + ", 0x" + Integer.toHexString(n) + " )");
        }
        this.warnings = null;
        this.check(true);
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".startTransaction: not permitted when DTMC");
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        if (this.conn.msg_protocol_level < 2 || n != 0 && this.conn.msg_protocol_level < 5) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".startTransaction: protocol = " + this.conn.msg_protocol_level);
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)5);
            this.msg.write((short)2);
            this.msg.write((short)4);
            this.msg.write(xaXid.getFormatId());
            this.msg.write((short)3);
            this.msg.write(xaXid.getGlobalTransactionId());
            this.msg.write((short)4);
            this.msg.write(xaXid.getBranchQualifier());
            if (n != 0) {
                this.msg.write((short)6);
                this.msg.write((short)4);
                this.msg.write(n);
            }
            this.msg.done(true);
            this.readResults();
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".startTransaction: XA error starting xact - " + xaEx.getErrorCode());
            }
            throw xaEx;
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".startTransaction: error starting xact");
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.msg.unlock();
        }
    }

    public void endTransaction(XaXid xaXid) throws SQLException, XaEx {
        this.endTransaction(xaXid, 0);
    }

    public void endTransaction(XaXid xaXid, int n) throws SQLException, XaEx {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".endTransaction( " + xaXid + ", 0x" + Integer.toHexString(n) + " )");
        }
        this.warnings = null;
        this.check(true);
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".endTransaction: not permitted when DTMC");
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        if (this.conn.msg_protocol_level < 5) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".endTransaction: protocol = " + this.conn.msg_protocol_level);
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)9);
            this.msg.write((short)2);
            this.msg.write((short)4);
            this.msg.write(xaXid.getFormatId());
            this.msg.write((short)3);
            this.msg.write(xaXid.getGlobalTransactionId());
            this.msg.write((short)4);
            this.msg.write(xaXid.getBranchQualifier());
            if (n != 0) {
                this.msg.write((short)6);
                this.msg.write((short)4);
                this.msg.write(n);
            }
            this.msg.done(true);
            this.readResults();
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".endTransaction: XA error ending xact - " + xaEx.getErrorCode());
            }
            throw xaEx;
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".endTransaction: error ending xact");
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.msg.unlock();
        }
    }

    public void prepareTransaction() throws SQLException {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".prepareTransaction()");
        }
        this.warnings = null;
        this.check(true);
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepareTransaction: not permitted when DTMC");
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        if (this.conn.msg_protocol_level < 2) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepareTransaction: protocol = " + this.conn.msg_protocol_level);
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)6);
            this.msg.done(true);
            this.readResults();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepareTransaction: error preparing xact");
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.msg.unlock();
        }
    }

    public void prepareTransaction(XaXid xaXid) throws SQLException, XaEx {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".prepareTransaction(" + xaXid + ")");
        }
        this.warnings = null;
        this.check(true);
        if (this.conn.msg_protocol_level < 5) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepareTransaction: protocol = " + this.conn.msg_protocol_level);
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)6);
            this.msg.write((short)2);
            this.msg.write((short)4);
            this.msg.write(xaXid.getFormatId());
            this.msg.write((short)3);
            this.msg.write(xaXid.getGlobalTransactionId());
            this.msg.write((short)4);
            this.msg.write(xaXid.getBranchQualifier());
            this.msg.done(true);
            this.readResults();
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepareTransaction: XA error preparing xact - " + xaEx.getErrorCode());
            }
            throw xaEx;
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepareTransaction: error preparing xact");
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.msg.unlock();
        }
    }

    public void commit(XaXid xaXid) throws SQLException, XaEx {
        this.commit(xaXid, 0);
    }

    public void commit(XaXid xaXid, int n) throws SQLException, XaEx {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".commit( " + xaXid + ", 0x" + Integer.toHexString(n) + " )");
        }
        this.warnings = null;
        this.check(true);
        if (this.conn.msg_protocol_level < 5) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".commit: protocol = " + this.conn.msg_protocol_level);
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)1);
            this.msg.write((short)2);
            this.msg.write((short)4);
            this.msg.write(xaXid.getFormatId());
            this.msg.write((short)3);
            this.msg.write(xaXid.getGlobalTransactionId());
            this.msg.write((short)4);
            this.msg.write(xaXid.getBranchQualifier());
            if (n != 0) {
                this.msg.write((short)6);
                this.msg.write((short)4);
                this.msg.write(n);
            }
            this.msg.done(true);
            this.readResults();
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".commit: XA error committing transaction - " + xaEx.getErrorCode());
            }
            throw xaEx;
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".commit: error committing transaction");
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.msg.unlock();
        }
    }

    public void rollback(XaXid xaXid) throws SQLException, XaEx {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".rollback(" + xaXid + ")");
        }
        this.warnings = null;
        this.check(true);
        if (this.conn.msg_protocol_level < 5) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".rollback: protocol = " + this.conn.msg_protocol_level);
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)2);
            this.msg.write((short)2);
            this.msg.write((short)4);
            this.msg.write(xaXid.getFormatId());
            this.msg.write((short)3);
            this.msg.write(xaXid.getGlobalTransactionId());
            this.msg.write((short)4);
            this.msg.write(xaXid.getBranchQualifier());
            this.msg.done(true);
            this.readResults();
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".rollback: XA error rolling back transaction - " + xaEx.getErrorCode());
            }
            throw xaEx;
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".rollback: error rolling back transaction");
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.msg.unlock();
        }
    }

    void abortTransaction(XaXid xaXid) throws SQLException {
        this.warnings = null;
        this.check(true);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".abortTransaction( '" + xaXid + "' )");
        }
        if (!this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": DTM connection required");
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        if (this.conn.msg_protocol_level < 4) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": protocol = " + this.conn.msg_protocol_level);
            }
            throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)8);
            this.msg.write((short)2);
            this.msg.write((short)4);
            this.msg.write(xaXid.getFormatId());
            this.msg.write((short)3);
            this.msg.write(xaXid.getGlobalTransactionId());
            this.msg.write((short)4);
            this.msg.write(xaXid.getBranchQualifier());
            this.msg.done(true);
            this.readResults();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".abortTransaction(): error aborting xact");
            }
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        finally {
            this.msg.unlock();
        }
    }

    XaXid[] getPreparedTransactionIDs(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getPreparedTransactionIDs('" + string + "')");
        }
        this.warnings = null;
        this.check(true);
        if (this.conn.msg_protocol_level >= 2) {
            if (this.dbXids == null) {
                this.dbXids = new DbXids(this.conn);
            }
            return this.dbXids.readXids(string);
        }
        return new XaXid[0];
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".createStruct(..)");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".createArrayOf(..)");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getClientInfo()");
        }
        this.check(true);
        return new Properties();
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getClientInfo(...)");
        }
        this.check(true);
        return null;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setClientInfo(...)");
        }
        if (properties == null || properties.size() == 0) {
            return;
        }
        HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
        Iterator<String> iterator = properties.stringPropertyNames().iterator();
        while (iterator.hasNext()) {
            hashMap.put(iterator.next(), ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
        }
        throw new SQLClientInfoException(SqlExFactory.get(ERR_GC4019_UNSUPPORTED).getMessage(), hashMap);
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setClientInfo(...)");
        }
        HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
        hashMap.put(string, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
        throw new SQLClientInfoException(SqlExFactory.get(ERR_GC4019_UNSUPPORTED).getMessage(), hashMap);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".createSQLXML()");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public NClob createNClob() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".createNClob()");
        }
        this.check(true);
        return new JdbcNlob(this.conn.cnf_lob_segSize, this.trace);
    }

    @Override
    public Blob createBlob() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".createBlob()");
        }
        this.check(true);
        return new JdbcBlob(this.conn.cnf_lob_segSize, this.trace);
    }

    @Override
    public Clob createClob() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".createClob()");
        }
        this.check(true);
        return new JdbcClob(this.conn.cnf_lob_segSize, this.trace);
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        boolean bl = this.check(false);
        if (!bl) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".isValid( " + n + " ): " + bl);
            }
            return bl;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isValid( " + n + " )");
        }
        if (n < 0) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        Executor executor = this.msg.getTimeoutExecutor();
        int n2 = this.msg.getNetworkTimeout();
        n *= 1000;
        try {
            if (n2 <= 0 || n2 > n) {
                this.msg.setNetworkTimeout(null, n);
            }
            this.conn.dbInfo.getDbmsInfo("transaction_state");
            this.msg.setNetworkTimeout(executor, n2);
        }
        catch (SQLException sQLException) {
            this.msg.close();
            bl = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isValid(): " + bl);
        }
        return bl;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isWrapperFor(" + clazz + ")");
        }
        if (clazz != null) {
            return clazz.isInstance(this);
        }
        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".unwrap(" + clazz + ")");
        }
        if (clazz != null) {
            if (!clazz.isInstance(this)) {
                throw SqlExFactory.get(ERR_GC4023_NO_OBJECT);
            }
            return clazz.cast(this);
        }
        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
    }

    private static class DbXids
    extends DrvObj {
        private static JdbcRSMD rsmd = null;
        private Vector xids = new Vector();

        public DbXids(DrvConn drvConn) {
            super(drvConn);
            this.title = this.trace.getTraceName() + "-DbXids[" + this.msg.connID() + "]";
            this.tr_id = "DbXid[" + this.msg.connID() + "]";
        }

        public synchronized XaXid[] readXids(String string) throws SQLException {
            this.xids.clear();
            this.msg.lock();
            try {
                this.msg.begin((byte)10);
                this.msg.write((short)4);
                this.msg.write((short)4);
                this.msg.write(string);
                this.msg.done(true);
                this.readResults();
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": error retrieving XID list");
                }
                throw sQLException;
            }
            finally {
                this.msg.unlock();
            }
            XaXid[] xaXidArray = new XaXid[this.xids.size()];
            for (int i = 0; i < xaXidArray.length; ++i) {
                xaXidArray[i] = (XaXid)this.xids.get(i);
            }
            this.xids.clear();
            return xaXidArray;
        }

        @Override
        protected JdbcRSMD readDesc() throws SQLException {
            if (rsmd == null) {
                rsmd = JdbcRSMD.load(this.conn);
            } else {
                rsmd.reload(this.conn);
            }
            return rsmd;
        }

        @Override
        protected boolean readData() throws SQLException {
            while (this.msg.moreData()) {
                this.msg.readByte();
                int n = this.msg.readInt();
                this.msg.readByte();
                byte[] byArray = this.msg.readBytes();
                this.msg.readByte();
                byte[] byArray2 = this.msg.readBytes();
                this.xids.add(new XaXid(n, byArray, byArray2));
            }
            return false;
        }
    }
}

