/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlExFactory;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.X509EncodedKeySpec;
import java.sql.SQLException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;

public class Crypto
implements GcfErr {
    public static final int RSA_KEY_NONE = 0;
    public static final int RSA_KEY_1024 = 1024;
    public static final int RSA_KEY_2048 = 2048;
    public static final int RSA_KEY_3072 = 3072;
    public static final int RSA_KEY_4096 = 4096;
    public static final int AES_KEY_NONE = 0;
    public static final int AES_KEY_128 = 128;
    public static final int AES_KEY_192 = 192;
    public static final int AES_KEY_256 = 256;
    private static final String RSA_KEY_ALG = "RSA";
    private static final String AES_KEY_ALG = "AES";
    private static final String AES_CBC_ALG = "AES/CBC/PKCS5Padding";
    private static final int ASN1_EOC = 0;
    private static final int ASN1_INTEGER = 2;
    private static final int ASN1_BIT_STRING = 3;
    private static final int ASN1_NULL = 5;
    private static final int ASN1_OBJECT_ID = 6;
    private static final int ASN1_SEQUENCE = 16;
    private static int rsaMaxKey;
    private static int aesMaxKey;

    public static int maxRSAKeySize() {
        return rsaMaxKey;
    }

    public static int maxAESKeySize() {
        return aesMaxKey;
    }

    public static RSAKey generateRSAKey(int n) throws SQLException {
        RSAKey rSAKey;
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA_KEY_ALG);
            keyPairGenerator.initialize(n);
            rSAKey = new RSAKey(keyPairGenerator.generateKeyPair());
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC400C_ENCRYPTION_ERROR, exception);
        }
        return rSAKey;
    }

    public static byte[] exportRSAKey(RSAKey rSAKey) throws SQLException {
        byte[] byArray;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALG);
            X509EncodedKeySpec x509EncodedKeySpec = keyFactory.getKeySpec(rSAKey.key.getPublic(), X509EncodedKeySpec.class);
            byArray = x509EncodedKeySpec.getEncoded();
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC400C_ENCRYPTION_ERROR, exception);
        }
        return Crypto.extractRSAEncoding(byArray);
    }

    public static AESKey importAESKey(RSAKey rSAKey, byte[] byArray) throws SQLException {
        Key key = null;
        try {
            Cipher cipher = Cipher.getInstance(RSA_KEY_ALG);
            cipher.init(4, rSAKey.key.getPrivate());
            key = cipher.unwrap(byArray, AES_KEY_ALG, 3);
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC400C_ENCRYPTION_ERROR, exception);
        }
        return new AESKey(key);
    }

    public static AESSession initAESSession(AESKey aESKey, boolean bl) throws SQLException {
        return new AESSession(aESKey, bl);
    }

    private static byte[] extractRSAEncoding(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = Crypto.scanASN1Object(16, byArray, n3);
        if (n4 != 0 && (n4 = Crypto.scanASN1Object(16, byArray, n3 += n4)) != 0 && (n4 = Crypto.scanASN1Object(6, byArray, n3 += n4)) != 0 && (n4 = Crypto.scanASN1Object(5, byArray, n3 += n4)) != 0 && (n4 = Crypto.scanASN1Object(3, byArray, n3 += n4)) != 0 && (n4 = Crypto.scanASN1Object(0, byArray, n3 += n4)) != 0 && (n4 = Crypto.scanASN1Object(16, byArray, n3 += n4)) != 0) {
            n = n3;
            if ((n4 = Crypto.scanASN1Object(2, byArray, n3 += n4)) != 0 && (n4 = Crypto.scanASN1Object(2, byArray, n3 += n4)) != 0) {
                n2 = n3 + n4;
                return Arrays.copyOfRange(byArray, n, n2);
            }
        }
        return byArray;
    }

    private static int scanASN1Object(int n, byte[] byArray, int n2) {
        boolean bl;
        if (n2 >= byArray.length) {
            return 0;
        }
        int n3 = n2;
        int n4 = byArray[n3++] & 0x1F;
        int n5 = n4 & 0xC0;
        int n6 = n4 & 0x1F;
        boolean bl2 = bl = (n4 & 0x20) != 0;
        if (n5 != 0) {
            return 0;
        }
        if (n6 != n) {
            return 0;
        }
        if (bl && n6 != 16) {
            return 0;
        }
        if (n6 != 0) {
            int n7;
            if (n3 >= byArray.length) {
                return 0;
            }
            if (((n7 = byArray[n3++] & 0xFF) & 0x80) > 0) {
                int n8 = 0;
                if (n3 + (n7 &= 0x7F) > byArray.length) {
                    return 0;
                }
                while (n7-- > 0) {
                    n8 = n8 << 8 | byArray[n3++] & 0xFF;
                }
                n7 = n8;
            }
            switch (n6) {
                case 3: 
                case 16: {
                    n7 = 0;
                }
            }
            if (n3 + n7 > byArray.length) {
                return 0;
            }
            n3 += n7;
        }
        return n3 - n2;
    }

    static {
        try {
            rsaMaxKey = Cipher.getMaxAllowedKeyLength(RSA_KEY_ALG);
        }
        catch (Exception exception) {
            rsaMaxKey = 0;
        }
        try {
            aesMaxKey = Cipher.getMaxAllowedKeyLength(AES_KEY_ALG);
        }
        catch (Exception exception) {
            rsaMaxKey = 0;
        }
        rsaMaxKey = rsaMaxKey >= 4096 ? 4096 : (rsaMaxKey >= 3072 ? 3072 : (rsaMaxKey >= 2048 ? 2048 : (rsaMaxKey >= 1024 ? 1024 : 0)));
        aesMaxKey = aesMaxKey >= 256 ? 256 : (aesMaxKey >= 192 ? 192 : (aesMaxKey >= 128 ? 128 : 0));
    }

    public static class AESSession {
        private Cipher cipher;

        private AESSession(AESKey aESKey, boolean bl) throws SQLException {
            try {
                this.cipher = Cipher.getInstance(Crypto.AES_CBC_ALG);
                if (aESKey.iv == null) {
                    this.cipher.init(bl ? 1 : 2, aESKey.key);
                } else {
                    AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(Crypto.AES_KEY_ALG);
                    algorithmParameters.init(new IvParameterSpec(aESKey.iv));
                    this.cipher.init(bl ? 1 : 2, aESKey.key, algorithmParameters);
                }
            }
            catch (Exception exception) {
                throw SqlExFactory.get(GcfErr.ERR_GC400C_ENCRYPTION_ERROR, exception);
            }
        }

        public int getBlockSize() {
            return this.cipher.getBlockSize();
        }

        public int encrypt(byte[] byArray, int n, int n2) throws SQLException {
            try {
                return this.cipher.doFinal(byArray, n, n2, byArray, n);
            }
            catch (Exception exception) {
                throw SqlExFactory.get(GcfErr.ERR_GC400C_ENCRYPTION_ERROR, exception);
            }
        }

        public int decrypt(byte[] byArray, int n, int n2) throws SQLException {
            try {
                return this.cipher.doFinal(byArray, n, n2, byArray, n);
            }
            catch (Exception exception) {
                throw SqlExFactory.get(GcfErr.ERR_GC400C_ENCRYPTION_ERROR, exception);
            }
        }
    }

    public static class AESKey {
        private Key key;
        private byte[] iv = null;

        private AESKey(Key key) {
            this.key = key;
        }

        public void setIV(byte[] byArray) {
            this.iv = (byte[])(byArray == null ? null : Arrays.copyOf(byArray, byArray.length));
        }
    }

    public static class RSAKey {
        private KeyPair key;

        private RSAKey(KeyPair keyPair) {
            this.key = keyPair;
        }
    }
}

