/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.tasks.common.FetchType;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.PollingTriggerInterface;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.models.triggers.TriggerOutput;
import io.kestra.core.models.triggers.TriggerService;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.jdbc.AbstractJdbcBaseQuery;
import io.kestra.plugin.jdbc.JdbcQueryInterface;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;

public abstract class AbstractJdbcTrigger
extends AbstractTrigger
implements PollingTriggerInterface,
TriggerOutput<AbstractJdbcBaseQuery.Output>,
JdbcQueryInterface {
    private final Duration interval;
    private Property<String> url;
    private Property<String> username;
    private Property<String> password;
    private Property<String> timeZoneId;
    private Property<String> sql;
    @Deprecated(since="0.19.0", forRemoval=true)
    private boolean store;
    @Deprecated(since="0.19.0", forRemoval=true)
    private boolean fetchOne;
    @Deprecated(since="0.19.0", forRemoval=true)
    private boolean fetch;
    @NotNull
    protected Property<FetchType> fetchType;
    protected Property<Integer> fetchSize;
    protected transient Map<String, Object> additionalVars;
    protected Property<Map<String, Object>> parameters;

    public Optional<Execution> evaluate(ConditionContext conditionContext, TriggerContext context) throws Exception {
        RunContext runContext = conditionContext.getRunContext();
        Logger logger = runContext.logger();
        AbstractJdbcBaseQuery.Output run = this.runQuery(runContext);
        logger.debug("Found '{}' rows from '{}'", (Object)run.getSize(), runContext.render(this.sql).as(String.class).orElse(null));
        if (Optional.ofNullable(run.getSize()).orElse(0L) == 0L) {
            return Optional.empty();
        }
        Execution execution = TriggerService.generateExecution((AbstractTrigger)this, (ConditionContext)conditionContext, (TriggerContext)context, (Output)run);
        return Optional.of(execution);
    }

    public FetchType renderFetchType(RunContext runContext) throws IllegalVariableEvaluationException {
        if (this.fetch) {
            return FetchType.FETCH;
        }
        if (this.fetchOne) {
            return FetchType.FETCH_ONE;
        }
        if (this.store) {
            return FetchType.STORE;
        }
        return (FetchType)runContext.render(this.fetchType).as(FetchType.class).orElseThrow();
    }

    protected abstract AbstractJdbcBaseQuery.Output runQuery(RunContext var1) throws Exception;

    @Generated
    private static Duration $default$interval() {
        return Duration.ofSeconds(60L);
    }

    @Generated
    private static boolean $default$store() {
        return false;
    }

    @Generated
    private static boolean $default$fetchOne() {
        return false;
    }

    @Generated
    private static boolean $default$fetch() {
        return false;
    }

    @Generated
    private static Property<FetchType> $default$fetchType() {
        return Property.of((Object)FetchType.NONE);
    }

    @Generated
    private static Property<Integer> $default$fetchSize() {
        return Property.of((Object)10000);
    }

    @Generated
    private static Map<String, Object> $default$additionalVars() {
        return new HashMap<String, Object>();
    }

    @Generated
    protected AbstractJdbcTrigger(AbstractJdbcTriggerBuilder<?, ?> b) {
        super(b);
        this.interval = b.interval$set ? b.interval$value : AbstractJdbcTrigger.$default$interval();
        this.url = b.url;
        this.username = b.username;
        this.password = b.password;
        this.timeZoneId = b.timeZoneId;
        this.sql = b.sql;
        this.store = b.store$set ? b.store$value : AbstractJdbcTrigger.$default$store();
        this.fetchOne = b.fetchOne$set ? b.fetchOne$value : AbstractJdbcTrigger.$default$fetchOne();
        this.fetch = b.fetch$set ? b.fetch$value : AbstractJdbcTrigger.$default$fetch();
        this.fetchType = b.fetchType$set ? b.fetchType$value : AbstractJdbcTrigger.$default$fetchType();
        this.fetchSize = b.fetchSize$set ? b.fetchSize$value : AbstractJdbcTrigger.$default$fetchSize();
        this.additionalVars = b.additionalVars$set ? b.additionalVars$value : AbstractJdbcTrigger.$default$additionalVars();
        this.parameters = b.parameters;
    }

    @Generated
    public String toString() {
        return "AbstractJdbcTrigger(super=" + super.toString() + ", interval=" + String.valueOf(this.getInterval()) + ", url=" + String.valueOf(this.getUrl()) + ", username=" + String.valueOf(this.getUsername()) + ", password=" + String.valueOf(this.getPassword()) + ", timeZoneId=" + String.valueOf(this.getTimeZoneId()) + ", sql=" + String.valueOf(this.getSql()) + ", store=" + this.isStore() + ", fetchOne=" + this.isFetchOne() + ", fetch=" + this.isFetch() + ", fetchType=" + String.valueOf(this.getFetchType()) + ", fetchSize=" + String.valueOf(this.getFetchSize()) + ", additionalVars=" + String.valueOf(this.additionalVars) + ", parameters=" + String.valueOf(this.getParameters()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractJdbcTrigger)) {
            return false;
        }
        AbstractJdbcTrigger other = (AbstractJdbcTrigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isStore() != other.isStore()) {
            return false;
        }
        if (this.isFetchOne() != other.isFetchOne()) {
            return false;
        }
        if (this.isFetch() != other.isFetch()) {
            return false;
        }
        Duration this$interval = this.getInterval();
        Duration other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval)) {
            return false;
        }
        Property<String> this$url = this.getUrl();
        Property<String> other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Property<String> this$username = this.getUsername();
        Property<String> other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        Property<String> this$password = this.getPassword();
        Property<String> other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Property<String> this$timeZoneId = this.getTimeZoneId();
        Property<String> other$timeZoneId = other.getTimeZoneId();
        if (this$timeZoneId == null ? other$timeZoneId != null : !this$timeZoneId.equals(other$timeZoneId)) {
            return false;
        }
        Property<String> this$sql = this.getSql();
        Property<String> other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        Property<FetchType> this$fetchType = this.getFetchType();
        Property<FetchType> other$fetchType = other.getFetchType();
        if (this$fetchType == null ? other$fetchType != null : !this$fetchType.equals(other$fetchType)) {
            return false;
        }
        Property<Integer> this$fetchSize = this.getFetchSize();
        Property<Integer> other$fetchSize = other.getFetchSize();
        if (this$fetchSize == null ? other$fetchSize != null : !this$fetchSize.equals(other$fetchSize)) {
            return false;
        }
        Property<Map<String, Object>> this$parameters = this.getParameters();
        Property<Map<String, Object>> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractJdbcTrigger;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isStore() ? 79 : 97);
        result = result * 59 + (this.isFetchOne() ? 79 : 97);
        result = result * 59 + (this.isFetch() ? 79 : 97);
        Duration $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
        Property<String> $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Property<String> $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        Property<String> $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Property<String> $timeZoneId = this.getTimeZoneId();
        result = result * 59 + ($timeZoneId == null ? 43 : $timeZoneId.hashCode());
        Property<String> $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        Property<FetchType> $fetchType = this.getFetchType();
        result = result * 59 + ($fetchType == null ? 43 : $fetchType.hashCode());
        Property<Integer> $fetchSize = this.getFetchSize();
        result = result * 59 + ($fetchSize == null ? 43 : $fetchSize.hashCode());
        Property<Map<String, Object>> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : $parameters.hashCode());
        return result;
    }

    @Generated
    public Duration getInterval() {
        return this.interval;
    }

    @Override
    @Generated
    public Property<String> getUrl() {
        return this.url;
    }

    @Override
    @Generated
    public Property<String> getUsername() {
        return this.username;
    }

    @Override
    @Generated
    public Property<String> getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public Property<String> getTimeZoneId() {
        return this.timeZoneId;
    }

    @Override
    @Generated
    public Property<String> getSql() {
        return this.sql;
    }

    @Override
    @Deprecated
    @Generated
    public boolean isStore() {
        return this.store;
    }

    @Override
    @Deprecated
    @Generated
    public boolean isFetchOne() {
        return this.fetchOne;
    }

    @Override
    @Deprecated
    @Generated
    public boolean isFetch() {
        return this.fetch;
    }

    @Override
    @Generated
    public Property<FetchType> getFetchType() {
        return this.fetchType;
    }

    @Override
    @Generated
    public Property<Integer> getFetchSize() {
        return this.fetchSize;
    }

    @Override
    @Generated
    public Property<Map<String, Object>> getParameters() {
        return this.parameters;
    }

    @Generated
    public AbstractJdbcTrigger() {
        this.interval = AbstractJdbcTrigger.$default$interval();
        this.store = AbstractJdbcTrigger.$default$store();
        this.fetchOne = AbstractJdbcTrigger.$default$fetchOne();
        this.fetch = AbstractJdbcTrigger.$default$fetch();
        this.fetchType = AbstractJdbcTrigger.$default$fetchType();
        this.fetchSize = AbstractJdbcTrigger.$default$fetchSize();
        this.additionalVars = AbstractJdbcTrigger.$default$additionalVars();
    }

    @Generated
    public static abstract class AbstractJdbcTriggerBuilder<C extends AbstractJdbcTrigger, B extends AbstractJdbcTriggerBuilder<C, B>>
    extends AbstractTrigger.AbstractTriggerBuilder<C, B> {
        @Generated
        private boolean interval$set;
        @Generated
        private Duration interval$value;
        @Generated
        private Property<String> url;
        @Generated
        private Property<String> username;
        @Generated
        private Property<String> password;
        @Generated
        private Property<String> timeZoneId;
        @Generated
        private Property<String> sql;
        @Generated
        private boolean store$set;
        @Generated
        private boolean store$value;
        @Generated
        private boolean fetchOne$set;
        @Generated
        private boolean fetchOne$value;
        @Generated
        private boolean fetch$set;
        @Generated
        private boolean fetch$value;
        @Generated
        private boolean fetchType$set;
        @Generated
        private Property<FetchType> fetchType$value;
        @Generated
        private boolean fetchSize$set;
        @Generated
        private Property<Integer> fetchSize$value;
        @Generated
        private boolean additionalVars$set;
        @Generated
        private Map<String, Object> additionalVars$value;
        @Generated
        private Property<Map<String, Object>> parameters;

        @Generated
        public B interval(Duration interval) {
            this.interval$value = interval;
            this.interval$set = true;
            return (B)this.self();
        }

        @Generated
        public B url(Property<String> url) {
            this.url = url;
            return (B)this.self();
        }

        @Generated
        public B username(Property<String> username) {
            this.username = username;
            return (B)this.self();
        }

        @Generated
        public B password(Property<String> password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public B timeZoneId(Property<String> timeZoneId) {
            this.timeZoneId = timeZoneId;
            return (B)this.self();
        }

        @Generated
        public B sql(Property<String> sql) {
            this.sql = sql;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B store(boolean store) {
            this.store$value = store;
            this.store$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B fetchOne(boolean fetchOne) {
            this.fetchOne$value = fetchOne;
            this.fetchOne$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B fetch(boolean fetch) {
            this.fetch$value = fetch;
            this.fetch$set = true;
            return (B)this.self();
        }

        @Generated
        public B fetchType(Property<FetchType> fetchType) {
            this.fetchType$value = fetchType;
            this.fetchType$set = true;
            return (B)this.self();
        }

        @Generated
        public B fetchSize(Property<Integer> fetchSize) {
            this.fetchSize$value = fetchSize;
            this.fetchSize$set = true;
            return (B)this.self();
        }

        @Generated
        public B additionalVars(Map<String, Object> additionalVars) {
            this.additionalVars$value = additionalVars;
            this.additionalVars$set = true;
            return (B)this.self();
        }

        @Generated
        public B parameters(Property<Map<String, Object>> parameters) {
            this.parameters = parameters;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractJdbcTrigger.AbstractJdbcTriggerBuilder(super=" + super.toString() + ", interval$value=" + String.valueOf(this.interval$value) + ", url=" + String.valueOf(this.url) + ", username=" + String.valueOf(this.username) + ", password=" + String.valueOf(this.password) + ", timeZoneId=" + String.valueOf(this.timeZoneId) + ", sql=" + String.valueOf(this.sql) + ", store$value=" + this.store$value + ", fetchOne$value=" + this.fetchOne$value + ", fetch$value=" + this.fetch$value + ", fetchType$value=" + String.valueOf(this.fetchType$value) + ", fetchSize$value=" + String.valueOf(this.fetchSize$value) + ", additionalVars$value=" + String.valueOf(this.additionalVars$value) + ", parameters=" + String.valueOf(this.parameters) + ")";
        }
    }
}

