/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.micronaut.http.uri.UriBuilder;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public interface JdbcConnectionInterface {
    @Schema(title="The JDBC URL to connect to the database.")
    @NotNull
    public Property<String> getUrl();

    @Schema(title="The database user.")
    public Property<String> getUsername();

    @Schema(title="The database user's password.")
    public Property<String> getPassword();

    public void registerDriver() throws SQLException;

    default public Properties connectionProperties(RunContext runContext) throws Exception {
        return this.createConnectionProperties(runContext);
    }

    default public Properties connectionProperties(RunContext runContext, String urlScheme) throws Exception {
        Properties props = this.createConnectionProperties(runContext);
        URI url = URI.create((String)props.get("jdbc.url"));
        url = URI.create(url.getSchemeSpecificPart());
        UriBuilder builder = UriBuilder.of((URI)url).scheme(urlScheme);
        props.put("jdbc.url", builder.build().toString());
        return props;
    }

    default public Connection connection(RunContext runContext) throws Exception {
        this.registerDriver();
        Properties props = this.connectionProperties(runContext);
        String jdbcUrl = props.getProperty("jdbc.url");
        props.remove("jdbc.url");
        return DriverManager.getConnection(jdbcUrl, props);
    }

    private Properties createConnectionProperties(RunContext runContext) throws IllegalVariableEvaluationException {
        Properties props = new Properties();
        props.put("jdbc.url", runContext.render(this.getUrl()).as(String.class).orElseThrow());
        if (this.getUsername() != null) {
            props.put("user", (Object)runContext.render(this.getUsername()).as(String.class).orElse(null));
        }
        if (this.getPassword() != null) {
            props.put("password", (Object)runContext.render(this.getPassword()).as(String.class).orElse(null));
        }
        return props;
    }
}

