/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.JdbcRslt;
import com.ingres.gcf.jdbc.JdbcStmt;
import com.ingres.gcf.jdbc.SqlBLoc;
import com.ingres.gcf.jdbc.SqlCLoc;
import com.ingres.gcf.jdbc.SqlNLoc;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.IngresDate;
import com.ingres.gcf.util.SqlBigInt;
import com.ingres.gcf.util.SqlBool;
import com.ingres.gcf.util.SqlByte;
import com.ingres.gcf.util.SqlChar;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDate;
import com.ingres.gcf.util.SqlDecimal;
import com.ingres.gcf.util.SqlDouble;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlIPv4;
import com.ingres.gcf.util.SqlIPv6;
import com.ingres.gcf.util.SqlInt;
import com.ingres.gcf.util.SqlLoc;
import com.ingres.gcf.util.SqlLongByte;
import com.ingres.gcf.util.SqlLongByteCache;
import com.ingres.gcf.util.SqlLongChar;
import com.ingres.gcf.util.SqlLongCharCache;
import com.ingres.gcf.util.SqlLongNChar;
import com.ingres.gcf.util.SqlLongNCharCache;
import com.ingres.gcf.util.SqlNChar;
import com.ingres.gcf.util.SqlNVarChar;
import com.ingres.gcf.util.SqlNull;
import com.ingres.gcf.util.SqlReal;
import com.ingres.gcf.util.SqlSmallInt;
import com.ingres.gcf.util.SqlStream;
import com.ingres.gcf.util.SqlTime;
import com.ingres.gcf.util.SqlTimestamp;
import com.ingres.gcf.util.SqlTinyInt;
import com.ingres.gcf.util.SqlVarByte;
import com.ingres.gcf.util.SqlVarChar;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Stack;
import java.util.Vector;

public class RsltFtch
extends JdbcRslt
implements MsgConst,
DbmsConst,
SqlStream.StreamListener {
    protected int maxRow = 0;
    protected SqlStream activeStream = null;
    private Vector rowSet = new Vector(0, 1);
    private Stack freeCache = new Stack();
    private int logicalRow = 0;
    private int cursorStatus = 1;
    private int cursorRow = 0;
    private JdbcStmt stmt = null;
    private long stmtID = 0L;
    private int maxFetch = 0;
    private int preFetch = 0;

    protected RsltFtch(DrvConn drvConn, JdbcStmt jdbcStmt, JdbcRSMD jdbcRSMD, long l, int n, int n2) throws SQLException {
        super(drvConn, jdbcRSMD);
        this.tr_id = "Ftch[" + this.inst_id + "]";
        this.stmt = jdbcStmt;
        this.stmtID = l;
        this.maxFetch = n;
        this.preFetch = n2;
        if (jdbcStmt != null) {
            this.rs_fetch_dir = jdbcStmt.rs_fetch_dir;
            this.rs_fetch_size = jdbcStmt.rs_fetch_size;
            this.rs_max_len = jdbcStmt.rs_max_len;
            this.rs_max_rows = jdbcStmt.rs_max_rows;
        }
        for (int i = 0; i < jdbcRSMD.count; ++i) {
            if (jdbcRSMD.desc[i].sql_type != -1 && jdbcRSMD.desc[i].sql_type != -4) continue;
            n = 1;
            break;
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getStatement(): " + this.stmt);
        }
        return this.stmt;
    }

    protected int fetchSize() {
        int n = 1;
        if (this.rs_fetch_size > 0) {
            n = this.rs_fetch_size;
        } else if (this.preFetch > 0 && this.conn.cnf_pre_blocks > 0) {
            n = this.preFetch * this.conn.cnf_pre_blocks;
        }
        if (this.maxFetch > 0 && n > this.maxFetch) {
            n = this.maxFetch;
        }
        if (this.rs_max_rows > 0 && n > this.rs_max_rows) {
            n = this.rs_max_rows;
        }
        return n;
    }

    protected void preLoad() throws SQLException {
        if (this.msg.moreMessages()) {
            this.calcTarget(3, 1);
            int n = this.preFetch > 0 ? this.preFetch : 1;
            this.rowSet.ensureCapacity(n);
            this.freeCache.ensureCapacity(n);
            this.readResults();
            this.checkResults(true);
        }
    }

    @Override
    protected void load() throws SQLException {
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".load()");
        }
        this.load(3, 1, this.fetchSize());
    }

    protected void load(int n, int n2, int n3) throws SQLException {
        if (this.rowInRowset(n, n2)) {
            return;
        }
        if (n == 3) {
            int n4 = this.cursorStatus == 2 || this.cursorStatus == 0 ? this.rowSet.size() + 1 : this.rowSet.size();
            n2 -= n4 - this.logicalRow;
        }
        if (n3 > 0) {
            this.freeCache.ensureCapacity(n3);
        }
        this.clearRowset();
        if (n3 > 0) {
            this.rowSet.ensureCapacity(n3);
        }
        this.calcTarget(n, n2);
        this.fetch(n, n2, n3);
        this.checkResults(n3 > 0);
        if (this.rowSet.isEmpty()) {
            if (this.cursorStatus == 1) {
                this.logicalRow = 0;
                this.currentRow = null;
                this.posStatus = 1;
                if (this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ".load: BEFORE");
                }
            } else {
                this.logicalRow = 1;
                this.currentRow = null;
                this.posStatus = 2;
                if (this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ".load: AFTER");
                }
            }
        } else {
            this.logicalRow = 1;
            this.currentRow = (JdbcRslt.Row)this.rowSet.get(this.logicalRow - 1);
            this.posStatus = 3;
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ".load: ROW " + this.currentRow.id + " [" + this.logicalRow + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean shut() throws SQLException {
        boolean bl;
        try {
            this.flush();
            this.closeCursor();
        }
        finally {
            this.rowSet.clear();
            this.freeCache.clear();
            this.logicalRow = this.rowSet.size() + 1;
            bl = super.shut();
            if (bl && this.stmt != null) {
                this.stmt.resultComplete();
            }
        }
        return bl;
    }

    protected void fetch(int n, int n2, int n3) throws SQLException {
        short s;
        switch (n) {
            case 1: {
                s = 1;
                break;
            }
            case 3: {
                s = 3;
                break;
            }
            case 2: {
                s = 2;
                break;
            }
            default: {
                s = 3;
                n2 = 1;
            }
        }
        this.clearResults();
        this.msg.begin((byte)5);
        this.msg.write((short)2);
        this.msg.write((short)1);
        this.msg.write((short)8);
        this.msg.write((int)(this.stmtID >> 32 & 0xFFFFFFFFFFFFFFFFL));
        this.msg.write((int)(this.stmtID & 0xFFFFFFFFFFFFFFFFL));
        if (s != 3 || n2 != 1) {
            this.msg.write((short)3);
            this.msg.write((short)2);
            this.msg.write(s);
            this.msg.write((short)4);
            this.msg.write((short)4);
            this.msg.write(n2);
        }
        if (n3 != 1) {
            this.msg.write((short)2);
            this.msg.write((short)4);
            this.msg.write(n3);
        }
        this.msg.done(true);
        this.readResults();
    }

    protected void resume() throws SQLException {
        if (this.msg.moreData()) {
            if (this.trace.enabled(5)) {
                this.trace.write(this.tr_id + ".resume: continue current message");
            }
            if (this.readData()) {
                return;
            }
        }
        if (this.trace.enabled(5)) {
            this.trace.write(this.tr_id + ".resume: read next message");
        }
        this.readResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeCursor() throws SQLException {
        block10: {
            RsltFtch rsltFtch = this;
            synchronized (rsltFtch) {
                if (this.cursorStatus == 0) {
                    return;
                }
                this.cursorStatus = 0;
            }
            if (this.msg.isClosed()) {
                return;
            }
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": closing cursor");
            }
            try {
                this.msg.begin((byte)5);
                this.msg.write((short)1);
                this.msg.write((short)1);
                this.msg.write((short)8);
                this.msg.write((int)(this.stmtID >> 32 & 0xFFFFFFFFFFFFFFFFL));
                this.msg.write((int)(this.stmtID & 0xFFFFFFFFFFFFFFFFL));
                this.msg.done(true);
                this.readResults();
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".shut(): error closing cursor");
                    SqlExFactory.trace(sQLException, this.trace);
                }
                if (sQLException.getErrorCode() == 804881) break block10;
                throw sQLException;
            }
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ": cursor closed!");
        }
    }

    @Override
    public void streamClosed(SqlStream sqlStream) {
        if (this.activeStream == null || this.activeStream != sqlStream) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": invalid LOB stream closure!");
            }
            return;
        }
        if (this.trace.enabled(4)) {
            this.trace.write(this.tr_id + ": LOB stream closed");
        }
        try {
            this.activeStream = null;
            this.resume();
            this.checkResults(true);
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.log(this.tr_id + ": error loading remainder of row");
                SqlExFactory.trace(sQLException, this.trace);
            }
            try {
                this.shut();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
        }
    }

    @Override
    protected void flush() throws SQLException {
        while (this.activeStream != null) {
            this.activeStream.closeStream();
        }
    }

    @Override
    protected void flush(int n) throws SQLException {
        while (!this.rowSet.isEmpty() && n >= ((JdbcRslt.Row)this.rowSet.lastElement()).count) {
            if (this.activeStream != null) {
                this.activeStream.closeStream();
                continue;
            }
            throw SqlExFactory.get(ERR_GC4021_INVALID_ROW);
        }
    }

    @Override
    protected void setProcResult(int n) throws SQLException {
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".setProcResult(" + n + ")");
        }
        this.stmt.setProcResult(n);
    }

    @Override
    protected boolean readData() throws SQLException {
        boolean bl = false;
        int n = 0;
        while (this.msg.moreData() && !bl) {
            if (this.rowSet.isEmpty() || ((JdbcRslt.Row)this.rowSet.lastElement()).count >= this.rsmd.count) {
                if (this.rowSet.isEmpty() && this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ".load: fill row-set starting with row " + this.cursorRow);
                }
                this.createRow(this.rsmd);
            }
            JdbcRslt.Row row = (JdbcRslt.Row)this.rowSet.lastElement();
            int n2 = row.count;
            bl = this.readColumns(this.rsmd, row);
            if (row.count < this.rsmd.count && !bl) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": failed to load entire row");
                }
                throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
            }
            if (n2 < 1 && row.count >= this.rsmd.count) {
                ++n;
                continue;
            }
            if (!this.trace.enabled(3)) continue;
            this.trace.write(this.tr_id + ".load: read " + (row.count - n2) + " of " + this.rsmd.count + " columns starting with " + (n2 + 1));
        }
        if (n > 0 && this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".load: Loaded " + n + " row" + (n == 1 ? "" : "s"));
        }
        return bl;
    }

    private boolean rowSetAtBOD() {
        boolean bl = false;
        if (this.cursorStatus == 1) {
            bl = true;
        } else if (this.rowSet.size() < 1) {
            if (this.cursorRow == 1) {
                bl = true;
            }
        } else if ((((JdbcRslt.Row)this.rowSet.get((int)0)).status & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    private boolean rowSetAtEOD() {
        boolean bl = false;
        if (this.cursorStatus == 2 || this.cursorStatus == 0) {
            bl = true;
        } else if (this.rowSet.size() > 0 && (((JdbcRslt.Row)this.rowSet.lastElement()).status & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRowset() {
        RsltFtch rsltFtch = this;
        synchronized (rsltFtch) {
            for (int i = this.rowSet.size() - 1; i >= 0; --i) {
                this.freeCache.push(this.rowSet.remove(i));
            }
        }
        this.logicalRow = 0;
    }

    private boolean rowInRowset(int n, int n2) {
        boolean bl = false;
        if (this.trace.enabled(5)) {
            this.trace.write(this.tr_id + ": row cache ref=" + n + ", off=" + n2 + ", size=" + this.rowSet.size() + ", log=" + this.logicalRow + ", stat=" + this.cursorStatus + ", row=" + this.cursorRow);
        }
        switch (n) {
            case 1: {
                if (n2 < 1) {
                    if (!this.rowSetAtBOD()) break;
                    this.logicalRow = 0;
                    this.currentRow = null;
                    this.posStatus = 1;
                    bl = true;
                    break;
                }
                if (this.rowSet.size() < 1) {
                    if (!this.rowSetAtEOD() || n2 < this.cursorRow) break;
                    this.logicalRow = this.rowSet.size() + 1;
                    this.currentRow = null;
                    this.posStatus = 2;
                    bl = true;
                    break;
                }
                int n3 = ((JdbcRslt.Row)this.rowSet.get((int)0)).id;
                int n4 = n3 + this.rowSet.size() - 1;
                if (n2 > n4) {
                    if (!this.rowSetAtEOD()) break;
                    this.logicalRow = this.rowSet.size() + 1;
                    this.currentRow = null;
                    this.posStatus = 2;
                    bl = true;
                    break;
                }
                if (n2 < n3) break;
                this.logicalRow = n2 - n3 + 1;
                this.currentRow = (JdbcRslt.Row)this.rowSet.get(this.logicalRow - 1);
                this.posStatus = 3;
                bl = true;
                break;
            }
            case 3: {
                if (n2 <= -this.logicalRow) {
                    if (!this.rowSetAtBOD()) break;
                    this.logicalRow = 0;
                    this.currentRow = null;
                    this.posStatus = 1;
                    bl = true;
                    break;
                }
                if (n2 > this.rowSet.size() - this.logicalRow) {
                    if (!this.rowSetAtEOD()) break;
                    this.logicalRow = this.rowSet.size() + 1;
                    this.currentRow = null;
                    this.posStatus = 2;
                    bl = true;
                    break;
                }
                if (n2 == 0) break;
                this.logicalRow += n2;
                this.currentRow = (JdbcRslt.Row)this.rowSet.get(this.logicalRow - 1);
                this.posStatus = 3;
                bl = true;
                break;
            }
            case 2: {
                if (n2 >= 0) {
                    if (!this.rowSetAtEOD()) break;
                    this.logicalRow = this.rowSet.size() + 1;
                    this.currentRow = null;
                    this.posStatus = 2;
                    bl = true;
                    break;
                }
                if (this.rowCount < 0) break;
                int n5 = this.rowCount + n2 + 1;
                if (n5 < 1) {
                    if (!this.rowSetAtBOD()) break;
                    this.logicalRow = 0;
                    this.currentRow = null;
                    this.posStatus = 1;
                    bl = true;
                    break;
                }
                if (this.rowSet.size() <= 0) break;
                int n6 = ((JdbcRslt.Row)this.rowSet.get((int)0)).id;
                int n7 = n6 + this.rowSet.size() - 1;
                if (n5 < n6 || n5 > n7) break;
                this.logicalRow = n5 - n6 + 1;
                this.currentRow = (JdbcRslt.Row)this.rowSet.get(this.logicalRow - 1);
                this.posStatus = 3;
                bl = true;
            }
        }
        if (bl && this.trace.enabled(3)) {
            switch (this.posStatus) {
                case 1: {
                    this.trace.write(this.tr_id + ".load: BEFORE");
                    break;
                }
                case 3: {
                    this.trace.write(this.tr_id + ".load: ROW " + this.currentRow.id + " [" + this.logicalRow + "]");
                    break;
                }
                case 2: {
                    this.trace.write(this.tr_id + ".load: AFTER");
                }
            }
        }
        if (!bl && this.cursorStatus == 0) {
            this.logicalRow = this.rowSet.size() + 1;
            this.currentRow = null;
            this.posStatus = 2;
            bl = true;
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ".load: AFTER (closed)");
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdbcRslt.Row createRow(JdbcRSMD jdbcRSMD) throws SQLException {
        JdbcRslt.Row row;
        if (!this.freeCache.empty()) {
            row = (JdbcRslt.Row)this.freeCache.pop();
        } else {
            row = new JdbcRslt.Row();
            row.columns = new SqlData[jdbcRSMD.count];
            block32: for (int i = 0; i < jdbcRSMD.count; ++i) {
                switch (jdbcRSMD.desc[i].sql_type) {
                    case 0: {
                        row.columns[i] = new SqlNull();
                        continue block32;
                    }
                    case -6: {
                        row.columns[i] = new SqlTinyInt();
                        continue block32;
                    }
                    case 5: {
                        row.columns[i] = new SqlSmallInt();
                        continue block32;
                    }
                    case 4: {
                        row.columns[i] = new SqlInt();
                        continue block32;
                    }
                    case -5: {
                        row.columns[i] = new SqlBigInt();
                        continue block32;
                    }
                    case 7: {
                        row.columns[i] = new SqlReal();
                        continue block32;
                    }
                    case 6: 
                    case 8: {
                        row.columns[i] = new SqlDouble();
                        continue block32;
                    }
                    case 2: 
                    case 3: {
                        row.columns[i] = new SqlDecimal(this.conn.max_dec_prec);
                        continue block32;
                    }
                    case 16: {
                        row.columns[i] = new SqlBool();
                        continue block32;
                    }
                    case 91: {
                        row.columns[i] = new SqlDate(this.conn.dt_frmt);
                        continue block32;
                    }
                    case 92: {
                        row.columns[i] = new SqlTime(this.conn.dt_frmt, jdbcRSMD.desc[i].dbms_type);
                        continue block32;
                    }
                    case 93: {
                        switch (jdbcRSMD.desc[i].dbms_type) {
                            case 3: {
                                row.columns[i] = new IngresDate(this.conn.dt_frmt, this.conn.osql_dates, this.conn.timeValuesInGMT(), this.conn.cnf_empty_date);
                                continue block32;
                            }
                        }
                        row.columns[i] = new SqlTimestamp(this.conn.dt_frmt, jdbcRSMD.desc[i].dbms_type);
                        continue block32;
                    }
                    case -2: {
                        switch (jdbcRSMD.desc[i].dbms_type) {
                            case 66: {
                                row.columns[i] = new SqlIPv4();
                                continue block32;
                            }
                            case 67: {
                                row.columns[i] = new SqlIPv6();
                                continue block32;
                            }
                        }
                        row.columns[i] = new SqlByte(jdbcRSMD.desc[i].length);
                        continue block32;
                    }
                    case -3: {
                        row.columns[i] = new SqlVarByte(jdbcRSMD.desc[i].length);
                        continue block32;
                    }
                    case 1: {
                        if (jdbcRSMD.desc[i].dbms_type != 26) {
                            row.columns[i] = new SqlChar(this.msg.getCharSet(), jdbcRSMD.desc[i].length);
                            continue block32;
                        }
                        row.columns[i] = new SqlNChar(jdbcRSMD.desc[i].length / 2);
                        continue block32;
                    }
                    case 12: {
                        if (jdbcRSMD.desc[i].dbms_type != 27) {
                            row.columns[i] = new SqlVarChar(this.msg.getCharSet(), jdbcRSMD.desc[i].length);
                            continue block32;
                        }
                        row.columns[i] = new SqlNVarChar(jdbcRSMD.desc[i].length / 2);
                        continue block32;
                    }
                    case -4: {
                        if ((this.conn.cnf_flags & 0x10) != 0) {
                            row.columns[i] = new SqlLongByteCache(this.conn.cnf_lob_segSize);
                            continue block32;
                        }
                        row.columns[i] = new SqlLongByte(this);
                        continue block32;
                    }
                    case -1: {
                        if ((this.conn.cnf_flags & 0x10) != 0) {
                            if (jdbcRSMD.desc[i].dbms_type != 28) {
                                row.columns[i] = new SqlLongCharCache(this.msg.getCharSet(), this.conn.cnf_lob_segSize);
                                continue block32;
                            }
                            row.columns[i] = new SqlLongNCharCache(this.conn.cnf_lob_segSize);
                            continue block32;
                        }
                        if (jdbcRSMD.desc[i].dbms_type != 28) {
                            row.columns[i] = new SqlLongChar(this.msg.getCharSet(), this);
                            continue block32;
                        }
                        row.columns[i] = new SqlLongNChar(this);
                        continue block32;
                    }
                    case 2004: {
                        row.columns[i] = new SqlBLoc(this.conn);
                        continue block32;
                    }
                    case 2005: {
                        if (jdbcRSMD.desc[i].dbms_type != 29) {
                            row.columns[i] = new SqlCLoc(this.conn);
                            continue block32;
                        }
                        row.columns[i] = new SqlNLoc(this.conn);
                        continue block32;
                    }
                    default: {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": unexpected SQL type " + jdbcRSMD.desc[i].sql_type);
                        }
                        throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                    }
                }
            }
        }
        RsltFtch rsltFtch = this;
        synchronized (rsltFtch) {
            int n = row.id = this.rowSet.isEmpty() ? this.cursorRow : (this.cursorRow = this.cursorRow + 1);
            if (this.maxRow < row.id) {
                this.maxRow = row.id;
            }
            row.count = 0;
            int n2 = row.status = row.id == 1 ? 1 : 0;
            if (this.rowCount > 0 && row.id == this.rowCount) {
                row.status |= 2;
            }
            this.rowSet.add(row);
        }
        return row;
    }

    private boolean readColumns(JdbcRSMD jdbcRSMD, JdbcRslt.Row row) throws SQLException {
        while (row.count < jdbcRSMD.count) {
            int n = row.count++;
            if (!this.msg.moreData()) {
                return false;
            }
            block0 : switch (jdbcRSMD.desc[n].sql_type) {
                case 0: {
                    this.msg.readSqlData((SqlNull)row.columns[n]);
                    break;
                }
                case -6: {
                    this.msg.readSqlData((SqlTinyInt)row.columns[n]);
                    break;
                }
                case 5: {
                    this.msg.readSqlData((SqlSmallInt)row.columns[n]);
                    break;
                }
                case 4: {
                    this.msg.readSqlData((SqlInt)row.columns[n]);
                    break;
                }
                case -5: {
                    this.msg.readSqlData((SqlBigInt)row.columns[n]);
                    break;
                }
                case 7: {
                    this.msg.readSqlData((SqlReal)row.columns[n]);
                    break;
                }
                case 6: 
                case 8: {
                    this.msg.readSqlData((SqlDouble)row.columns[n]);
                    break;
                }
                case 2: 
                case 3: {
                    this.msg.readSqlData((SqlDecimal)row.columns[n]);
                    break;
                }
                case 16: {
                    this.msg.readSqlData((SqlBool)row.columns[n]);
                    break;
                }
                case 91: {
                    this.msg.readSqlData((SqlDate)row.columns[n]);
                    break;
                }
                case 92: {
                    this.msg.readSqlData((SqlTime)row.columns[n]);
                    break;
                }
                case 93: {
                    switch (jdbcRSMD.desc[n].dbms_type) {
                        case 3: {
                            this.msg.readSqlData((IngresDate)row.columns[n]);
                            break block0;
                        }
                    }
                    this.msg.readSqlData((SqlTimestamp)row.columns[n]);
                    break;
                }
                case -2: {
                    this.msg.readSqlData((SqlByte)row.columns[n]);
                    break;
                }
                case -3: {
                    this.msg.readSqlData((SqlVarByte)row.columns[n]);
                    break;
                }
                case 1: {
                    if (jdbcRSMD.desc[n].dbms_type != 26) {
                        this.msg.readSqlData((SqlChar)row.columns[n]);
                        break;
                    }
                    this.msg.readSqlData((SqlNChar)row.columns[n]);
                    break;
                }
                case 12: {
                    if (jdbcRSMD.desc[n].dbms_type != 27) {
                        this.msg.readSqlData((SqlVarChar)row.columns[n]);
                        break;
                    }
                    this.msg.readSqlData((SqlNVarChar)row.columns[n]);
                    break;
                }
                case -4: {
                    if ((this.conn.cnf_flags & 0x10) != 0) {
                        this.msg.readSqlData((SqlLongByteCache)row.columns[n]);
                        break;
                    }
                    this.msg.readSqlData((SqlLongByte)row.columns[n]);
                    if (row.columns[n].isNull()) break;
                    this.activeStream = (SqlStream)row.columns[n];
                    return true;
                }
                case -1: {
                    if ((this.conn.cnf_flags & 0x10) != 0) {
                        if (jdbcRSMD.desc[n].dbms_type != 28) {
                            this.msg.readSqlData((SqlLongCharCache)row.columns[n]);
                            break;
                        }
                        this.msg.readSqlData((SqlLongNCharCache)row.columns[n]);
                        break;
                    }
                    if (jdbcRSMD.desc[n].dbms_type != 28) {
                        this.msg.readSqlData((SqlLongChar)row.columns[n]);
                    } else {
                        this.msg.readSqlData((SqlLongNChar)row.columns[n]);
                    }
                    if (row.columns[n].isNull()) break;
                    this.activeStream = (SqlStream)row.columns[n];
                    ++row.count;
                    return true;
                }
                case 2004: 
                case 2005: {
                    this.msg.readSqlData((SqlLoc)row.columns[n]);
                    break;
                }
                default: {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": unexpected SQL type " + jdbcRSMD.desc[n].sql_type);
                    }
                    throw SqlExFactory.get(ERR_GC4002_PROTOCOL_ERR);
                }
            }
            ++row.count;
        }
        return false;
    }

    private void calcTarget(int n, int n2) {
        int n3 = this.rowCount >= 0 ? this.rowCount : 0x7FFFFFFE;
        switch (n) {
            case 1: {
                if (n2 <= 0) {
                    this.updateStatus(1, 0);
                    break;
                }
                if (n2 > n3) {
                    this.updateStatus(2, n3 + 1);
                    break;
                }
                this.updateStatus(3, n2);
                break;
            }
            case 3: {
                if (n2 <= -this.cursorRow) {
                    this.updateStatus(1, 0);
                    break;
                }
                if (n2 > n3 - this.cursorRow) {
                    this.updateStatus(2, n3 + 1);
                    break;
                }
                this.updateStatus(3, this.cursorRow + n2);
                break;
            }
            case 2: {
                if (n2 < -n3) {
                    this.updateStatus(1, 0);
                    break;
                }
                if (n2 >= 0) {
                    this.updateStatus(2, n3 + 1);
                    break;
                }
                this.updateStatus(3, n3 + n2 + 1);
            }
        }
    }

    private void checkResults(boolean bl) throws SQLException {
        if (this.activeStream != null) {
            return;
        }
        if ((this.rslt_flags & 8) != 0) {
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": cursor automatically closed");
            }
            this.updateStatus(0);
            try {
                this.closeCursor();
            }
            catch (SQLException sQLException) {}
        } else if ((this.rslt_flags & 4) != 0) {
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": cursor @ EOD");
            }
            this.updateStatus(2);
            try {
                this.closeCursor();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if ((this.rslt_items & 2) != 0) {
            int n = 3;
            if ((this.rslt_val_rowstat & 8) != 0) {
                n = 2;
            } else if ((this.rslt_val_rowstat & 1) != 0) {
                n = 1;
            } else if ((this.rslt_val_rowstat & 0x40) != 0) {
                this.createRow(this.rsmd);
                if (this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ".load: Extend row-set for deleted row " + this.cursorRow);
                }
            }
            if (this.rowSet.isEmpty() && n == 3) {
                if (bl && this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": No row returned when requested (0x" + Integer.toHexString(this.rslt_val_rowstat) + ")");
                }
                if (this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ".load: Extend row-set for missing row " + this.cursorRow);
                }
                this.createRow(this.rsmd);
            }
            if ((this.rslt_items & 4) != 0) {
                this.updateStatus(n, this.rslt_val_rowpos);
            } else {
                this.updateStatus(n);
            }
            if (this.cursorStatus == 3 && !this.rowSet.isEmpty()) {
                JdbcRslt.Row row = (JdbcRslt.Row)this.rowSet.lastElement();
                if ((this.rslt_val_rowstat & 2) != 0) {
                    row.status |= 1;
                }
                if ((this.rslt_val_rowstat & 4) != 0) {
                    row.status |= 2;
                }
                if ((this.rslt_val_rowstat & 0x10) != 0) {
                    row.status |= 0x10;
                }
                if ((this.rslt_val_rowstat & 0x20) != 0) {
                    row.status |= 0x20;
                }
                if ((this.rslt_val_rowstat & 0x40) != 0) {
                    row.status |= 0x40;
                }
            }
        } else if ((this.rslt_items & 4) != 0) {
            this.updateRow(this.rslt_val_rowpos);
        }
        if (this.rowSet.isEmpty() && this.cursorStatus == 3) {
            if (this.rowCount < 0 || this.cursorRow > this.rowCount) {
                this.updateStatus(2);
            } else {
                if (this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ".load: Extend row-set for missing row " + this.cursorRow);
                }
                this.createRow(this.rsmd);
            }
        }
        if (this.rowSetAtEOD() && !this.rowSet.isEmpty()) {
            ((JdbcRslt.Row)this.rowSet.lastElement()).status |= 2;
        }
        if ((this.rslt_items & 4) != 0) {
            int n = -1;
            switch (this.cursorStatus) {
                case 3: {
                    if (this.rowSet.size() <= 0 || (((JdbcRslt.Row)this.rowSet.lastElement()).status & 2) == 0) break;
                    n = this.cursorRow;
                    break;
                }
                case 0: 
                case 2: {
                    n = this.cursorRow - 1;
                }
            }
            if (n >= 0) {
                if (this.rowCount >= 0 && this.rowCount != n && this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ": unexpectedly changing result-set size from " + this.rowCount + " to " + n);
                }
                this.maxRow = this.rowCount = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRow(int n) {
        RsltFtch rsltFtch = this;
        synchronized (rsltFtch) {
            this.cursorRow = n;
            this.updateStatus();
        }
    }

    private void updateStatus() {
        int n = this.cursorRow - this.rowSet.size();
        if (this.cursorStatus == 3) {
            ++n;
        }
        if (this.rowSet.size() > 0 && ((JdbcRslt.Row)this.rowSet.get((int)0)).id != n) {
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": Row-set positioned at row " + n);
            }
            for (int i = 0; i < this.rowSet.size(); ++i) {
                JdbcRslt.Row row = (JdbcRslt.Row)this.rowSet.get(i);
                row.id = n + i;
                if (this.maxRow >= row.id) continue;
                this.maxRow = row.id;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus(int n) {
        RsltFtch rsltFtch = this;
        synchronized (rsltFtch) {
            if (this.cursorStatus != 0) {
                if ((n == 2 || n == 0) && this.cursorStatus == 3 && this.rowSet.size() > 0) {
                    ++this.cursorRow;
                }
                this.cursorStatus = n;
                this.updateStatus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus(int n, int n2) {
        RsltFtch rsltFtch = this;
        synchronized (rsltFtch) {
            if (this.cursorStatus != 0) {
                this.cursorStatus = n;
            }
            this.cursorRow = n2;
            this.updateStatus();
        }
    }
}

