/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.vectorwise;

import com.ingres.jdbc.IngresDriver;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.AbstractJdbcQuery;
import io.kestra.plugin.jdbc.AutoCommitInterface;
import io.kestra.plugin.jdbc.vectorwise.VectorwiseCellConverter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.ZoneId;
import lombok.Generated;

@Schema(title="Query a Vectorwise database.")
@Plugin(examples={@Example(title="Send a sql query to a vectorwise database and fetch a row as outputs", code={"url: jdbc:vectorwise://url:port/base", "username: admin", "password: admin_passwd", "sql: select * from vectorwise_types", "fetchOne: true"})})
public class Query
extends AbstractJdbcQuery
implements RunnableTask<AbstractJdbcQuery.Output>,
AutoCommitInterface {
    protected final Boolean autoCommit = true;

    @Override
    protected AbstractCellConverter getCellConverter(ZoneId zoneId) {
        return new VectorwiseCellConverter(zoneId);
    }

    @Override
    protected void registerDriver() throws SQLException {
        DriverManager.registerDriver(new IngresDriver());
    }

    @Override
    public AbstractJdbcQuery.Output run(RunContext runContext) throws Exception {
        return super.run(runContext);
    }

    @Generated
    protected Query(QueryBuilder<?, ?> b) {
        super((AbstractJdbcQuery.AbstractJdbcQueryBuilder<?, ?>)b);
    }

    @Generated
    public static QueryBuilder<?, ?> builder() {
        return new QueryBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Query(super=" + super.toString() + ", autoCommit=" + this.getAutoCommit() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$autoCommit = this.getAutoCommit();
        Boolean other$autoCommit = other.getAutoCommit();
        return !(this$autoCommit == null ? other$autoCommit != null : !((Object)this$autoCommit).equals(other$autoCommit));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Query;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $autoCommit = this.getAutoCommit();
        result = result * 59 + ($autoCommit == null ? 43 : ((Object)$autoCommit).hashCode());
        return result;
    }

    @Override
    @Generated
    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Generated
    public Query() {
    }

    @Generated
    private static final class QueryBuilderImpl
    extends QueryBuilder<Query, QueryBuilderImpl> {
        @Generated
        private QueryBuilderImpl() {
        }

        @Override
        @Generated
        protected QueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Query build() {
            return new Query(this);
        }
    }

    @Generated
    public static abstract class QueryBuilder<C extends Query, B extends QueryBuilder<C, B>>
    extends AbstractJdbcQuery.AbstractJdbcQueryBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Query.QueryBuilder(super=" + super.toString() + ")";
        }
    }
}

