/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.WriteModel;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.mongodb.AbstractTask;
import io.reactivex.Flowable;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.bson.conversions.Bson;
import org.slf4j.Logger;

public abstract class AbstractLoad
extends AbstractTask
implements RunnableTask<Output> {
    @Schema(title="The source file")
    @PluginProperty(dynamic=true)
    @NotNull
    private String from;
    @Schema(title="The size of chunk for every bulk request")
    @PluginProperty(dynamic=true)
    private Integer chunk;

    protected abstract Flowable<WriteModel<Bson>> source(RunContext var1, BufferedReader var2);

    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        URI from = new URI(runContext.render(this.from));
        try (MongoClient client = this.connection.client(runContext);){
            Output output;
            try (BufferedReader inputStream = new BufferedReader(new InputStreamReader(runContext.uriToInputStream(from)));){
                MongoCollection<Bson> collection = this.collection(runContext, client);
                AtomicLong count = new AtomicLong();
                AtomicInteger matchedCount = new AtomicInteger();
                AtomicInteger insertedCount = new AtomicInteger();
                AtomicInteger modifiedCount = new AtomicInteger();
                AtomicInteger deletedCount = new AtomicInteger();
                Flowable flowable = this.source(runContext, inputStream).doOnNext(docWriteRequest -> count.incrementAndGet()).buffer(this.chunk.intValue(), this.chunk.intValue()).map(indexRequests -> {
                    ArrayList bulkOperations = new ArrayList(indexRequests);
                    return collection.bulkWrite(bulkOperations);
                }).doOnNext(bulkItemResponse -> {
                    matchedCount.addAndGet(bulkItemResponse.getMatchedCount());
                    insertedCount.addAndGet(bulkItemResponse.getInsertedCount());
                    modifiedCount.addAndGet(bulkItemResponse.getModifiedCount());
                    deletedCount.addAndGet(bulkItemResponse.getDeletedCount());
                });
                Long requestCount = (Long)flowable.count().blockingGet();
                runContext.metric((AbstractMetricEntry)Counter.of((String)"requests.count", (Long)requestCount, (String[])new String[]{"database", collection.getNamespace().getDatabaseName(), "collection", collection.getNamespace().getCollectionName()}));
                runContext.metric((AbstractMetricEntry)Counter.of((String)"records", (Long)count.get(), (String[])new String[]{"database", collection.getNamespace().getDatabaseName(), "collection", collection.getNamespace().getCollectionName()}));
                logger.info("Successfully send {} requests for {} records", (Object)requestCount, (Object)count.get());
                output = Output.builder().size(count.get()).matchedCount(matchedCount.get()).insertedCount(insertedCount.get()).modifiedCount(modifiedCount.get()).deletedCount(deletedCount.get()).build();
            }
            return output;
        }
    }

    @Generated
    private static Integer $default$chunk() {
        return 1000;
    }

    @Generated
    protected AbstractLoad(AbstractLoadBuilder<?, ?> b) {
        super(b);
        this.from = b.from;
        this.chunk = b.chunk$set ? b.chunk$value : AbstractLoad.$default$chunk();
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractLoad(super=" + super.toString() + ", from=" + this.getFrom() + ", chunk=" + this.getChunk() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractLoad)) {
            return false;
        }
        AbstractLoad other = (AbstractLoad)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$chunk = this.getChunk();
        Integer other$chunk = other.getChunk();
        if (this$chunk == null ? other$chunk != null : !((Object)this$chunk).equals(other$chunk)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        return !(this$from == null ? other$from != null : !this$from.equals(other$from));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractLoad;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $chunk = this.getChunk();
        result = result * 59 + ($chunk == null ? 43 : ((Object)$chunk).hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        return result;
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Generated
    public Integer getChunk() {
        return this.chunk;
    }

    @Generated
    public AbstractLoad() {
        this.chunk = AbstractLoad.$default$chunk();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The size of the rows processed")
        private Long size;
        @Schema(title="The number of documents inserted by the write operation.")
        private int insertedCount;
        @Schema(title="The number of documents matched by updates or replacements in the write operation.")
        private int matchedCount;
        @Schema(title="The number of documents deleted by the write operation.")
        private int deletedCount;
        @Schema(title="The number of documents modified by the write operation.")
        private int modifiedCount;

        @Generated
        private static int $default$insertedCount() {
            return 0;
        }

        @Generated
        private static int $default$matchedCount() {
            return 0;
        }

        @Generated
        private static int $default$deletedCount() {
            return 0;
        }

        @Generated
        private static int $default$modifiedCount() {
            return 0;
        }

        @ConstructorProperties(value={"size", "insertedCount", "matchedCount", "deletedCount", "modifiedCount"})
        @Generated
        Output(Long size, int insertedCount, int matchedCount, int deletedCount, int modifiedCount) {
            this.size = size;
            this.insertedCount = insertedCount;
            this.matchedCount = matchedCount;
            this.deletedCount = deletedCount;
            this.modifiedCount = modifiedCount;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Long getSize() {
            return this.size;
        }

        @Generated
        public int getInsertedCount() {
            return this.insertedCount;
        }

        @Generated
        public int getMatchedCount() {
            return this.matchedCount;
        }

        @Generated
        public int getDeletedCount() {
            return this.deletedCount;
        }

        @Generated
        public int getModifiedCount() {
            return this.modifiedCount;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Long size;
            @Generated
            private boolean insertedCount$set;
            @Generated
            private int insertedCount$value;
            @Generated
            private boolean matchedCount$set;
            @Generated
            private int matchedCount$value;
            @Generated
            private boolean deletedCount$set;
            @Generated
            private int deletedCount$value;
            @Generated
            private boolean modifiedCount$set;
            @Generated
            private int modifiedCount$value;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder size(Long size) {
                this.size = size;
                return this;
            }

            @Generated
            public OutputBuilder insertedCount(int insertedCount) {
                this.insertedCount$value = insertedCount;
                this.insertedCount$set = true;
                return this;
            }

            @Generated
            public OutputBuilder matchedCount(int matchedCount) {
                this.matchedCount$value = matchedCount;
                this.matchedCount$set = true;
                return this;
            }

            @Generated
            public OutputBuilder deletedCount(int deletedCount) {
                this.deletedCount$value = deletedCount;
                this.deletedCount$set = true;
                return this;
            }

            @Generated
            public OutputBuilder modifiedCount(int modifiedCount) {
                this.modifiedCount$value = modifiedCount;
                this.modifiedCount$set = true;
                return this;
            }

            @Generated
            public Output build() {
                int insertedCount$value = this.insertedCount$value;
                if (!this.insertedCount$set) {
                    insertedCount$value = Output.$default$insertedCount();
                }
                int matchedCount$value = this.matchedCount$value;
                if (!this.matchedCount$set) {
                    matchedCount$value = Output.$default$matchedCount();
                }
                int deletedCount$value = this.deletedCount$value;
                if (!this.deletedCount$set) {
                    deletedCount$value = Output.$default$deletedCount();
                }
                int modifiedCount$value = this.modifiedCount$value;
                if (!this.modifiedCount$set) {
                    modifiedCount$value = Output.$default$modifiedCount();
                }
                return new Output(this.size, insertedCount$value, matchedCount$value, deletedCount$value, modifiedCount$value);
            }

            @Generated
            public String toString() {
                return "AbstractLoad.Output.OutputBuilder(size=" + this.size + ", insertedCount$value=" + this.insertedCount$value + ", matchedCount$value=" + this.matchedCount$value + ", deletedCount$value=" + this.deletedCount$value + ", modifiedCount$value=" + this.modifiedCount$value + ")";
            }
        }
    }

    @Generated
    public static abstract class AbstractLoadBuilder<C extends AbstractLoad, B extends AbstractLoadBuilder<C, B>>
    extends AbstractTask.AbstractTaskBuilder<C, B> {
        @Generated
        private String from;
        @Generated
        private boolean chunk$set;
        @Generated
        private Integer chunk$value;

        @Generated
        public B from(String from) {
            this.from = from;
            return (B)((Object)this.self());
        }

        @Generated
        public B chunk(Integer chunk) {
            this.chunk$value = chunk;
            this.chunk$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AbstractLoad.AbstractLoadBuilder(super=" + super.toString() + ", from=" + this.from + ", chunk$value=" + this.chunk$value + ")";
        }
    }
}

