/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.mongodb.MongoDbConnection;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.bson.conversions.Bson;

public abstract class AbstractTask
extends Task {
    @Schema(title="The connection properties.")
    @NotNull
    protected MongoDbConnection connection;
    @Schema(title="The mongodb database.")
    @PluginProperty(dynamic=true)
    @NotNull
    protected String database;
    @Schema(title="The mongodb collection.")
    @PluginProperty(dynamic=true)
    @NotNull
    protected String collection;

    protected MongoCollection<Bson> collection(RunContext runContext, MongoClient client) throws IllegalVariableEvaluationException {
        return this.collection(runContext, client, Bson.class);
    }

    protected <T> MongoCollection<T> collection(RunContext runContext, MongoClient client, Class<T> cls) throws IllegalVariableEvaluationException {
        MongoDatabase database = client.getDatabase(runContext.render(this.database));
        return database.getCollection(runContext.render(this.collection), cls);
    }

    @Generated
    protected AbstractTask(AbstractTaskBuilder<?, ?> b) {
        super(b);
        this.connection = b.connection;
        this.database = b.database;
        this.collection = b.collection;
    }

    @Generated
    public String toString() {
        return "AbstractTask(super=" + super.toString() + ", connection=" + this.getConnection() + ", database=" + this.getDatabase() + ", collection=" + this.getCollection() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTask)) {
            return false;
        }
        AbstractTask other = (AbstractTask)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MongoDbConnection this$connection = this.getConnection();
        MongoDbConnection other$connection = other.getConnection();
        if (this$connection == null ? other$connection != null : !this$connection.equals(other$connection)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$collection = this.getCollection();
        String other$collection = other.getCollection();
        return !(this$collection == null ? other$collection != null : !this$collection.equals(other$collection));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractTask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        MongoDbConnection $connection = this.getConnection();
        result = result * 59 + ($connection == null ? 43 : $connection.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $collection = this.getCollection();
        result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
        return result;
    }

    @Generated
    public MongoDbConnection getConnection() {
        return this.connection;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public String getCollection() {
        return this.collection;
    }

    @Generated
    public AbstractTask() {
    }

    @Generated
    public static abstract class AbstractTaskBuilder<C extends AbstractTask, B extends AbstractTaskBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private MongoDbConnection connection;
        @Generated
        private String database;
        @Generated
        private String collection;

        @Generated
        public B connection(MongoDbConnection connection) {
            this.connection = connection;
            return (B)this.self();
        }

        @Generated
        public B database(String database) {
            this.database = database;
            return (B)this.self();
        }

        @Generated
        public B collection(String collection) {
            this.collection = collection;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractTask.AbstractTaskBuilder(super=" + super.toString() + ", connection=" + this.connection + ", database=" + this.database + ", collection=" + this.collection + ")";
        }
    }
}

