/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.mongodb;

import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.WriteModel;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.mongodb.AbstractLoad;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableOnSubscribe;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.BufferedReader;
import java.util.Map;
import lombok.Generated;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

@Schema(title="Execute [Bulk](https://www.mongodb.com/docs/manual/reference/method/Bulk/) request in MongoDB")
@Plugin(examples={@Example(code={"connection:", "  uri: \"mongodb://root:example@localhost:27017/?authSource=admin\"", "database: \"my_database\"", "collection: \"my_collection\"", "from: \"{{ inputs.file }}\""})})
public class Bulk
extends AbstractLoad {
    @Override
    protected Flowable<WriteModel<Bson>> source(RunContext runContext, BufferedReader inputStream) {
        return Flowable.create(this.ndJSonReader(inputStream), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    public FlowableOnSubscribe<WriteModel<Bson>> ndJSonReader(BufferedReader input) {
        return s -> {
            String row;
            while ((row = input.readLine()) != null) {
                BsonDocument bsonDocument = BsonDocument.parse(row);
                Map.Entry<String, BsonValue> operation = bsonDocument.entrySet().iterator().next();
                s.onNext(switch (operation.getKey()) {
                    case "insertOne" -> new InsertOneModel<BsonDocument>(operation.getValue().asDocument());
                    case "replaceOne" -> new ReplaceOneModel<BsonDocument>(operation.getValue().asDocument().get("filter").asDocument(), operation.getValue().asDocument().get("replacement").asDocument());
                    case "updateOne" -> new UpdateOneModel((Bson)operation.getValue().asDocument().get("filter").asDocument(), operation.getValue().asDocument().get("update").asDocument());
                    case "updateMany" -> new UpdateManyModel((Bson)operation.getValue().asDocument().get("filter").asDocument(), operation.getValue().asDocument().get("update").asDocument());
                    case "deleteOne" -> new DeleteOneModel(operation.getValue().asDocument().get("filter").asDocument());
                    case "deleteMany" -> new DeleteManyModel(operation.getValue().asDocument().get("filter").asDocument());
                    default -> throw new IllegalArgumentException("Invalid bulk request type on '" + row + "'");
                });
            }
            s.onComplete();
        };
    }

    @Generated
    protected Bulk(BulkBuilder<?, ?> b) {
        super((AbstractLoad.AbstractLoadBuilder)b);
    }

    @Generated
    public static BulkBuilder<?, ?> builder() {
        return new BulkBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Bulk(super=" + super.toString() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bulk)) {
            return false;
        }
        Bulk other = (Bulk)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Bulk;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public Bulk() {
    }

    @Generated
    private static final class BulkBuilderImpl
    extends BulkBuilder<Bulk, BulkBuilderImpl> {
        @Generated
        private BulkBuilderImpl() {
        }

        @Override
        @Generated
        protected BulkBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Bulk build() {
            return new Bulk(this);
        }
    }

    @Generated
    public static abstract class BulkBuilder<C extends Bulk, B extends BulkBuilder<C, B>>
    extends AbstractLoad.AbstractLoadBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Bulk.BulkBuilder(super=" + super.toString() + ")";
        }
    }
}

