/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.DeleteResult;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.mongodb.AbstractTask;
import io.kestra.plugin.mongodb.MongoDbService;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.slf4j.Logger;

@Schema(title="Delete one or many documents")
@Plugin(examples={@Example(code={"connection:", "  uri: \"mongodb://root:example@localhost:27017/?authSource=admin\"", "database: \"my_database\"", "collection: \"my_collection\"", "operation: \"DELETE_ONE\"", "filter:", "  _id:", "    $oid: 60930c39a982931c20ef6cd6"})})
public class Delete
extends AbstractTask
implements RunnableTask<Output> {
    @Schema(title="The mongodb bson filter", description="Can be a bson string, or a map")
    @PluginProperty(dynamic=true)
    private Object filter;
    @Schema(title="Operation to use")
    @PluginProperty(dynamic=false)
    @NotNull
    private Operation operation;

    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        try (MongoClient client = this.connection.client(runContext);){
            MongoCollection<Bson> collection = this.collection(runContext, client);
            BsonDocument bsonFilter = MongoDbService.toDocument(runContext, this.filter);
            DeleteResult deleteResult = this.operation == Operation.DELETE_ONE ? collection.deleteOne(bsonFilter) : collection.deleteMany(bsonFilter);
            logger.debug("Delete doc with filter: {}", (Object)bsonFilter);
            runContext.metric((AbstractMetricEntry)Counter.of((String)"deleted.count", (Long)deleteResult.getDeletedCount(), (String[])new String[]{"database", collection.getNamespace().getDatabaseName(), "collection", collection.getNamespace().getCollectionName()}));
            Output output = Output.builder().wasAcknowledged(deleteResult.wasAcknowledged()).deletedCount(deleteResult.getDeletedCount()).build();
            return output;
        }
    }

    @Generated
    private static Operation $default$operation() {
        return Operation.DELETE_ONE;
    }

    @Generated
    protected Delete(DeleteBuilder<?, ?> b) {
        super((AbstractTask.AbstractTaskBuilder)b);
        this.filter = b.filter;
        this.operation = b.operation$set ? b.operation$value : Delete.$default$operation();
    }

    @Generated
    public static DeleteBuilder<?, ?> builder() {
        return new DeleteBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Delete(super=" + super.toString() + ", filter=" + this.getFilter() + ", operation=" + this.getOperation() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Delete)) {
            return false;
        }
        Delete other = (Delete)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$filter = this.getFilter();
        Object other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        Operation this$operation = this.getOperation();
        Operation other$operation = other.getOperation();
        return !(this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Delete;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        Operation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        return result;
    }

    @Generated
    public Object getFilter() {
        return this.filter;
    }

    @Generated
    public Operation getOperation() {
        return this.operation;
    }

    @Generated
    public Delete() {
        this.operation = Delete.$default$operation();
    }

    @Introspected
    public static enum Operation {
        DELETE_ONE,
        DELETE_MANY;

    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="true if the write was acknowledged.")
        private Boolean wasAcknowledged;
        @Schema(title="The number of documents deleted.")
        private final long deletedCount;

        @ConstructorProperties(value={"wasAcknowledged", "deletedCount"})
        @Generated
        Output(Boolean wasAcknowledged, long deletedCount) {
            this.wasAcknowledged = wasAcknowledged;
            this.deletedCount = deletedCount;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Boolean getWasAcknowledged() {
            return this.wasAcknowledged;
        }

        @Generated
        public long getDeletedCount() {
            return this.deletedCount;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Boolean wasAcknowledged;
            @Generated
            private long deletedCount;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder wasAcknowledged(Boolean wasAcknowledged) {
                this.wasAcknowledged = wasAcknowledged;
                return this;
            }

            @Generated
            public OutputBuilder deletedCount(long deletedCount) {
                this.deletedCount = deletedCount;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.wasAcknowledged, this.deletedCount);
            }

            @Generated
            public String toString() {
                return "Delete.Output.OutputBuilder(wasAcknowledged=" + this.wasAcknowledged + ", deletedCount=" + this.deletedCount + ")";
            }
        }
    }

    @Generated
    public static abstract class DeleteBuilder<C extends Delete, B extends DeleteBuilder<C, B>>
    extends AbstractTask.AbstractTaskBuilder<C, B> {
        @Generated
        private Object filter;
        @Generated
        private boolean operation$set;
        @Generated
        private Operation operation$value;

        @Generated
        public B filter(Object filter) {
            this.filter = filter;
            return (B)((Object)this.self());
        }

        @Generated
        public B operation(Operation operation) {
            this.operation$value = operation;
            this.operation$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Delete.DeleteBuilder(super=" + super.toString() + ", filter=" + this.filter + ", operation$value=" + this.operation$value + ")";
        }
    }

    @Generated
    private static final class DeleteBuilderImpl
    extends DeleteBuilder<Delete, DeleteBuilderImpl> {
        @Generated
        private DeleteBuilderImpl() {
        }

        @Override
        @Generated
        protected DeleteBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Delete build() {
            return new Delete(this);
        }
    }
}

