/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.mongodb;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.FileSerde;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.mongodb.AbstractTask;
import io.kestra.plugin.mongodb.MongoDbService;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.bson.BsonDocument;
import org.slf4j.Logger;

@Schema(title="Find documents")
@Plugin(examples={@Example(code={"connection:", "  uri: \"mongodb://root:example@localhost:27017/?authSource=admin\"", "database: \"my_database\"", "collection: \"my_collection\"", "filter:", "  _id:", "    $oid: 60930c39a982931c20ef6cd6"})})
public class Find
extends AbstractTask
implements RunnableTask<Output> {
    @Schema(title="The mongodb bson filter", description="Can be a bson string, or a map")
    @PluginProperty(dynamic=true)
    private Object filter;
    @Schema(title="The mongodb bson projection", description="Can be a bson string, or a map")
    @PluginProperty(dynamic=true)
    private Object projection;
    @Schema(title="The mongodb bson sort", description="Can be a bson string, or a map")
    @PluginProperty(dynamic=true)
    private Object sort;
    @Schema(title="The number of records to return")
    @PluginProperty(dynamic=true)
    private Integer limit;
    @Schema(title="The number of records to skip")
    @PluginProperty(dynamic=true)
    private Integer skip;
    @Schema(title="Whether to store the data from the query result into an ion serialized data file")
    @PluginProperty(dynamic=false)
    private Boolean store;

    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        try (MongoClient client = this.connection.client(runContext);){
            MongoCollection<BsonDocument> collection = this.collection(runContext, client, BsonDocument.class);
            BsonDocument bsonFilter = MongoDbService.toDocument(runContext, this.filter);
            FindIterable<BsonDocument> find = collection.find(bsonFilter);
            if (this.projection != null) {
                find.projection(MongoDbService.toDocument(runContext, this.projection));
            }
            if (this.sort != null) {
                find.sort(MongoDbService.toDocument(runContext, this.sort));
            }
            if (this.limit != null) {
                find.limit(this.limit);
            }
            if (this.skip != null) {
                find.skip(this.skip);
            }
            logger.debug("Find: {}", find);
            Output.OutputBuilder builder = Output.builder();
            if (this.store.booleanValue()) {
                Pair<URI, Long> store = this.store(runContext, find);
                builder.uri((URI)store.getLeft()).size((Long)store.getRight());
            } else {
                Pair<ArrayList<Object>, Long> fetch = this.fetch(find);
                builder.rows((List)fetch.getLeft()).size((Long)fetch.getRight());
            }
            Output output = builder.build();
            runContext.metric((AbstractMetricEntry)Counter.of((String)"records", (Long)output.getSize(), (String[])new String[]{"database", collection.getNamespace().getDatabaseName(), "collection", collection.getNamespace().getCollectionName()}));
            Output output2 = output;
            return output2;
        }
    }

    private Pair<URI, Long> store(RunContext runContext, FindIterable<BsonDocument> documents) throws IOException {
        File tempFile = runContext.tempFile(".ion").toFile();
        AtomicLong count = new AtomicLong();
        try (FileOutputStream output = new FileOutputStream(tempFile);){
            documents.forEach(Rethrow.throwConsumer(bsonDocument -> {
                count.incrementAndGet();
                FileSerde.write((OutputStream)output, (Object)MongoDbService.map(bsonDocument.toBsonDocument()));
            }));
        }
        return Pair.of((Object)runContext.putTempFile(tempFile), (Object)count.get());
    }

    private Pair<ArrayList<Object>, Long> fetch(FindIterable<BsonDocument> documents) {
        ArrayList result = new ArrayList();
        AtomicLong count = new AtomicLong();
        documents.forEach(Rethrow.throwConsumer(bsonDocument -> {
            count.incrementAndGet();
            result.add(MongoDbService.map(bsonDocument.toBsonDocument()));
        }));
        return Pair.of(result, (Object)count.get());
    }

    @Generated
    private static Boolean $default$store() {
        return false;
    }

    @Generated
    protected Find(FindBuilder<?, ?> b) {
        super(b);
        this.filter = b.filter;
        this.projection = b.projection;
        this.sort = b.sort;
        this.limit = b.limit;
        this.skip = b.skip;
        this.store = b.store$set ? b.store$value : Find.$default$store();
    }

    @Generated
    public static FindBuilder<?, ?> builder() {
        return new FindBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Find(super=" + super.toString() + ", filter=" + this.getFilter() + ", projection=" + this.getProjection() + ", sort=" + this.getSort() + ", limit=" + this.getLimit() + ", skip=" + this.getSkip() + ", store=" + this.getStore() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Find)) {
            return false;
        }
        Find other = (Find)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Integer this$skip = this.getSkip();
        Integer other$skip = other.getSkip();
        if (this$skip == null ? other$skip != null : !((Object)this$skip).equals(other$skip)) {
            return false;
        }
        Boolean this$store = this.getStore();
        Boolean other$store = other.getStore();
        if (this$store == null ? other$store != null : !((Object)this$store).equals(other$store)) {
            return false;
        }
        Object this$filter = this.getFilter();
        Object other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        Object this$projection = this.getProjection();
        Object other$projection = other.getProjection();
        if (this$projection == null ? other$projection != null : !this$projection.equals(other$projection)) {
            return false;
        }
        Object this$sort = this.getSort();
        Object other$sort = other.getSort();
        return !(this$sort == null ? other$sort != null : !this$sort.equals(other$sort));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Find;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Integer $skip = this.getSkip();
        result = result * 59 + ($skip == null ? 43 : ((Object)$skip).hashCode());
        Boolean $store = this.getStore();
        result = result * 59 + ($store == null ? 43 : ((Object)$store).hashCode());
        Object $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        Object $projection = this.getProjection();
        result = result * 59 + ($projection == null ? 43 : $projection.hashCode());
        Object $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
        return result;
    }

    @Generated
    public Object getFilter() {
        return this.filter;
    }

    @Generated
    public Object getProjection() {
        return this.projection;
    }

    @Generated
    public Object getSort() {
        return this.sort;
    }

    @Generated
    public Integer getLimit() {
        return this.limit;
    }

    @Generated
    public Integer getSkip() {
        return this.skip;
    }

    @Generated
    public Boolean getStore() {
        return this.store;
    }

    @Generated
    public Find() {
        this.store = Find.$default$store();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="List containing the fetched data", description="Only populated if `store` parameter is set to false.")
        private List<Object> rows;
        @Schema(title="The size of the rows fetch")
        private Long size;
        @Schema(title="The uri of store result", description="Only populated if `store` is set to true.")
        private URI uri;

        @ConstructorProperties(value={"rows", "size", "uri"})
        @Generated
        Output(List<Object> rows, Long size, URI uri) {
            this.rows = rows;
            this.size = size;
            this.uri = uri;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public List<Object> getRows() {
            return this.rows;
        }

        @Generated
        public Long getSize() {
            return this.size;
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private List<Object> rows;
            @Generated
            private Long size;
            @Generated
            private URI uri;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder rows(List<Object> rows) {
                this.rows = rows;
                return this;
            }

            @Generated
            public OutputBuilder size(Long size) {
                this.size = size;
                return this;
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.rows, this.size, this.uri);
            }

            @Generated
            public String toString() {
                return "Find.Output.OutputBuilder(rows=" + this.rows + ", size=" + this.size + ", uri=" + this.uri + ")";
            }
        }
    }

    @Generated
    public static abstract class FindBuilder<C extends Find, B extends FindBuilder<C, B>>
    extends AbstractTask.AbstractTaskBuilder<C, B> {
        @Generated
        private Object filter;
        @Generated
        private Object projection;
        @Generated
        private Object sort;
        @Generated
        private Integer limit;
        @Generated
        private Integer skip;
        @Generated
        private boolean store$set;
        @Generated
        private Boolean store$value;

        @Generated
        public B filter(Object filter) {
            this.filter = filter;
            return (B)((Object)this.self());
        }

        @Generated
        public B projection(Object projection) {
            this.projection = projection;
            return (B)((Object)this.self());
        }

        @Generated
        public B sort(Object sort) {
            this.sort = sort;
            return (B)((Object)this.self());
        }

        @Generated
        public B limit(Integer limit) {
            this.limit = limit;
            return (B)((Object)this.self());
        }

        @Generated
        public B skip(Integer skip) {
            this.skip = skip;
            return (B)((Object)this.self());
        }

        @Generated
        public B store(Boolean store) {
            this.store$value = store;
            this.store$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Find.FindBuilder(super=" + super.toString() + ", filter=" + this.filter + ", projection=" + this.projection + ", sort=" + this.sort + ", limit=" + this.limit + ", skip=" + this.skip + ", store$value=" + this.store$value + ")";
        }
    }

    @Generated
    private static final class FindBuilderImpl
    extends FindBuilder<Find, FindBuilderImpl> {
        @Generated
        private FindBuilderImpl() {
        }

        @Override
        @Generated
        protected FindBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Find build() {
            return new Find(this);
        }
    }
}

