/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.InsertOneResult;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.mongodb.AbstractTask;
import io.kestra.plugin.mongodb.MongoDbService;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.slf4j.Logger;

@Schema(title="Insert one document")
@Plugin(examples={@Example(title="Insert a document with a map", code={"connection:", "  uri: \"mongodb://root:example@localhost:27017/?authSource=admin\"", "database: \"my_database\"", "collection: \"my_collection\"", "document:", "  _id:", "    $oid: 60930c39a982931c20ef6cd6", "  name: \"John Doe\"", "  city: \"Paris\""}), @Example(title="Insert a document from a json string", code={"connection:", "  uri: \"mongodb://root:example@localhost:27017/?authSource=admin\"", "database: \"my_database\"", "collection: \"my_collection\"", "document: \"{{ outputs.task_id.data | json }}\""})})
public class InsertOne
extends AbstractTask
implements RunnableTask<Output> {
    @Schema(title="The mongodb document", description="Can be a bson string, or a map")
    @PluginProperty(dynamic=true)
    @NotNull
    private Object document;

    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        try (MongoClient client = this.connection.client(runContext);){
            MongoCollection<Bson> collection = this.collection(runContext, client);
            BsonDocument bsonDocument = MongoDbService.toDocument(runContext, this.document);
            InsertOneResult insertOneResult = collection.insertOne(bsonDocument);
            logger.info("Insert doc: {}", (Object)bsonDocument);
            runContext.metric((AbstractMetricEntry)Counter.of((String)"inserted.count", (Integer)1, (String[])new String[]{"database", collection.getNamespace().getDatabaseName(), "collection", collection.getNamespace().getCollectionName()}));
            Output output = Output.builder().insertedId(Objects.requireNonNull(insertOneResult.getInsertedId()).asObjectId().getValue().toString()).wasAcknowledged(insertOneResult.wasAcknowledged()).build();
            return output;
        }
    }

    @Generated
    protected InsertOne(InsertOneBuilder<?, ?> b) {
        super((AbstractTask.AbstractTaskBuilder)b);
        this.document = b.document;
    }

    @Generated
    public static InsertOneBuilder<?, ?> builder() {
        return new InsertOneBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "InsertOne(super=" + super.toString() + ", document=" + this.getDocument() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InsertOne)) {
            return false;
        }
        InsertOne other = (InsertOne)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$document = this.getDocument();
        Object other$document = other.getDocument();
        return !(this$document == null ? other$document != null : !this$document.equals(other$document));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InsertOne;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        return result;
    }

    @Generated
    public Object getDocument() {
        return this.document;
    }

    @Generated
    public InsertOne() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The inserted Id")
        private String insertedId;
        @Schema(title="true if the write was acknowledged.")
        private Boolean wasAcknowledged;

        @ConstructorProperties(value={"insertedId", "wasAcknowledged"})
        @Generated
        Output(String insertedId, Boolean wasAcknowledged) {
            this.insertedId = insertedId;
            this.wasAcknowledged = wasAcknowledged;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public String getInsertedId() {
            return this.insertedId;
        }

        @Generated
        public Boolean getWasAcknowledged() {
            return this.wasAcknowledged;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private String insertedId;
            @Generated
            private Boolean wasAcknowledged;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder insertedId(String insertedId) {
                this.insertedId = insertedId;
                return this;
            }

            @Generated
            public OutputBuilder wasAcknowledged(Boolean wasAcknowledged) {
                this.wasAcknowledged = wasAcknowledged;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.insertedId, this.wasAcknowledged);
            }

            @Generated
            public String toString() {
                return "InsertOne.Output.OutputBuilder(insertedId=" + this.insertedId + ", wasAcknowledged=" + this.wasAcknowledged + ")";
            }
        }
    }

    @Generated
    public static abstract class InsertOneBuilder<C extends InsertOne, B extends InsertOneBuilder<C, B>>
    extends AbstractTask.AbstractTaskBuilder<C, B> {
        @Generated
        private Object document;

        @Generated
        public B document(Object document) {
            this.document = document;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "InsertOne.InsertOneBuilder(super=" + super.toString() + ", document=" + this.document + ")";
        }
    }

    @Generated
    private static final class InsertOneBuilderImpl
    extends InsertOneBuilder<InsertOne, InsertOneBuilderImpl> {
        @Generated
        private InsertOneBuilderImpl() {
        }

        @Override
        @Generated
        protected InsertOneBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InsertOne build() {
            return new InsertOne(this);
        }
    }
}

