/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.mongodb;

import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.WriteModel;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.FileSerde;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.plugin.mongodb.AbstractLoad;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableOnSubscribe;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.BufferedReader;
import java.util.Map;
import lombok.Generated;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

@Schema(title="Bulk load documents in MongoDB using Kestra Internal Storage file")
@Plugin(examples={@Example(code={"connection:", "  uri: \"mongodb://root:example@localhost:27017/?authSource=admin\"", "database: \"my_database\"", "collection: \"my_collection\"", "from: \"{{ inputs.file }}\""})})
public class Load
extends AbstractLoad {
    @Schema(title="Use this key as id.")
    @PluginProperty(dynamic=true)
    private String idKey;
    @Schema(title="Remove idKey from the final document")
    @PluginProperty(dynamic=true)
    private Boolean removeIdKey;

    @Override
    protected Flowable<WriteModel<Bson>> source(RunContext runContext, BufferedReader inputStream) {
        return Flowable.create((FlowableOnSubscribe)FileSerde.reader((BufferedReader)inputStream), (BackpressureStrategy)BackpressureStrategy.BUFFER).map(o -> {
            Map values = (Map)o;
            if (this.idKey != null) {
                String idKey = runContext.render(this.idKey);
                values.put("_id", new BsonObjectId(new ObjectId(values.get(idKey).toString())));
                if (this.removeIdKey.booleanValue()) {
                    values.remove(idKey);
                }
            }
            return new InsertOneModel<BsonDocument>(BsonDocument.parse(JacksonMapper.ofJson().writeValueAsString((Object)values)));
        });
    }

    @Generated
    private static Boolean $default$removeIdKey() {
        return true;
    }

    @Generated
    protected Load(LoadBuilder<?, ?> b) {
        super((AbstractLoad.AbstractLoadBuilder<?, ?>)b);
        this.idKey = b.idKey;
        this.removeIdKey = b.removeIdKey$set ? b.removeIdKey$value : Load.$default$removeIdKey();
    }

    @Generated
    public static LoadBuilder<?, ?> builder() {
        return new LoadBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Load(super=" + super.toString() + ", idKey=" + this.getIdKey() + ", removeIdKey=" + this.getRemoveIdKey() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Load)) {
            return false;
        }
        Load other = (Load)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$removeIdKey = this.getRemoveIdKey();
        Boolean other$removeIdKey = other.getRemoveIdKey();
        if (this$removeIdKey == null ? other$removeIdKey != null : !((Object)this$removeIdKey).equals(other$removeIdKey)) {
            return false;
        }
        String this$idKey = this.getIdKey();
        String other$idKey = other.getIdKey();
        return !(this$idKey == null ? other$idKey != null : !this$idKey.equals(other$idKey));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Load;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $removeIdKey = this.getRemoveIdKey();
        result = result * 59 + ($removeIdKey == null ? 43 : ((Object)$removeIdKey).hashCode());
        String $idKey = this.getIdKey();
        result = result * 59 + ($idKey == null ? 43 : $idKey.hashCode());
        return result;
    }

    @Generated
    public String getIdKey() {
        return this.idKey;
    }

    @Generated
    public Boolean getRemoveIdKey() {
        return this.removeIdKey;
    }

    @Generated
    public Load() {
        this.removeIdKey = Load.$default$removeIdKey();
    }

    @Generated
    public static abstract class LoadBuilder<C extends Load, B extends LoadBuilder<C, B>>
    extends AbstractLoad.AbstractLoadBuilder<C, B> {
        @Generated
        private String idKey;
        @Generated
        private boolean removeIdKey$set;
        @Generated
        private Boolean removeIdKey$value;

        @Generated
        public B idKey(String idKey) {
            this.idKey = idKey;
            return (B)((Object)this.self());
        }

        @Generated
        public B removeIdKey(Boolean removeIdKey) {
            this.removeIdKey$value = removeIdKey;
            this.removeIdKey$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Load.LoadBuilder(super=" + super.toString() + ", idKey=" + this.idKey + ", removeIdKey$value=" + this.removeIdKey$value + ")";
        }
    }

    @Generated
    private static final class LoadBuilderImpl
    extends LoadBuilder<Load, LoadBuilderImpl> {
        @Generated
        private LoadBuilderImpl() {
        }

        @Override
        @Generated
        protected LoadBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Load build() {
            return new Load(this);
        }
    }
}

