/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.runners.RunContext;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Introspected
public class MongoDbConnection {
    @Schema(title="Connection string to mongodb server ", description="[url format](https://docs.mongodb.com/manual/reference/connection-string/) like `mongodb://mongodb0.example.com:27017`")
    @PluginProperty(dynamic=true)
    @NotNull
    @NotEmpty
    private String uri;

    MongoClient client(RunContext runContext) throws IllegalVariableEvaluationException {
        return MongoClients.create(runContext.render(this.uri));
    }

    @Generated
    protected MongoDbConnection(MongoDbConnectionBuilder<?, ?> b) {
        this.uri = b.uri;
    }

    @Generated
    public static MongoDbConnectionBuilder<?, ?> builder() {
        return new MongoDbConnectionBuilderImpl();
    }

    @Generated
    public MongoDbConnection() {
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public static abstract class MongoDbConnectionBuilder<C extends MongoDbConnection, B extends MongoDbConnectionBuilder<C, B>> {
        @Generated
        private String uri;

        @Generated
        public B uri(String uri) {
            this.uri = uri;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "MongoDbConnection.MongoDbConnectionBuilder(uri=" + this.uri + ")";
        }
    }

    @Generated
    private static final class MongoDbConnectionBuilderImpl
    extends MongoDbConnectionBuilder<MongoDbConnection, MongoDbConnectionBuilderImpl> {
        @Generated
        private MongoDbConnectionBuilderImpl() {
        }

        @Override
        @Generated
        protected MongoDbConnectionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MongoDbConnection build() {
            return new MongoDbConnection(this);
        }
    }
}

