/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.mongodb;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import java.io.IOException;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public abstract class MongoDbService {
    public static BsonDocument toDocument(RunContext runContext, Object value) throws IllegalVariableEvaluationException, IOException {
        if (value instanceof String) {
            return BsonDocument.parse(runContext.render((String)value));
        }
        if (value instanceof Map) {
            return BsonDocument.parse(JacksonMapper.ofJson().writeValueAsString((Object)runContext.render((Map)value)));
        }
        if (value == null) {
            return new BsonDocument();
        }
        throw new IllegalVariableEvaluationException("Invalid value type '" + value.getClass() + "'");
    }

    public static Object map(BsonValue doc) {
        switch (doc.getBsonType()) {
            case NULL: {
                return null;
            }
            case INT32: {
                return doc.asInt32().getValue();
            }
            case INT64: {
                return doc.asInt64().getValue();
            }
            case DOUBLE: {
                return doc.asDouble().getValue();
            }
            case DECIMAL128: {
                return doc.asDecimal128().getValue();
            }
            case STRING: {
                return doc.asString().getValue();
            }
            case BINARY: {
                return doc.asBinary().getData();
            }
            case BOOLEAN: {
                return doc.asBoolean().getValue();
            }
            case TIMESTAMP: {
                return Instant.ofEpochMilli(doc.asTimestamp().getValue());
            }
            case DATE_TIME: {
                return Instant.ofEpochMilli(doc.asDateTime().getValue());
            }
            case DOCUMENT: {
                return doc.asDocument().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, Object>((String)e.getKey(), MongoDbService.map((BsonValue)e.getValue()))).collect(HashMap::new, (m, v) -> m.put(v.getKey(), v.getValue()), HashMap::putAll);
            }
            case ARRAY: {
                return doc.asArray().stream().map(MongoDbService::map).collect(Collectors.toList());
            }
            case OBJECT_ID: {
                return doc.asObjectId().getValue().toString();
            }
            case UNDEFINED: {
                throw new IllegalArgumentException("Undefined BsonValue:" + doc);
            }
        }
        throw new IllegalArgumentException("Unsupported BsonValue " + doc.getBsonType() + ":" + doc);
    }
}

