/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.UpdateResult;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.mongodb.AbstractTask;
import io.kestra.plugin.mongodb.MongoDbService;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.slf4j.Logger;

@Schema(title="Update or Replace one or many documents")
@Plugin(examples={@Example(title="Replace a document", code={"connection:", "  uri: \"mongodb://root:example@localhost:27017/?authSource=admin\"", "database: \"my_database\"", "collection: \"my_collection\"", "operation: \"REPLACE_ONE\"", "document:", "  _id:", "    $oid: 60930c39a982931c20ef6cd6", "  name: \"John Doe\"", "  city: \"Paris\"", "filter:", "  _id:", "    $oid: 60930c39a982931c20ef6cd6"}), @Example(title="Update a document", code={"connection:", "  uri: \"mongodb://root:example@localhost:27017/?authSource=admin\"", "database: \"my_database\"", "collection: \"my_collection\"", "filter:", "  _id:", "    $oid: 60930c39a982931c20ef6cd6", "document: \"{\"$set\": { \"tags\": [\"blue\", \"green\", \"red\"]}}\""})})
public class Update
extends AbstractTask
implements RunnableTask<Output> {
    @Schema(title="The mongodb document", description="Can be a bson string, or a map")
    @PluginProperty(dynamic=true)
    @NotNull
    private Object document;
    @Schema(title="The mongodb bson filter", description="Can be a bson string, or a map")
    @PluginProperty(dynamic=true)
    @NotNull
    private Object filter;
    @Schema(title="Operation to use")
    @PluginProperty(dynamic=false)
    private Operation operation;

    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        try (MongoClient client = this.connection.client(runContext);){
            MongoCollection<Bson> collection = this.collection(runContext, client);
            BsonDocument bsonDocument = MongoDbService.toDocument(runContext, this.document);
            BsonDocument bsonFilter = MongoDbService.toDocument(runContext, this.filter);
            UpdateResult updateResult = this.operation == Operation.REPLACE_ONE ? collection.replaceOne(bsonFilter, bsonDocument) : (this.operation == Operation.UPDATE_ONE ? collection.updateOne((Bson)bsonFilter, bsonDocument) : collection.updateMany((Bson)bsonFilter, bsonDocument));
            logger.debug("Updating doc: {} with filter: {}", (Object)bsonDocument, (Object)bsonFilter);
            runContext.metric((AbstractMetricEntry)Counter.of((String)"updated.count", (Long)updateResult.getModifiedCount(), (String[])new String[]{"database", collection.getNamespace().getDatabaseName(), "collection", collection.getNamespace().getCollectionName()}));
            Output output = Output.builder().upsertedId(updateResult.getUpsertedId() != null ? updateResult.getUpsertedId().asObjectId().getValue().toString() : null).wasAcknowledged(updateResult.wasAcknowledged()).matchedCount(updateResult.getMatchedCount()).modifiedCount(updateResult.getModifiedCount()).build();
            return output;
        }
    }

    @Generated
    private static Operation $default$operation() {
        return Operation.UPDATE_ONE;
    }

    @Generated
    protected Update(UpdateBuilder<?, ?> b) {
        super(b);
        this.document = b.document;
        this.filter = b.filter;
        this.operation = b.operation$set ? b.operation$value : Update.$default$operation();
    }

    @Generated
    public static UpdateBuilder<?, ?> builder() {
        return new UpdateBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Update(super=" + super.toString() + ", document=" + this.getDocument() + ", filter=" + this.getFilter() + ", operation=" + this.getOperation() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Update)) {
            return false;
        }
        Update other = (Update)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$document = this.getDocument();
        Object other$document = other.getDocument();
        if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
            return false;
        }
        Object this$filter = this.getFilter();
        Object other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        Operation this$operation = this.getOperation();
        Operation other$operation = other.getOperation();
        return !(this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Update;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        Object $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        Operation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        return result;
    }

    @Generated
    public Object getDocument() {
        return this.document;
    }

    @Generated
    public Object getFilter() {
        return this.filter;
    }

    @Generated
    public Operation getOperation() {
        return this.operation;
    }

    @Generated
    public Update() {
        this.operation = Update.$default$operation();
    }

    @Introspected
    public static enum Operation {
        REPLACE_ONE,
        UPDATE_ONE,
        UPDATE_MANY;

    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The upserted Id", description="Will be null if `replace` operation")
        @Nullable
        private String upsertedId;
        @Schema(title="true if the write was acknowledged.")
        private Boolean wasAcknowledged;
        @Schema(title="The number of documents matched by the query.")
        private final long matchedCount;
        @Schema(title="The number of documents modified by the update.")
        private final Long modifiedCount;

        @ConstructorProperties(value={"upsertedId", "wasAcknowledged", "matchedCount", "modifiedCount"})
        @Generated
        Output(@Nullable String upsertedId, Boolean wasAcknowledged, long matchedCount, Long modifiedCount) {
            this.upsertedId = upsertedId;
            this.wasAcknowledged = wasAcknowledged;
            this.matchedCount = matchedCount;
            this.modifiedCount = modifiedCount;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Nullable
        @Generated
        public String getUpsertedId() {
            return this.upsertedId;
        }

        @Generated
        public Boolean getWasAcknowledged() {
            return this.wasAcknowledged;
        }

        @Generated
        public long getMatchedCount() {
            return this.matchedCount;
        }

        @Generated
        public Long getModifiedCount() {
            return this.modifiedCount;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private String upsertedId;
            @Generated
            private Boolean wasAcknowledged;
            @Generated
            private long matchedCount;
            @Generated
            private Long modifiedCount;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder upsertedId(@Nullable String upsertedId) {
                this.upsertedId = upsertedId;
                return this;
            }

            @Generated
            public OutputBuilder wasAcknowledged(Boolean wasAcknowledged) {
                this.wasAcknowledged = wasAcknowledged;
                return this;
            }

            @Generated
            public OutputBuilder matchedCount(long matchedCount) {
                this.matchedCount = matchedCount;
                return this;
            }

            @Generated
            public OutputBuilder modifiedCount(Long modifiedCount) {
                this.modifiedCount = modifiedCount;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.upsertedId, this.wasAcknowledged, this.matchedCount, this.modifiedCount);
            }

            @Generated
            public String toString() {
                return "Update.Output.OutputBuilder(upsertedId=" + this.upsertedId + ", wasAcknowledged=" + this.wasAcknowledged + ", matchedCount=" + this.matchedCount + ", modifiedCount=" + this.modifiedCount + ")";
            }
        }
    }

    @Generated
    public static abstract class UpdateBuilder<C extends Update, B extends UpdateBuilder<C, B>>
    extends AbstractTask.AbstractTaskBuilder<C, B> {
        @Generated
        private Object document;
        @Generated
        private Object filter;
        @Generated
        private boolean operation$set;
        @Generated
        private Operation operation$value;

        @Generated
        public B document(Object document) {
            this.document = document;
            return (B)((Object)this.self());
        }

        @Generated
        public B filter(Object filter) {
            this.filter = filter;
            return (B)((Object)this.self());
        }

        @Generated
        public B operation(Operation operation) {
            this.operation$value = operation;
            this.operation$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Update.UpdateBuilder(super=" + super.toString() + ", document=" + this.document + ", filter=" + this.filter + ", operation$value=" + this.operation$value + ")";
        }
    }

    @Generated
    private static final class UpdateBuilderImpl
    extends UpdateBuilder<Update, UpdateBuilderImpl> {
        @Generated
        private UpdateBuilderImpl() {
        }

        @Override
        @Generated
        protected UpdateBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Update build() {
            return new Update(this);
        }
    }
}

