/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.scripts;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.runners.ScriptService;
import io.kestra.core.runners.RunContext;
import io.kestra.core.tasks.PluginUtilsService;
import io.kestra.core.tasks.scripts.ScriptOutput;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.scripts.exec.scripts.models.DockerOptions;
import io.kestra.plugin.scripts.exec.scripts.models.RunnerType;
import io.kestra.plugin.scripts.exec.scripts.runners.CommandsWrapper;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;

@Deprecated
public abstract class AbstractBash
extends Task {
    @Schema(title="The task runner.")
    @PluginProperty
    @NotNull
    @NotEmpty
    protected RunnerType runner;
    @Schema(title="Docker options when using the `DOCKER` runner.")
    @PluginProperty
    protected DockerOptions dockerOptions;
    @Schema(title="Interpreter to use when launching the process.")
    @PluginProperty
    @NotNull
    @NotEmpty
    protected String interpreter;
    @Schema(title="Interpreter arguments to be used.")
    @PluginProperty
    protected String[] interpreterArgs;
    @Schema(title="Exit if any non-true value is returned.", description="This tells bash that it should exit the script if any statement returns a non-true return value. \nSetting this to `true` helps catch cases where a command fails and the script continues to run anyway.")
    @PluginProperty
    @NotNull
    protected Boolean exitOnFailed;
    @Schema(title="[Deprecated] The list of files that will be uploaded to Kestra's internal storage.", description="Use `outputFiles` instead.", deprecated=true)
    @PluginProperty(dynamic=true)
    @Deprecated
    protected List<String> files;
    @Schema(title="[Deprecated] Output files.", description="Use `outputFiles` instead.", deprecated=true)
    @PluginProperty
    @Deprecated
    protected List<String> outputsFiles;
    @Schema(title="Output file list that will be uploaded to Kestra's internal storage.", description="List of keys that will generate temporary files.\nThis property can be used with a special variable named `outputFiles.key`.\nIf you add a file with `[\"first\"]`, you can use the special var `echo 1 >> {[ outputFiles.first }}`, and on other tasks, you can reference it using `{{ outputs.taskId.outputFiles.first }}`.")
    @PluginProperty
    protected List<String> outputFiles;
    @Schema(title="List of output directories that will be uploaded to Kestra's internal storage.", description="List of keys that will generate temporary directories.\nThis property can be used with a special variable named `outputDirs.key`.\nIf you add a file with `[\"myDir\"]`, you can use the special var `echo 1 >> {[ outputDirs.myDir }}/file1.txt` and `echo 2 >> {[ outputDirs.myDir }}/file2.txt`, and both the files will be uploaded to Kestra's internal storage. You can reference them in other tasks using `{{ outputs.taskId.outputFiles['myDir/file1.txt'] }}`.")
    @PluginProperty
    protected List<String> outputDirs;
    @Schema(title="Input files are extra files that will be available in the script's working directory.", description="Define the files **as a map** of a file name being the key, and the value being the file's content.\nAlternatively, configure the files **as a JSON string** with the same key/value structure as the map.\nIn both cases, you can either specify the file's content inline, or reference a file from Kestra's internal storage by its URI, e.g. a file from an input, output of a previous task, or a [Namespace File](https://kestra.io/docs/developer-guide/namespace-files).")
    @PluginProperty(additionalProperties=String.class, dynamic=true)
    protected Object inputFiles;
    @Schema(title="One or more additional environment variable(s) to add to the task run.")
    @PluginProperty(additionalProperties=String.class, dynamic=true)
    protected Map<String, String> env;
    @Schema(title="Whether to set the execution state to `WARNING` if any `stdErr` is emitted.")
    @PluginProperty
    @NotNull
    protected Boolean warningOnStdErr;
    protected transient Path workingDirectory;
    protected transient Map<String, Object> additionalVars;

    protected List<String> finalInterpreter() {
        ArrayList<String> interpreters = new ArrayList<String>();
        interpreters.add(this.interpreter);
        interpreters.addAll(Arrays.asList(this.interpreterArgs));
        return interpreters;
    }

    protected Map<String, String> finalInputFiles(RunContext runContext) throws IOException, IllegalVariableEvaluationException {
        return this.inputFiles != null ? new HashMap(PluginUtilsService.transformInputFiles((RunContext)runContext, (Object)this.inputFiles)) : new HashMap();
    }

    protected Map<String, String> finalEnv() throws IOException {
        return this.env != null ? new HashMap<String, String>(this.env) : new HashMap();
    }

    protected ScriptOutput run(RunContext runContext, Supplier<String> commandsSupplier) throws Exception {
        ArrayList<String> allOutputs = new ArrayList<String>();
        if (this.workingDirectory == null) {
            this.workingDirectory = runContext.tempDir();
        }
        this.additionalVars.put("workingDir", this.workingDirectory.toAbsolutePath().toString());
        if (this.outputFiles != null && this.outputFiles.size() > 0) {
            allOutputs.addAll(this.outputFiles);
        }
        if (this.outputsFiles != null && this.outputsFiles.size() > 0) {
            allOutputs.addAll(this.outputsFiles);
        }
        if (this.files != null && this.files.size() > 0) {
            allOutputs.addAll(this.files);
        }
        Map outputFiles = PluginUtilsService.createOutputFiles((Path)this.workingDirectory, allOutputs, this.additionalVars);
        PluginUtilsService.createInputFiles((RunContext)runContext, (Path)this.workingDirectory, this.finalInputFiles(runContext), this.additionalVars);
        ArrayList<String> allOutputDirs = new ArrayList<String>();
        if (this.outputDirs != null && this.outputDirs.size() > 0) {
            allOutputDirs.addAll(this.outputDirs);
        }
        Map outputDirs = PluginUtilsService.createOutputFiles((Path)this.workingDirectory, allOutputDirs, this.additionalVars, (Boolean)true);
        List commandsArgs = ScriptService.scriptCommands(this.finalInterpreter(), List.of(), (String)commandsSupplier.get());
        io.kestra.plugin.scripts.exec.scripts.models.ScriptOutput run = new CommandsWrapper(runContext).withEnv(this.finalEnv()).withWarningOnStdErr(this.warningOnStdErr).withRunnerType(this.runner).withDockerOptions(this.getDockerOptions()).withCommands(commandsArgs).addAdditionalVars(this.additionalVars).run();
        HashMap<String, URI> uploaded = new HashMap<String, URI>();
        outputFiles.forEach(Rethrow.throwBiConsumer((k, v) -> uploaded.put((String)k, runContext.putTempFile(new File(runContext.render(v, this.additionalVars))))));
        outputDirs.forEach(Rethrow.throwBiConsumer((k, v) -> {
            try (Stream<Path> walk = Files.walk(new File(runContext.render(v, this.additionalVars)).toPath(), new FileVisitOption[0]);){
                walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(Rethrow.throwConsumer(path -> {
                    String filename = Path.of(k, Path.of(runContext.render(v, this.additionalVars), new String[0]).relativize((Path)path).toString()).toString();
                    uploaded.put(filename, runContext.putTempFile(path.toFile(), filename));
                }));
            }
        }));
        return ScriptOutput.builder().exitCode(run.getExitCode()).stdOutLineCount(run.getStdOutLineCount()).stdErrLineCount(run.getStdErrLineCount()).warningOnStdErr(this.warningOnStdErr).vars(run.getVars()).files(uploaded).outputFiles(uploaded).build();
    }

    @Generated
    private static RunnerType $default$runner() {
        return RunnerType.PROCESS;
    }

    @Generated
    private static String $default$interpreter() {
        return "/bin/sh";
    }

    @Generated
    private static String[] $default$interpreterArgs() {
        return new String[]{"-c"};
    }

    @Generated
    private static Boolean $default$exitOnFailed() {
        return true;
    }

    @Generated
    private static Boolean $default$warningOnStdErr() {
        return true;
    }

    @Generated
    private static Map<String, Object> $default$additionalVars() {
        return new HashMap<String, Object>();
    }

    @Generated
    protected AbstractBash(AbstractBashBuilder<?, ?> b) {
        super(b);
        this.runner = b.runner$set ? b.runner$value : AbstractBash.$default$runner();
        this.dockerOptions = b.dockerOptions;
        this.interpreter = b.interpreter$set ? b.interpreter$value : AbstractBash.$default$interpreter();
        this.interpreterArgs = b.interpreterArgs$set ? b.interpreterArgs$value : AbstractBash.$default$interpreterArgs();
        this.exitOnFailed = b.exitOnFailed$set ? b.exitOnFailed$value : AbstractBash.$default$exitOnFailed();
        this.files = b.files;
        this.outputsFiles = b.outputsFiles;
        this.outputFiles = b.outputFiles;
        this.outputDirs = b.outputDirs;
        this.inputFiles = b.inputFiles;
        this.env = b.env;
        this.warningOnStdErr = b.warningOnStdErr$set ? b.warningOnStdErr$value : AbstractBash.$default$warningOnStdErr();
        this.workingDirectory = b.workingDirectory;
        this.additionalVars = b.additionalVars$set ? b.additionalVars$value : AbstractBash.$default$additionalVars();
    }

    @Generated
    public String toString() {
        return "AbstractBash(super=" + super.toString() + ", runner=" + this.getRunner() + ", dockerOptions=" + this.getDockerOptions() + ", interpreter=" + this.getInterpreter() + ", interpreterArgs=" + Arrays.deepToString(this.getInterpreterArgs()) + ", exitOnFailed=" + this.getExitOnFailed() + ", files=" + this.getFiles() + ", outputsFiles=" + this.getOutputsFiles() + ", outputFiles=" + this.getOutputFiles() + ", outputDirs=" + this.getOutputDirs() + ", inputFiles=" + this.getInputFiles() + ", env=" + this.getEnv() + ", warningOnStdErr=" + this.getWarningOnStdErr() + ", workingDirectory=" + this.workingDirectory + ", additionalVars=" + this.additionalVars + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractBash)) {
            return false;
        }
        AbstractBash other = (AbstractBash)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$exitOnFailed = this.getExitOnFailed();
        Boolean other$exitOnFailed = other.getExitOnFailed();
        if (this$exitOnFailed == null ? other$exitOnFailed != null : !((Object)this$exitOnFailed).equals(other$exitOnFailed)) {
            return false;
        }
        Boolean this$warningOnStdErr = this.getWarningOnStdErr();
        Boolean other$warningOnStdErr = other.getWarningOnStdErr();
        if (this$warningOnStdErr == null ? other$warningOnStdErr != null : !((Object)this$warningOnStdErr).equals(other$warningOnStdErr)) {
            return false;
        }
        RunnerType this$runner = this.getRunner();
        RunnerType other$runner = other.getRunner();
        if (this$runner == null ? other$runner != null : !((Object)((Object)this$runner)).equals((Object)other$runner)) {
            return false;
        }
        DockerOptions this$dockerOptions = this.getDockerOptions();
        DockerOptions other$dockerOptions = other.getDockerOptions();
        if (this$dockerOptions == null ? other$dockerOptions != null : !this$dockerOptions.equals(other$dockerOptions)) {
            return false;
        }
        String this$interpreter = this.getInterpreter();
        String other$interpreter = other.getInterpreter();
        if (this$interpreter == null ? other$interpreter != null : !this$interpreter.equals(other$interpreter)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInterpreterArgs(), other.getInterpreterArgs())) {
            return false;
        }
        List<String> this$files = this.getFiles();
        List<String> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        List<String> this$outputsFiles = this.getOutputsFiles();
        List<String> other$outputsFiles = other.getOutputsFiles();
        if (this$outputsFiles == null ? other$outputsFiles != null : !((Object)this$outputsFiles).equals(other$outputsFiles)) {
            return false;
        }
        List<String> this$outputFiles = this.getOutputFiles();
        List<String> other$outputFiles = other.getOutputFiles();
        if (this$outputFiles == null ? other$outputFiles != null : !((Object)this$outputFiles).equals(other$outputFiles)) {
            return false;
        }
        List<String> this$outputDirs = this.getOutputDirs();
        List<String> other$outputDirs = other.getOutputDirs();
        if (this$outputDirs == null ? other$outputDirs != null : !((Object)this$outputDirs).equals(other$outputDirs)) {
            return false;
        }
        Object this$inputFiles = this.getInputFiles();
        Object other$inputFiles = other.getInputFiles();
        if (this$inputFiles == null ? other$inputFiles != null : !this$inputFiles.equals(other$inputFiles)) {
            return false;
        }
        Map<String, String> this$env = this.getEnv();
        Map<String, String> other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !((Object)this$env).equals(other$env));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractBash;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $exitOnFailed = this.getExitOnFailed();
        result = result * 59 + ($exitOnFailed == null ? 43 : ((Object)$exitOnFailed).hashCode());
        Boolean $warningOnStdErr = this.getWarningOnStdErr();
        result = result * 59 + ($warningOnStdErr == null ? 43 : ((Object)$warningOnStdErr).hashCode());
        RunnerType $runner = this.getRunner();
        result = result * 59 + ($runner == null ? 43 : ((Object)((Object)$runner)).hashCode());
        DockerOptions $dockerOptions = this.getDockerOptions();
        result = result * 59 + ($dockerOptions == null ? 43 : $dockerOptions.hashCode());
        String $interpreter = this.getInterpreter();
        result = result * 59 + ($interpreter == null ? 43 : $interpreter.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getInterpreterArgs());
        List<String> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        List<String> $outputsFiles = this.getOutputsFiles();
        result = result * 59 + ($outputsFiles == null ? 43 : ((Object)$outputsFiles).hashCode());
        List<String> $outputFiles = this.getOutputFiles();
        result = result * 59 + ($outputFiles == null ? 43 : ((Object)$outputFiles).hashCode());
        List<String> $outputDirs = this.getOutputDirs();
        result = result * 59 + ($outputDirs == null ? 43 : ((Object)$outputDirs).hashCode());
        Object $inputFiles = this.getInputFiles();
        result = result * 59 + ($inputFiles == null ? 43 : $inputFiles.hashCode());
        Map<String, String> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        return result;
    }

    @Generated
    public RunnerType getRunner() {
        return this.runner;
    }

    @Generated
    public DockerOptions getDockerOptions() {
        return this.dockerOptions;
    }

    @Generated
    public String getInterpreter() {
        return this.interpreter;
    }

    @Generated
    public String[] getInterpreterArgs() {
        return this.interpreterArgs;
    }

    @Generated
    public Boolean getExitOnFailed() {
        return this.exitOnFailed;
    }

    @Deprecated
    @Generated
    public List<String> getFiles() {
        return this.files;
    }

    @Deprecated
    @Generated
    public List<String> getOutputsFiles() {
        return this.outputsFiles;
    }

    @Generated
    public List<String> getOutputFiles() {
        return this.outputFiles;
    }

    @Generated
    public List<String> getOutputDirs() {
        return this.outputDirs;
    }

    @Generated
    public Object getInputFiles() {
        return this.inputFiles;
    }

    @Generated
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Generated
    public Boolean getWarningOnStdErr() {
        return this.warningOnStdErr;
    }

    @Generated
    public AbstractBash() {
        this.runner = AbstractBash.$default$runner();
        this.interpreter = AbstractBash.$default$interpreter();
        this.interpreterArgs = AbstractBash.$default$interpreterArgs();
        this.exitOnFailed = AbstractBash.$default$exitOnFailed();
        this.warningOnStdErr = AbstractBash.$default$warningOnStdErr();
        this.additionalVars = AbstractBash.$default$additionalVars();
    }

    @Generated
    public static abstract class AbstractBashBuilder<C extends AbstractBash, B extends AbstractBashBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private boolean runner$set;
        @Generated
        private RunnerType runner$value;
        @Generated
        private DockerOptions dockerOptions;
        @Generated
        private boolean interpreter$set;
        @Generated
        private String interpreter$value;
        @Generated
        private boolean interpreterArgs$set;
        @Generated
        private String[] interpreterArgs$value;
        @Generated
        private boolean exitOnFailed$set;
        @Generated
        private Boolean exitOnFailed$value;
        @Generated
        private List<String> files;
        @Generated
        private List<String> outputsFiles;
        @Generated
        private List<String> outputFiles;
        @Generated
        private List<String> outputDirs;
        @Generated
        private Object inputFiles;
        @Generated
        private Map<String, String> env;
        @Generated
        private boolean warningOnStdErr$set;
        @Generated
        private Boolean warningOnStdErr$value;
        @Generated
        private Path workingDirectory;
        @Generated
        private boolean additionalVars$set;
        @Generated
        private Map<String, Object> additionalVars$value;

        @Generated
        public B runner(RunnerType runner) {
            this.runner$value = runner;
            this.runner$set = true;
            return (B)this.self();
        }

        @Generated
        public B dockerOptions(DockerOptions dockerOptions) {
            this.dockerOptions = dockerOptions;
            return (B)this.self();
        }

        @Generated
        public B interpreter(String interpreter) {
            this.interpreter$value = interpreter;
            this.interpreter$set = true;
            return (B)this.self();
        }

        @Generated
        public B interpreterArgs(String[] interpreterArgs) {
            this.interpreterArgs$value = interpreterArgs;
            this.interpreterArgs$set = true;
            return (B)this.self();
        }

        @Generated
        public B exitOnFailed(Boolean exitOnFailed) {
            this.exitOnFailed$value = exitOnFailed;
            this.exitOnFailed$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B files(List<String> files) {
            this.files = files;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B outputsFiles(List<String> outputsFiles) {
            this.outputsFiles = outputsFiles;
            return (B)this.self();
        }

        @Generated
        public B outputFiles(List<String> outputFiles) {
            this.outputFiles = outputFiles;
            return (B)this.self();
        }

        @Generated
        public B outputDirs(List<String> outputDirs) {
            this.outputDirs = outputDirs;
            return (B)this.self();
        }

        @Generated
        public B inputFiles(Object inputFiles) {
            this.inputFiles = inputFiles;
            return (B)this.self();
        }

        @Generated
        public B env(Map<String, String> env) {
            this.env = env;
            return (B)this.self();
        }

        @Generated
        public B warningOnStdErr(Boolean warningOnStdErr) {
            this.warningOnStdErr$value = warningOnStdErr;
            this.warningOnStdErr$set = true;
            return (B)this.self();
        }

        @Generated
        public B workingDirectory(Path workingDirectory) {
            this.workingDirectory = workingDirectory;
            return (B)this.self();
        }

        @Generated
        public B additionalVars(Map<String, Object> additionalVars) {
            this.additionalVars$value = additionalVars;
            this.additionalVars$set = true;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractBash.AbstractBashBuilder(super=" + super.toString() + ", runner$value=" + this.runner$value + ", dockerOptions=" + this.dockerOptions + ", interpreter$value=" + this.interpreter$value + ", interpreterArgs$value=" + Arrays.deepToString(this.interpreterArgs$value) + ", exitOnFailed$value=" + this.exitOnFailed$value + ", files=" + this.files + ", outputsFiles=" + this.outputsFiles + ", outputFiles=" + this.outputFiles + ", outputDirs=" + this.outputDirs + ", inputFiles=" + this.inputFiles + ", env=" + this.env + ", warningOnStdErr$value=" + this.warningOnStdErr$value + ", workingDirectory=" + this.workingDirectory + ", additionalVars$value=" + this.additionalVars$value + ")";
        }
    }
}

