/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.groovy;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.scripts.jvm.Eval;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;

@Schema(title="Execute a Groovy script.")
@Plugin(examples={@Example(full=true, title="Make an API call and pass request body to a Groovy script.", code={"id: api-request-to-groovy\nnamespace: dev\n\ntasks:\n  - id: request\n    type: io.kestra.plugin.fs.http.Request\n    uri: \"https://dummyjson.com/products/1\"\n\n  - id: groovy\n    type: io.kestra.plugin.scripts.groovy.Eval\n    script: |\n      logger.info('{{ outputs.request.body }}')\n\n  - id: download\n    type: io.kestra.plugin.fs.http.Download\n    uri: \"https://dummyjson.com/products/1\"\n\n  - id: runContextGroovy\n    type: io.kestra.plugin.scripts.groovy.Eval\n    script: |\n      // logger.info('Vars: {}', runContext.getVariables())\n      URI uri = new URI(runContext.variables.outputs.download.uri)\n      InputStream istream = runContext.uriToInputStream(uri)\n      logger.info('Content: {}', istream.text)\n"}), @Example(code={"outputs:", "  - out", "  - map", "script: |", "  import io.kestra.core.models.executions.metrics.Counter", "  ", "  logger.info('executionId: {}', runContext.render('{{ execution.id }}'))", "  runContext.metric(Counter.of('total', 666, 'name', 'bla'))", "  ", "  map = Map.of('test', 'here')", "  File tempFile = runContext.tempFile().toFile()", "  var output = new FileOutputStream(tempFile)", "  output.write('555\\n666\\n'.getBytes())", "  ", "  out = runContext.putTempFile(tempFile)"})})
public class Eval
extends io.kestra.plugin.scripts.jvm.Eval {
    public Eval.Output run(RunContext runContext) throws Exception {
        return this.run(runContext, "groovy");
    }

    @Generated
    protected Eval(EvalBuilder<?, ?> b) {
        super((Eval.EvalBuilder<?, ?>)b);
    }

    @Generated
    public static EvalBuilder<?, ?> builder() {
        return new EvalBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Eval(super=" + super.toString() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Eval)) {
            return false;
        }
        Eval other = (Eval)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Eval;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public Eval() {
    }

    @Generated
    private static final class EvalBuilderImpl
    extends EvalBuilder<Eval, EvalBuilderImpl> {
        @Generated
        private EvalBuilderImpl() {
        }

        @Override
        @Generated
        protected EvalBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Eval build() {
            return new Eval(this);
        }
    }

    @Generated
    public static abstract class EvalBuilder<C extends Eval, B extends EvalBuilder<C, B>>
    extends Eval.EvalBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Eval.EvalBuilder(super=" + super.toString() + ")";
        }
    }
}

