/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.exec;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.InputFilesInterface;
import io.kestra.core.models.tasks.NamespaceFiles;
import io.kestra.core.models.tasks.NamespaceFilesInterface;
import io.kestra.core.models.tasks.OutputFilesInterface;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.scripts.exec.scripts.models.DockerOptions;
import io.kestra.plugin.scripts.exec.scripts.models.RunnerType;
import io.kestra.plugin.scripts.exec.scripts.models.ScriptOutput;
import io.kestra.plugin.scripts.exec.scripts.runners.CommandsWrapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public abstract class AbstractExecScript
extends Task
implements RunnableTask<ScriptOutput>,
NamespaceFilesInterface,
InputFilesInterface,
OutputFilesInterface {
    @Schema(title="Runner to use")
    @PluginProperty
    @NotNull
    @NotEmpty
    protected RunnerType runner;
    @Schema(title="A list of commands that will run before `commands`, allowing to set up the environment e.g. `pip install -r requirements.txt`")
    @PluginProperty(dynamic=true)
    protected List<String> beforeCommands;
    @Schema(title="Additional environment variables for the current process.")
    @PluginProperty(additionalProperties=String.class, dynamic=true)
    protected Map<String, String> env;
    @Schema(title="Set the task state to `WARNING`if any `stdErr` is emitted")
    @PluginProperty
    @NotNull
    protected Boolean warningOnStdErr;
    @Schema(title="Which interpreter to use")
    @PluginProperty
    @NotNull
    @NotEmpty
    protected List<String> interpreter;
    private NamespaceFiles namespaceFiles;
    private Object inputFiles;
    private List<String> outputFiles;

    public abstract DockerOptions getDocker();

    protected DockerOptions injectDefaults(@NotNull DockerOptions original) {
        return original;
    }

    protected CommandsWrapper commands(RunContext runContext) throws IllegalVariableEvaluationException {
        return new CommandsWrapper(runContext).withEnv(this.getEnv()).withWarningOnStdErr(this.getWarningOnStdErr()).withRunnerType(this.getRunner()).withDockerOptions(this.injectDefaults(this.getDocker())).withNamespaceFiles(this.namespaceFiles).withInputFiles(this.inputFiles).withOutputFiles(this.outputFiles);
    }

    @Generated
    private static RunnerType $default$runner() {
        return RunnerType.DOCKER;
    }

    @Generated
    private static Boolean $default$warningOnStdErr() {
        return true;
    }

    @Generated
    private static List<String> $default$interpreter() {
        return List.of("/bin/sh", "-c");
    }

    @Generated
    protected AbstractExecScript(AbstractExecScriptBuilder<?, ?> b) {
        super(b);
        this.runner = b.runner$set ? b.runner$value : AbstractExecScript.$default$runner();
        this.beforeCommands = b.beforeCommands;
        this.env = b.env;
        this.warningOnStdErr = b.warningOnStdErr$set ? b.warningOnStdErr$value : AbstractExecScript.$default$warningOnStdErr();
        this.interpreter = b.interpreter$set ? b.interpreter$value : AbstractExecScript.$default$interpreter();
        this.namespaceFiles = b.namespaceFiles;
        this.inputFiles = b.inputFiles;
        this.outputFiles = b.outputFiles;
    }

    @Generated
    public String toString() {
        return "AbstractExecScript(super=" + super.toString() + ", runner=" + this.getRunner() + ", beforeCommands=" + this.getBeforeCommands() + ", env=" + this.getEnv() + ", warningOnStdErr=" + this.getWarningOnStdErr() + ", interpreter=" + this.getInterpreter() + ", namespaceFiles=" + this.getNamespaceFiles() + ", inputFiles=" + this.getInputFiles() + ", outputFiles=" + this.getOutputFiles() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractExecScript)) {
            return false;
        }
        AbstractExecScript other = (AbstractExecScript)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$warningOnStdErr = this.getWarningOnStdErr();
        Boolean other$warningOnStdErr = other.getWarningOnStdErr();
        if (this$warningOnStdErr == null ? other$warningOnStdErr != null : !((Object)this$warningOnStdErr).equals(other$warningOnStdErr)) {
            return false;
        }
        RunnerType this$runner = this.getRunner();
        RunnerType other$runner = other.getRunner();
        if (this$runner == null ? other$runner != null : !((Object)((Object)this$runner)).equals((Object)other$runner)) {
            return false;
        }
        List<String> this$beforeCommands = this.getBeforeCommands();
        List<String> other$beforeCommands = other.getBeforeCommands();
        if (this$beforeCommands == null ? other$beforeCommands != null : !((Object)this$beforeCommands).equals(other$beforeCommands)) {
            return false;
        }
        Map<String, String> this$env = this.getEnv();
        Map<String, String> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        List<String> this$interpreter = this.getInterpreter();
        List<String> other$interpreter = other.getInterpreter();
        if (this$interpreter == null ? other$interpreter != null : !((Object)this$interpreter).equals(other$interpreter)) {
            return false;
        }
        NamespaceFiles this$namespaceFiles = this.getNamespaceFiles();
        NamespaceFiles other$namespaceFiles = other.getNamespaceFiles();
        if (this$namespaceFiles == null ? other$namespaceFiles != null : !this$namespaceFiles.equals(other$namespaceFiles)) {
            return false;
        }
        Object this$inputFiles = this.getInputFiles();
        Object other$inputFiles = other.getInputFiles();
        if (this$inputFiles == null ? other$inputFiles != null : !this$inputFiles.equals(other$inputFiles)) {
            return false;
        }
        List<String> this$outputFiles = this.getOutputFiles();
        List<String> other$outputFiles = other.getOutputFiles();
        return !(this$outputFiles == null ? other$outputFiles != null : !((Object)this$outputFiles).equals(other$outputFiles));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractExecScript;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $warningOnStdErr = this.getWarningOnStdErr();
        result = result * 59 + ($warningOnStdErr == null ? 43 : ((Object)$warningOnStdErr).hashCode());
        RunnerType $runner = this.getRunner();
        result = result * 59 + ($runner == null ? 43 : ((Object)((Object)$runner)).hashCode());
        List<String> $beforeCommands = this.getBeforeCommands();
        result = result * 59 + ($beforeCommands == null ? 43 : ((Object)$beforeCommands).hashCode());
        Map<String, String> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        List<String> $interpreter = this.getInterpreter();
        result = result * 59 + ($interpreter == null ? 43 : ((Object)$interpreter).hashCode());
        NamespaceFiles $namespaceFiles = this.getNamespaceFiles();
        result = result * 59 + ($namespaceFiles == null ? 43 : $namespaceFiles.hashCode());
        Object $inputFiles = this.getInputFiles();
        result = result * 59 + ($inputFiles == null ? 43 : $inputFiles.hashCode());
        List<String> $outputFiles = this.getOutputFiles();
        result = result * 59 + ($outputFiles == null ? 43 : ((Object)$outputFiles).hashCode());
        return result;
    }

    @Generated
    public RunnerType getRunner() {
        return this.runner;
    }

    @Generated
    public List<String> getBeforeCommands() {
        return this.beforeCommands;
    }

    @Generated
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Generated
    public Boolean getWarningOnStdErr() {
        return this.warningOnStdErr;
    }

    @Generated
    public List<String> getInterpreter() {
        return this.interpreter;
    }

    @Generated
    public NamespaceFiles getNamespaceFiles() {
        return this.namespaceFiles;
    }

    @Generated
    public Object getInputFiles() {
        return this.inputFiles;
    }

    @Generated
    public List<String> getOutputFiles() {
        return this.outputFiles;
    }

    @Generated
    public AbstractExecScript() {
        this.runner = AbstractExecScript.$default$runner();
        this.warningOnStdErr = AbstractExecScript.$default$warningOnStdErr();
        this.interpreter = AbstractExecScript.$default$interpreter();
    }

    @Generated
    public static abstract class AbstractExecScriptBuilder<C extends AbstractExecScript, B extends AbstractExecScriptBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private boolean runner$set;
        @Generated
        private RunnerType runner$value;
        @Generated
        private List<String> beforeCommands;
        @Generated
        private Map<String, String> env;
        @Generated
        private boolean warningOnStdErr$set;
        @Generated
        private Boolean warningOnStdErr$value;
        @Generated
        private boolean interpreter$set;
        @Generated
        private List<String> interpreter$value;
        @Generated
        private NamespaceFiles namespaceFiles;
        @Generated
        private Object inputFiles;
        @Generated
        private List<String> outputFiles;

        @Generated
        public B runner(RunnerType runner) {
            this.runner$value = runner;
            this.runner$set = true;
            return (B)this.self();
        }

        @Generated
        public B beforeCommands(List<String> beforeCommands) {
            this.beforeCommands = beforeCommands;
            return (B)this.self();
        }

        @Generated
        public B env(Map<String, String> env) {
            this.env = env;
            return (B)this.self();
        }

        @Generated
        public B warningOnStdErr(Boolean warningOnStdErr) {
            this.warningOnStdErr$value = warningOnStdErr;
            this.warningOnStdErr$set = true;
            return (B)this.self();
        }

        @Generated
        public B interpreter(List<String> interpreter) {
            this.interpreter$value = interpreter;
            this.interpreter$set = true;
            return (B)this.self();
        }

        @Generated
        public B namespaceFiles(NamespaceFiles namespaceFiles) {
            this.namespaceFiles = namespaceFiles;
            return (B)this.self();
        }

        @Generated
        public B inputFiles(Object inputFiles) {
            this.inputFiles = inputFiles;
            return (B)this.self();
        }

        @Generated
        public B outputFiles(List<String> outputFiles) {
            this.outputFiles = outputFiles;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractExecScript.AbstractExecScriptBuilder(super=" + super.toString() + ", runner$value=" + this.runner$value + ", beforeCommands=" + this.beforeCommands + ", env=" + this.env + ", warningOnStdErr$value=" + this.warningOnStdErr$value + ", interpreter$value=" + this.interpreter$value + ", namespaceFiles=" + this.namespaceFiles + ", inputFiles=" + this.inputFiles + ", outputFiles=" + this.outputFiles + ")";
        }
    }
}

