/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.exec.scripts.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.Output;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class ScriptOutput
implements Output {
    @Schema(title="The value extracted from the output of the executed `commands`")
    private final Map<String, Object> vars;
    @Schema(title="The exit code of the entire Flow Execution")
    @NotNull
    private final int exitCode;
    @Schema(title="The output files URI in Kestra internal storage")
    @PluginProperty(additionalProperties=URI.class)
    private final Map<String, URI> outputFiles;
    @JsonIgnore
    private final int stdOutLineCount;
    @JsonIgnore
    private final int stdErrLineCount;
    @JsonIgnore
    private Boolean warningOnStdErr;

    public Optional<State.Type> finalState() {
        return this.warningOnStdErr != null && this.warningOnStdErr != false && this.stdErrLineCount > 0 ? Optional.of(State.Type.WARNING) : super.finalState();
    }

    @ConstructorProperties(value={"vars", "exitCode", "outputFiles", "stdOutLineCount", "stdErrLineCount", "warningOnStdErr"})
    @Generated
    ScriptOutput(Map<String, Object> vars, int exitCode, Map<String, URI> outputFiles, int stdOutLineCount, int stdErrLineCount, Boolean warningOnStdErr) {
        this.vars = vars;
        this.exitCode = exitCode;
        this.outputFiles = outputFiles;
        this.stdOutLineCount = stdOutLineCount;
        this.stdErrLineCount = stdErrLineCount;
        this.warningOnStdErr = warningOnStdErr;
    }

    @Generated
    public static ScriptOutputBuilder builder() {
        return new ScriptOutputBuilder();
    }

    @Generated
    public Map<String, Object> getVars() {
        return this.vars;
    }

    @Generated
    public int getExitCode() {
        return this.exitCode;
    }

    @Generated
    public Map<String, URI> getOutputFiles() {
        return this.outputFiles;
    }

    @Generated
    public int getStdOutLineCount() {
        return this.stdOutLineCount;
    }

    @Generated
    public int getStdErrLineCount() {
        return this.stdErrLineCount;
    }

    @Generated
    public Boolean getWarningOnStdErr() {
        return this.warningOnStdErr;
    }

    @Generated
    public static class ScriptOutputBuilder {
        @Generated
        private Map<String, Object> vars;
        @Generated
        private int exitCode;
        @Generated
        private Map<String, URI> outputFiles;
        @Generated
        private int stdOutLineCount;
        @Generated
        private int stdErrLineCount;
        @Generated
        private Boolean warningOnStdErr;

        @Generated
        ScriptOutputBuilder() {
        }

        @Generated
        public ScriptOutputBuilder vars(Map<String, Object> vars) {
            this.vars = vars;
            return this;
        }

        @Generated
        public ScriptOutputBuilder exitCode(int exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        @Generated
        public ScriptOutputBuilder outputFiles(Map<String, URI> outputFiles) {
            this.outputFiles = outputFiles;
            return this;
        }

        @JsonIgnore
        @Generated
        public ScriptOutputBuilder stdOutLineCount(int stdOutLineCount) {
            this.stdOutLineCount = stdOutLineCount;
            return this;
        }

        @JsonIgnore
        @Generated
        public ScriptOutputBuilder stdErrLineCount(int stdErrLineCount) {
            this.stdErrLineCount = stdErrLineCount;
            return this;
        }

        @JsonIgnore
        @Generated
        public ScriptOutputBuilder warningOnStdErr(Boolean warningOnStdErr) {
            this.warningOnStdErr = warningOnStdErr;
            return this;
        }

        @Generated
        public ScriptOutput build() {
            return new ScriptOutput(this.vars, this.exitCode, this.outputFiles, this.stdOutLineCount, this.stdErrLineCount, this.warningOnStdErr);
        }

        @Generated
        public String toString() {
            return "ScriptOutput.ScriptOutputBuilder(vars=" + this.vars + ", exitCode=" + this.exitCode + ", outputFiles=" + this.outputFiles + ", stdOutLineCount=" + this.stdOutLineCount + ", stdErrLineCount=" + this.stdErrLineCount + ", warningOnStdErr=" + this.warningOnStdErr + ")";
        }
    }
}

