/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.jvm;

import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.FileSerde;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.plugin.scripts.jvm.AbstractJvmScript;
import io.kestra.plugin.scripts.jvm.ScriptEngineService;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.script.Bindings;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.reactivestreams.Publisher;

@Schema(title="Transform ion format file from kestra with a groovy script.", description="This allow you to transform the data previously loaded by kestra as you need.\n\nTake a ion format file from kestra and iterate row per row.\nEach row will populate a `row` global variable, you need to alter this variable that will be saved on output file.\nif you set the `row` to `null`, the row will be skipped\nYou can create a variables `rows` to return many rows for a single `row`.\n")
public abstract class FileTransform
extends AbstractJvmScript
implements RunnableTask<Output> {
    @NotNull
    @Schema(title="Source file of row to transform", description="Can be an internal storage uri, a map or a list.")
    @PluginProperty(dynamic=true)
    private String from;
    @Min(value=2L)
    @Schema(title="Number of concurrent parallels transform", description="Take care that the order is **not respected** if you use parallelism")
    @PluginProperty(dynamic=false)
    private @Min(value=2L) Integer concurrent;

    protected Output run(RunContext runContext, String engineName) throws Exception {
        String from = runContext.render(this.from);
        File tempFile = runContext.tempFile(".ion").toFile();
        ScriptEngineService.CompiledScript scripts = ScriptEngineService.scripts(runContext, engineName, this.generateScript(runContext), ((Object)((Object)this)).getClass().getClassLoader());
        try (FileOutputStream output = new FileOutputStream(tempFile);){
            if (from.startsWith("kestra://")) {
                try (BufferedReader inputStream = new BufferedReader(new InputStreamReader(runContext.uriToInputStream(URI.create(from))));){
                    this.finalize(runContext, (Flowable<Object>)Flowable.create((FlowableOnSubscribe)FileSerde.reader((BufferedReader)inputStream), (BackpressureStrategy)BackpressureStrategy.BUFFER), scripts, output);
                }
            } else {
                this.finalize(runContext, (Flowable<Object>)Flowable.create(emitter -> {
                    Object o = JacksonMapper.toObject((String)from);
                    if (o instanceof List) {
                        ((List)o).forEach(arg_0 -> ((FlowableEmitter)emitter).onNext(arg_0));
                    } else {
                        emitter.onNext(o);
                    }
                    emitter.onComplete();
                }, (BackpressureStrategy)BackpressureStrategy.BUFFER), scripts, output);
            }
            output.flush();
        }
        return Output.builder().uri(runContext.putTempFile(tempFile)).build();
    }

    protected void finalize(RunContext runContext, Flowable<Object> flowable, ScriptEngineService.CompiledScript scripts, OutputStream output) {
        Flowable sequential = this.concurrent != null ? flowable.parallel(this.concurrent.intValue()).runOn(Schedulers.io()).flatMap(this.convert(scripts)).sequential() : flowable.flatMap(this.convert(scripts));
        Single count = sequential.doOnNext(row -> FileSerde.write((OutputStream)output, (Object)row)).count();
        Long lineCount = (Long)count.blockingGet();
        runContext.metric((AbstractMetricEntry)Counter.of((String)"records", (Long)lineCount, (String[])new String[0]));
    }

    protected Function<Object, Publisher<Object>> convert(ScriptEngineService.CompiledScript script) {
        return row -> {
            Bindings bindings = script.getBindings().get();
            bindings.put("row", row);
            script.getScript().eval(bindings);
            if (bindings.get("rows") != null) {
                return Flowable.fromIterable((Iterable)((Collection)bindings.get("rows")));
            }
            if (bindings.get("row") != null) {
                return Flowable.just((Object)bindings.get("row"));
            }
            return Flowable.empty();
        };
    }

    @Generated
    protected FileTransform(FileTransformBuilder<?, ?> b) {
        super(b);
        this.from = b.from;
        this.concurrent = b.concurrent;
    }

    @Override
    @Generated
    public String toString() {
        return "FileTransform(super=" + super.toString() + ", from=" + this.getFrom() + ", concurrent=" + this.getConcurrent() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileTransform)) {
            return false;
        }
        FileTransform other = (FileTransform)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$concurrent = this.getConcurrent();
        Integer other$concurrent = other.getConcurrent();
        if (this$concurrent == null ? other$concurrent != null : !((Object)this$concurrent).equals(other$concurrent)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        return !(this$from == null ? other$from != null : !this$from.equals(other$from));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileTransform;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $concurrent = this.getConcurrent();
        result = result * 59 + ($concurrent == null ? 43 : ((Object)$concurrent).hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        return result;
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Generated
    public Integer getConcurrent() {
        return this.concurrent;
    }

    @Generated
    public FileTransform() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="URI of a temporary result file", description="The file will be serialized as ion file.")
        private final URI uri;

        @ConstructorProperties(value={"uri"})
        @Generated
        Output(URI uri) {
            this.uri = uri;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI uri;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uri);
            }

            @Generated
            public String toString() {
                return "FileTransform.Output.OutputBuilder(uri=" + this.uri + ")";
            }
        }
    }

    @Generated
    public static abstract class FileTransformBuilder<C extends FileTransform, B extends FileTransformBuilder<C, B>>
    extends AbstractJvmScript.AbstractJvmScriptBuilder<C, B> {
        @Generated
        private String from;
        @Generated
        private Integer concurrent;

        @Generated
        public B from(String from) {
            this.from = from;
            return (B)((Object)this.self());
        }

        @Generated
        public B concurrent(Integer concurrent) {
            this.concurrent = concurrent;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "FileTransform.FileTransformBuilder(super=" + super.toString() + ", from=" + this.from + ", concurrent=" + this.concurrent + ")";
        }
    }
}

