/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.jvm;

import io.kestra.core.runners.RunContext;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import lombok.Generated;
import org.slf4j.Logger;

public abstract class ScriptEngineService {
    public static CompiledScript scripts(RunContext runContext, String engineName, String script, ClassLoader classLoader) throws ScriptException {
        Logger logger = runContext.logger();
        ScriptEngineManager manager = new ScriptEngineManager(classLoader);
        ScriptEngine engine = manager.getEngineByName(engineName);
        HashMap<String, Object> map = new HashMap<String, Object>();
        runContext.getVariables().forEach(map::put);
        map.put("runContext", runContext);
        map.put("logger", logger);
        return new CompiledScript(engine, ((Compilable)((Object)engine)).compile(script), () -> {
            Bindings bindings = engine.createBindings();
            bindings.putAll((Map<? extends String, ? extends Object>)map);
            return bindings;
        });
    }

    static class CompiledScript {
        private final ScriptEngine engine;
        private final javax.script.CompiledScript script;
        private final Supplier<Bindings> bindings;

        @Generated
        public ScriptEngine getEngine() {
            return this.engine;
        }

        @Generated
        public javax.script.CompiledScript getScript() {
            return this.script;
        }

        @Generated
        public Supplier<Bindings> getBindings() {
            return this.bindings;
        }

        @ConstructorProperties(value={"engine", "script", "bindings"})
        @Generated
        public CompiledScript(ScriptEngine engine, javax.script.CompiledScript script, Supplier<Bindings> bindings) {
            this.engine = engine;
            this.script = script;
            this.bindings = bindings;
        }
    }
}

