/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class DockerContextMetaFile {
    private static HashFunction metaHashFunction = Hashing.sha256();
    @JsonProperty(value="Name")
    String name;
    @JsonProperty(value="Endpoints")
    Endpoints endpoints;

    public static Optional<DockerContextMetaFile> resolveContextMetaFile(ObjectMapper objectMapper, File dockerConfigPath, String context) {
        File path = dockerConfigPath.toPath().resolve("contexts").resolve("meta").resolve(metaHashFunction.hashString(context, StandardCharsets.UTF_8).toString()).resolve("meta.json").toFile();
        return Optional.ofNullable(DockerContextMetaFile.loadContextMetaFile(objectMapper, path));
    }

    public static Optional<File> resolveContextTLSFile(File dockerConfigPath, String context) {
        File path = dockerConfigPath.toPath().resolve("contexts").resolve("tls").resolve(metaHashFunction.hashString(context, StandardCharsets.UTF_8).toString()).resolve("docker").toFile();
        return Optional.ofNullable(path).filter(File::exists);
    }

    public static DockerContextMetaFile loadContextMetaFile(ObjectMapper objectMapper, File dockerContextMetaFile) {
        try {
            return DockerContextMetaFile.parseContextMetaFile(objectMapper, dockerContextMetaFile);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static DockerContextMetaFile parseContextMetaFile(ObjectMapper objectMapper, File dockerContextMetaFile) throws IOException {
        try {
            return (DockerContextMetaFile)objectMapper.readValue(dockerContextMetaFile, DockerContextMetaFile.class);
        }
        catch (IOException e) {
            throw new IOException("Failed to parse docker context meta file " + dockerContextMetaFile, e);
        }
    }

    public static class Endpoints {
        @JsonProperty(value="docker")
        Docker docker;

        public static class Docker {
            @JsonProperty(value="Host")
            String host;
            @JsonProperty(value="SkipTLSVerify")
            boolean skipTLSVerify;
        }
    }
}

