/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.node;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.runners.ScriptService;
import io.kestra.core.models.tasks.runners.TaskCommands;
import io.kestra.core.runners.FilesService;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.scripts.exec.AbstractExecScript;
import io.kestra.plugin.scripts.exec.scripts.models.DockerOptions;
import io.kestra.plugin.scripts.exec.scripts.models.ScriptOutput;
import io.kestra.plugin.scripts.exec.scripts.runners.CommandsWrapper;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@Schema(title="Execute a Node.js script.")
@Plugin(examples={@Example(title="Install package, create a Node.js script and execute it.", code={"beforeCommands:", "  - npm install colors", "script: |", "  const colors = require(\"colors\");", "  console.log(colors.red(\"Hello\"));", "warningOnStdErr: false"}), @Example(full=true, title="If you want to generate files in your script to make them available for download and use in downstream tasks, you can leverage the `{{ outputDir }}` variable. Files stored in that directory will be persisted in Kestra's internal storage. To access this output in downstream tasks, use the syntax `{{ outputs.yourTaskId.outputFiles['yourFileName.fileExtension'] }}`.\n\nAlternatively, instead of the `{{ outputDir }}` variable, you could use the `outputFiles` property to output files from your script. You can access those files in downstream tasks using the same syntax `{{ outputs.yourTaskId.outputFiles['yourFileName.fileExtension'] }}`, and you can download the files from the UI's Output tab.\n", code={"id: nodeJS\nnamespace: dev\ntasks:\n  - id: node\n    type: io.kestra.plugin.scripts.node.Script\n    warningOnStdErr: false\n    beforeCommands:\n        - npm install json2csv > /dev/null 2>&1\n    script: |\n        const fs = require('fs');\n        const { Parser } = require('json2csv');\n\n        // Product prices in our simulation\n        const productPrices = {\n            'T-shirt': 20,\n            'Jeans': 75,\n            'Shoes': 80,\n            'Socks': 5,\n            'Hat': 25\n        }\n\n        const generateOrder = () => {\n            const products = ['T-shirt', 'Jeans', 'Shoes', 'Socks', 'Hat'];\n            const statuses = ['pending', 'shipped', 'delivered', 'cancelled'];\n\n            const randomProduct = products[Math.floor(Math.random() * products.length)];\n            const randomStatus = statuses[Math.floor(Math.random() * statuses.length)];\n            const randomQuantity = Math.floor(Math.random() * 10) + 1;\n\n            const order = {\n                product: randomProduct,\n                status: randomStatus,\n                quantity: randomQuantity,\n                total: randomQuantity * productPrices[randomProduct]\n            };\n\n            return order;\n        }\n\n        let totalSales = 0;\n        let orders = [];\n\n        for (let i = 0; i < 100; i++) {\n            const order = generateOrder();\n            orders.push(order);\n            totalSales += order.total;\n        }\n\n        console.log(`Total sales: $${totalSales}`);\n\n        const fields = ['product', 'status', 'quantity', 'total'];\n        const json2csvParser = new Parser({ fields });\n        const csvData = json2csvParser.parse(orders);\n\n        fs.writeFileSync('{{ outputDir }}/orders.csv', csvData);\n\n        console.log('Orders saved to orders.csv');\n"})})
public class Script
extends AbstractExecScript {
    private static final String DEFAULT_IMAGE = "node";
    @Schema(title="Docker options when using the `DOCKER` runner.", defaultValue="{image=node, pullPolicy=ALWAYS}")
    @PluginProperty
    protected DockerOptions docker;
    protected String containerImage;
    @Schema(title="The inline script content. This property is intended for the script file's content as a (multiline) string, not a path to a file. To run a command from a file such as `bash myscript.sh` or `python myscript.py`, use the `Commands` task instead.")
    @PluginProperty(dynamic=true)
    @NotNull
    @NotEmpty
    protected String script;

    @Override
    protected DockerOptions injectDefaults(DockerOptions original) {
        DockerOptions.DockerOptionsBuilder<?, ?> builder = original.toBuilder();
        if (original.getImage() == null) {
            builder.image(DEFAULT_IMAGE);
        }
        return builder.build();
    }

    public ScriptOutput run(RunContext runContext) throws Exception {
        CommandsWrapper commands = this.commands(runContext);
        Map inputFiles = FilesService.inputFiles((RunContext)runContext, (Map)commands.getTaskRunner().additionalVars(runContext, (TaskCommands)commands), (Object)this.getInputFiles());
        ArrayList<String> internalToLocalFiles = new ArrayList<String>();
        Path relativeScriptPath = runContext.tempDir().relativize(runContext.tempFile(".js"));
        inputFiles.put(relativeScriptPath.toString(), commands.render(runContext, this.script, internalToLocalFiles));
        commands = commands.withInputFiles(inputFiles);
        List commandsArgs = ScriptService.scriptCommands((List)this.interpreter, this.getBeforeCommandsWithOptions(), (String)String.join((CharSequence)" ", DEFAULT_IMAGE, relativeScriptPath.toString()));
        return commands.addEnv(Map.of("PYTHONUNBUFFERED", "true", "PIP_ROOT_USER_ACTION", "ignore")).withCommands(commandsArgs).run();
    }

    @Generated
    private static DockerOptions $default$docker() {
        return DockerOptions.builder().build();
    }

    @Generated
    private static String $default$containerImage() {
        return DEFAULT_IMAGE;
    }

    @Generated
    protected Script(ScriptBuilder<?, ?> b) {
        super(b);
        this.docker = b.docker$set ? b.docker$value : Script.$default$docker();
        this.containerImage = b.containerImage$set ? b.containerImage$value : Script.$default$containerImage();
        this.script = b.script;
    }

    @Generated
    public static ScriptBuilder<?, ?> builder() {
        return new ScriptBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Script(super=" + super.toString() + ", docker=" + this.getDocker() + ", containerImage=" + this.getContainerImage() + ", script=" + this.getScript() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Script)) {
            return false;
        }
        Script other = (Script)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerOptions this$docker = this.getDocker();
        DockerOptions other$docker = other.getDocker();
        if (this$docker == null ? other$docker != null : !this$docker.equals(other$docker)) {
            return false;
        }
        String this$containerImage = this.getContainerImage();
        String other$containerImage = other.getContainerImage();
        if (this$containerImage == null ? other$containerImage != null : !this$containerImage.equals(other$containerImage)) {
            return false;
        }
        String this$script = this.getScript();
        String other$script = other.getScript();
        return !(this$script == null ? other$script != null : !this$script.equals(other$script));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Script;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DockerOptions $docker = this.getDocker();
        result = result * 59 + ($docker == null ? 43 : $docker.hashCode());
        String $containerImage = this.getContainerImage();
        result = result * 59 + ($containerImage == null ? 43 : $containerImage.hashCode());
        String $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        return result;
    }

    @Override
    @Generated
    public DockerOptions getDocker() {
        return this.docker;
    }

    @Override
    @Generated
    public String getContainerImage() {
        return this.containerImage;
    }

    @Generated
    public String getScript() {
        return this.script;
    }

    @Generated
    public Script() {
        this.docker = Script.$default$docker();
        this.containerImage = Script.$default$containerImage();
    }

    @Generated
    public static abstract class ScriptBuilder<C extends Script, B extends ScriptBuilder<C, B>>
    extends AbstractExecScript.AbstractExecScriptBuilder<C, B> {
        @Generated
        private boolean docker$set;
        @Generated
        private DockerOptions docker$value;
        @Generated
        private boolean containerImage$set;
        @Generated
        private String containerImage$value;
        @Generated
        private String script;

        @Generated
        public B docker(DockerOptions docker) {
            this.docker$value = docker;
            this.docker$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B containerImage(String containerImage) {
            this.containerImage$value = containerImage;
            this.containerImage$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B script(String script) {
            this.script = script;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Script.ScriptBuilder(super=" + super.toString() + ", docker$value=" + this.docker$value + ", containerImage$value=" + this.containerImage$value + ", script=" + this.script + ")";
        }
    }

    @Generated
    private static final class ScriptBuilderImpl
    extends ScriptBuilder<Script, ScriptBuilderImpl> {
        @Generated
        private ScriptBuilderImpl() {
        }

        @Override
        @Generated
        protected ScriptBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Script build() {
            return new Script(this);
        }
    }
}

