/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.exec;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.scripts.exec.scripts.models.DockerOptions;
import io.kestra.plugin.scripts.exec.scripts.models.RunnerType;
import io.kestra.plugin.scripts.exec.scripts.models.ScriptOutput;
import io.kestra.plugin.scripts.exec.scripts.runners.CommandsWrapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public abstract class AbstractExecScript
extends Task
implements RunnableTask<ScriptOutput> {
    @Schema(title="Runner to use")
    @PluginProperty
    @NotNull
    @NotEmpty
    protected RunnerType runner;
    @Schema(title="A list of commands that will run before `commands`, allowing to set up the environment e.g. `pip install -r requirements.txt`")
    @PluginProperty(dynamic=true)
    protected List<String> beforeCommands;
    @Schema(title="Additional environment variables for the current process.")
    @PluginProperty(additionalProperties=String.class, dynamic=true)
    protected Map<String, String> env;
    @Schema(title="Set the task state to `WARNING`if any `stdErr` is emitted")
    @PluginProperty
    @NotNull
    protected Boolean warningOnStdErr;
    @Schema(title="Which interpreter to use")
    @PluginProperty
    @NotNull
    @NotEmpty
    protected List<String> interpreter;

    public abstract DockerOptions getDocker();

    protected CommandsWrapper commands(RunContext runContext) throws IllegalVariableEvaluationException {
        CommandsWrapper commands = new CommandsWrapper(runContext).withEnv(this.env).withWarningOnStdErr(this.warningOnStdErr).withRunnerType(this.runner).withDockerOptions(this.getDocker());
        return commands;
    }

    @Generated
    private static RunnerType $default$runner() {
        return RunnerType.DOCKER;
    }

    @Generated
    private static Boolean $default$warningOnStdErr() {
        return true;
    }

    @Generated
    private static List<String> $default$interpreter() {
        return List.of("/bin/sh", "-c");
    }

    @Generated
    protected AbstractExecScript(AbstractExecScriptBuilder<?, ?> b) {
        super(b);
        this.runner = b.runner$set ? b.runner$value : AbstractExecScript.$default$runner();
        this.beforeCommands = b.beforeCommands;
        this.env = b.env;
        this.warningOnStdErr = b.warningOnStdErr$set ? b.warningOnStdErr$value : AbstractExecScript.$default$warningOnStdErr();
        this.interpreter = b.interpreter$set ? b.interpreter$value : AbstractExecScript.$default$interpreter();
    }

    @Generated
    public String toString() {
        return "AbstractExecScript(super=" + super.toString() + ", runner=" + this.getRunner() + ", beforeCommands=" + this.getBeforeCommands() + ", env=" + this.getEnv() + ", warningOnStdErr=" + this.getWarningOnStdErr() + ", interpreter=" + this.getInterpreter() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractExecScript)) {
            return false;
        }
        AbstractExecScript other = (AbstractExecScript)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$warningOnStdErr = this.getWarningOnStdErr();
        Boolean other$warningOnStdErr = other.getWarningOnStdErr();
        if (this$warningOnStdErr == null ? other$warningOnStdErr != null : !((Object)this$warningOnStdErr).equals(other$warningOnStdErr)) {
            return false;
        }
        RunnerType this$runner = this.getRunner();
        RunnerType other$runner = other.getRunner();
        if (this$runner == null ? other$runner != null : !((Object)((Object)this$runner)).equals((Object)other$runner)) {
            return false;
        }
        List<String> this$beforeCommands = this.getBeforeCommands();
        List<String> other$beforeCommands = other.getBeforeCommands();
        if (this$beforeCommands == null ? other$beforeCommands != null : !((Object)this$beforeCommands).equals(other$beforeCommands)) {
            return false;
        }
        Map<String, String> this$env = this.getEnv();
        Map<String, String> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        List<String> this$interpreter = this.getInterpreter();
        List<String> other$interpreter = other.getInterpreter();
        return !(this$interpreter == null ? other$interpreter != null : !((Object)this$interpreter).equals(other$interpreter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractExecScript;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $warningOnStdErr = this.getWarningOnStdErr();
        result = result * 59 + ($warningOnStdErr == null ? 43 : ((Object)$warningOnStdErr).hashCode());
        RunnerType $runner = this.getRunner();
        result = result * 59 + ($runner == null ? 43 : ((Object)((Object)$runner)).hashCode());
        List<String> $beforeCommands = this.getBeforeCommands();
        result = result * 59 + ($beforeCommands == null ? 43 : ((Object)$beforeCommands).hashCode());
        Map<String, String> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        List<String> $interpreter = this.getInterpreter();
        result = result * 59 + ($interpreter == null ? 43 : ((Object)$interpreter).hashCode());
        return result;
    }

    @Generated
    public RunnerType getRunner() {
        return this.runner;
    }

    @Generated
    public List<String> getBeforeCommands() {
        return this.beforeCommands;
    }

    @Generated
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Generated
    public Boolean getWarningOnStdErr() {
        return this.warningOnStdErr;
    }

    @Generated
    public List<String> getInterpreter() {
        return this.interpreter;
    }

    @Generated
    public AbstractExecScript() {
        this.runner = AbstractExecScript.$default$runner();
        this.warningOnStdErr = AbstractExecScript.$default$warningOnStdErr();
        this.interpreter = AbstractExecScript.$default$interpreter();
    }

    @Generated
    public static abstract class AbstractExecScriptBuilder<C extends AbstractExecScript, B extends AbstractExecScriptBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private boolean runner$set;
        @Generated
        private RunnerType runner$value;
        @Generated
        private List<String> beforeCommands;
        @Generated
        private Map<String, String> env;
        @Generated
        private boolean warningOnStdErr$set;
        @Generated
        private Boolean warningOnStdErr$value;
        @Generated
        private boolean interpreter$set;
        @Generated
        private List<String> interpreter$value;

        @Generated
        public B runner(RunnerType runner) {
            this.runner$value = runner;
            this.runner$set = true;
            return (B)this.self();
        }

        @Generated
        public B beforeCommands(List<String> beforeCommands) {
            this.beforeCommands = beforeCommands;
            return (B)this.self();
        }

        @Generated
        public B env(Map<String, String> env) {
            this.env = env;
            return (B)this.self();
        }

        @Generated
        public B warningOnStdErr(Boolean warningOnStdErr) {
            this.warningOnStdErr$value = warningOnStdErr;
            this.warningOnStdErr$set = true;
            return (B)this.self();
        }

        @Generated
        public B interpreter(List<String> interpreter) {
            this.interpreter$value = interpreter;
            this.interpreter$set = true;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractExecScript.AbstractExecScriptBuilder(super=" + super.toString() + ", runner$value=" + this.runner$value + ", beforeCommands=" + this.beforeCommands + ", env=" + this.env + ", warningOnStdErr$value=" + this.warningOnStdErr$value + ", interpreter$value=" + this.interpreter$value + ")";
        }
    }
}

