/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.exec.scripts.runners;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.scripts.exec.scripts.models.DockerOptions;
import io.kestra.plugin.scripts.exec.scripts.models.RunnerType;
import io.kestra.plugin.scripts.exec.scripts.models.ScriptOutput;
import io.kestra.plugin.scripts.exec.scripts.runners.AbstractLogConsumer;
import io.kestra.plugin.scripts.exec.scripts.runners.DockerScriptRunner;
import io.kestra.plugin.scripts.exec.scripts.runners.ProcessBuilderScriptRunner;
import io.kestra.plugin.scripts.exec.scripts.runners.RunnerResult;
import io.kestra.plugin.scripts.exec.scripts.services.LogService;
import io.kestra.plugin.scripts.exec.scripts.services.ScriptService;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class CommandsWrapper {
    private RunContext runContext;
    private Path workingDirectory;
    private Path outputDirectory;
    private Map<String, Object> additionalVars;
    private List<String> commands;
    private Map<String, String> env;
    private AbstractLogConsumer logConsumer;
    private RunnerType runnerType;
    private DockerOptions dockerOptions;
    private Boolean warningOnStdErr;

    public CommandsWrapper(RunContext runContext) {
        this.runContext = runContext;
        this.workingDirectory = runContext.tempDir();
        this.outputDirectory = this.workingDirectory.resolve(IdUtils.create());
        this.outputDirectory.toFile().mkdirs();
        this.additionalVars = new HashMap<String, String>(Map.of("workingDir", this.workingDirectory.toAbsolutePath().toString(), "outputDir", this.outputDirectory.toString()));
        this.logConsumer = LogService.defaultLogSupplier(runContext);
    }

    public CommandsWrapper withCommands(List<String> commands) throws IOException, IllegalVariableEvaluationException {
        return new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, ScriptService.uploadInputFiles(this.runContext, this.runContext.render(commands, this.additionalVars)), this.env, this.logConsumer, this.runnerType, this.dockerOptions, this.warningOnStdErr);
    }

    public CommandsWrapper withEnv(Map<String, String> envs) throws IllegalVariableEvaluationException {
        return new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.commands, (envs == null ? Map.of() : envs).entrySet().stream().map(Rethrow.throwFunction(r -> new AbstractMap.SimpleEntry<String, String>(this.runContext.render((String)r.getKey(), this.additionalVars), this.runContext.render((String)r.getValue(), this.additionalVars)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), this.logConsumer, this.runnerType, this.dockerOptions, this.warningOnStdErr);
    }

    public CommandsWrapper addAdditionalVars(Map<String, Object> additionalVars) {
        this.additionalVars.putAll(additionalVars);
        return this;
    }

    public CommandsWrapper addEnv(Map<String, String> envs) {
        this.env.putAll(envs);
        return this;
    }

    public ScriptOutput run() throws Exception {
        RunnerResult runnerResult = this.runnerType.equals((Object)RunnerType.DOCKER) ? new DockerScriptRunner(this.runContext.getApplicationContext()).run(this, this.dockerOptions) : new ProcessBuilderScriptRunner().run(this);
        Map<String, URI> outputFiles = ScriptService.uploadOutputFiles(this.runContext, this.outputDirectory);
        return ScriptOutput.builder().exitCode(runnerResult.getExitCode()).stdOutLineCount(runnerResult.getLogConsumer().getStdOutCount()).stdErrLineCount(runnerResult.getLogConsumer().getStdErrCount()).warningOnStdErr(this.warningOnStdErr).vars(runnerResult.getLogConsumer().getOutputs()).outputFiles(outputFiles).build();
    }

    @ConstructorProperties(value={"runContext", "workingDirectory", "outputDirectory", "additionalVars", "commands", "env", "logConsumer", "runnerType", "dockerOptions", "warningOnStdErr"})
    @Generated
    public CommandsWrapper(RunContext runContext, Path workingDirectory, Path outputDirectory, Map<String, Object> additionalVars, List<String> commands, Map<String, String> env, AbstractLogConsumer logConsumer, RunnerType runnerType, DockerOptions dockerOptions, Boolean warningOnStdErr) {
        this.runContext = runContext;
        this.workingDirectory = workingDirectory;
        this.outputDirectory = outputDirectory;
        this.additionalVars = additionalVars;
        this.commands = commands;
        this.env = env;
        this.logConsumer = logConsumer;
        this.runnerType = runnerType;
        this.dockerOptions = dockerOptions;
        this.warningOnStdErr = warningOnStdErr;
    }

    @Generated
    public RunContext getRunContext() {
        return this.runContext;
    }

    @Generated
    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Generated
    public Path getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public Map<String, Object> getAdditionalVars() {
        return this.additionalVars;
    }

    @Generated
    public List<String> getCommands() {
        return this.commands;
    }

    @Generated
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Generated
    public AbstractLogConsumer getLogConsumer() {
        return this.logConsumer;
    }

    @Generated
    public RunnerType getRunnerType() {
        return this.runnerType;
    }

    @Generated
    public DockerOptions getDockerOptions() {
        return this.dockerOptions;
    }

    @Generated
    public Boolean getWarningOnStdErr() {
        return this.warningOnStdErr;
    }

    @Generated
    public CommandsWrapper withLogConsumer(AbstractLogConsumer logConsumer) {
        return this.logConsumer == logConsumer ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.commands, this.env, logConsumer, this.runnerType, this.dockerOptions, this.warningOnStdErr);
    }

    @Generated
    public CommandsWrapper withRunnerType(RunnerType runnerType) {
        return this.runnerType == runnerType ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.commands, this.env, this.logConsumer, runnerType, this.dockerOptions, this.warningOnStdErr);
    }

    @Generated
    public CommandsWrapper withDockerOptions(DockerOptions dockerOptions) {
        return this.dockerOptions == dockerOptions ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.commands, this.env, this.logConsumer, this.runnerType, dockerOptions, this.warningOnStdErr);
    }

    @Generated
    public CommandsWrapper withWarningOnStdErr(Boolean warningOnStdErr) {
        return this.warningOnStdErr == warningOnStdErr ? this : new CommandsWrapper(this.runContext, this.workingDirectory, this.outputDirectory, this.additionalVars, this.commands, this.env, this.logConsumer, this.runnerType, this.dockerOptions, warningOnStdErr);
    }
}

