/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.exec.scripts.runners;

import io.kestra.plugin.scripts.exec.scripts.runners.AbstractLogConsumer;
import io.kestra.plugin.scripts.exec.scripts.runners.CommandsWrapper;
import io.kestra.plugin.scripts.exec.scripts.runners.RunnerResult;
import io.kestra.plugin.scripts.exec.scripts.runners.ScriptException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import org.slf4j.Logger;

public class ProcessBuilderScriptRunner {
    public RunnerResult run(CommandsWrapper commands) throws Exception {
        Logger logger = commands.getRunContext().logger();
        Path workingDirectory = commands.getWorkingDirectory();
        AbstractLogConsumer defaultLogConsumer = commands.getLogConsumer();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (commands.getEnv() != null && !commands.getEnv().isEmpty()) {
            Map<String, String> environment = processBuilder.environment();
            environment.putAll(commands.getEnv());
        }
        if (workingDirectory != null) {
            processBuilder.directory(workingDirectory.toFile());
        }
        processBuilder.command(commands.getCommands());
        Process process = processBuilder.start();
        long pid = process.pid();
        logger.debug("Starting command with pid {} [{}]", (Object)pid, (Object)String.join((CharSequence)" ", commands.getCommands()));
        LogThread stdOut = new LogThread(process.getInputStream(), defaultLogConsumer, false);
        LogThread stdErr = new LogThread(process.getErrorStream(), defaultLogConsumer, true);
        stdOut.start();
        stdErr.start();
        try {
            int exitCode = process.waitFor();
            stdOut.join();
            stdErr.join();
            if (exitCode != 0) {
                throw new ScriptException(exitCode, defaultLogConsumer.getStdOutCount(), defaultLogConsumer.getStdErrCount());
            }
            logger.debug("Command succeed with code " + exitCode);
            RunnerResult runnerResult = new RunnerResult(exitCode, defaultLogConsumer);
            return runnerResult;
        }
        catch (InterruptedException e) {
            logger.warn("Killing process {} for InterruptedException", (Object)pid);
            this.killDescendantsOf(process.toHandle(), logger);
            process.destroy();
            throw e;
        }
        finally {
            stdOut.join();
            stdErr.join();
        }
    }

    private void killDescendantsOf(ProcessHandle process, Logger logger) {
        process.descendants().forEach(processHandle -> {
            if (!processHandle.destroy()) {
                logger.warn("Descendant process {} of {} couldn't be killed", (Object)processHandle.pid(), (Object)process.pid());
            }
        });
    }

    public static class LogThread
    extends Thread {
        private final InputStream inputStream;
        private final AbstractLogConsumer logConsumerInterface;
        private final boolean isStdErr;

        protected LogThread(InputStream inputStream, AbstractLogConsumer logConsumerInterface, boolean isStdErr) {
            this.inputStream = inputStream;
            this.logConsumerInterface = logConsumerInterface;
            this.isStdErr = isStdErr;
        }

        @Override
        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.inputStream, StandardCharsets.UTF_8);
                try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        this.logConsumerInterface.accept(line, this.isStdErr);
                    }
                }
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

