/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.exec.scripts.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.plugin.scripts.exec.scripts.models.ScriptOutputFormat;
import io.kestra.plugin.scripts.exec.scripts.runners.AbstractLogConsumer;
import io.kestra.plugin.scripts.exec.scripts.runners.DefaultLogConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class LogService {
    protected static final ObjectMapper MAPPER = JacksonMapper.ofJson();
    private static final Pattern PATTERN = Pattern.compile("^::(\\{.*})::$");

    public static Map<String, Object> parse(String line, Logger logger, RunContext runContext) {
        Matcher m = PATTERN.matcher(line);
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        if (m.find()) {
            try {
                ScriptOutputFormat scriptOutputFormat = MAPPER.readValue(m.group(1), ScriptOutputFormat.class);
                if (scriptOutputFormat.getOutputs() != null) {
                    outputs.putAll(scriptOutputFormat.getOutputs());
                }
                if (scriptOutputFormat.getMetrics() != null) {
                    scriptOutputFormat.getMetrics().forEach(arg_0 -> ((RunContext)runContext).metric(arg_0));
                }
            }
            catch (JsonProcessingException e) {
                logger.warn("Invalid outputs '{}'", (Object)e.getMessage(), (Object)e);
            }
        }
        return outputs;
    }

    public static AbstractLogConsumer defaultLogSupplier(RunContext runContext) {
        return new DefaultLogConsumer(runContext);
    }
}

