/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.exec.scripts.services;

import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.Rethrow;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;

public abstract class ScriptService {
    private static final Pattern INTERNAL_STORAGE_PATTERN = Pattern.compile("(kestra:\\/\\/[-a-zA-Z0-9%._\\+~#=/]*)");

    public static List<String> uploadInputFiles(RunContext runContext, List<String> commands) throws IOException {
        return commands.stream().map(Rethrow.throwFunction(s -> INTERNAL_STORAGE_PATTERN.matcher((CharSequence)s).replaceAll(Rethrow.throwFunction(matchResult -> ScriptService.saveOnLocalStorage(runContext, matchResult.group()))))).collect(Collectors.toList());
    }

    private static String saveOnLocalStorage(RunContext runContext, String uri) throws IOException {
        InputStream inputStream = runContext.uriToInputStream(URI.create(uri));
        Path path = runContext.tempFile();
        IOUtils.copyLarge(inputStream, new FileOutputStream(path.toFile()));
        return path.toString();
    }

    public static Map<String, URI> uploadOutputFiles(RunContext runContext, Path outputDir) throws IOException {
        HashMap<String, URI> uploaded = new HashMap<String, URI>();
        try (Stream<Path> walk = Files.walk(outputDir, new FileVisitOption[0]);){
            walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> !path.startsWith(".")).forEach(Rethrow.throwConsumer(path -> {
                String filename = outputDir.relativize((Path)path).toString();
                uploaded.put(filename, runContext.putTempFile(path.toFile(), filename));
            }));
        }
        return uploaded;
    }

    public static List<String> scriptCommands(List<String> interpreter, List<String> beforeCommands, String command) {
        return ScriptService.scriptCommands(interpreter, beforeCommands, List.of(command));
    }

    public static List<String> scriptCommands(List<String> interpreter, List<String> beforeCommands, List<String> commands) {
        ArrayList<String> commandsArgs = new ArrayList<String>(interpreter);
        commandsArgs.add(Stream.concat(ListUtils.emptyOnNull(beforeCommands).stream(), commands.stream()).collect(Collectors.joining(System.lineSeparator())));
        return commandsArgs;
    }
}

