/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.r;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.scripts.exec.AbstractExecScript;
import io.kestra.plugin.scripts.exec.scripts.models.DockerOptions;
import io.kestra.plugin.scripts.exec.scripts.models.ScriptOutput;
import io.kestra.plugin.scripts.exec.scripts.services.ScriptService;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Execute R from the Command Line Interface.")
@Plugin(examples={@Example(full=true, title="Create a R script, install a package and execute it", code={"id: \"local-files\"\nnamespace: \"io.kestra.tests\"\n\ntasks:\n  - id: workingDir\n    type: io.kestra.core.tasks.flows.WorkingDirectory\n    tasks:\n    - id: inputFiles\n      type: io.kestra.core.tasks.storages.LocalFiles\n      inputs:\n        main.R: |\n          library(lubridate)\n          ymd(\"20100604\");\n          mdy(\"06-04-2011\");\n          dmy(\"04/06/2012\")\n    - id: bash\n      type: io.kestra.plugin.scripts.powershell.Commands\n      beforeCommands:\n        - Rscript -e 'install.packages(\"lubridate\")'\n      commands:\n        - Rscript main.R\n"})})
public class Commands
extends AbstractExecScript {
    @Schema(title="Docker options when using the `DOCKER` runner")
    @PluginProperty
    protected DockerOptions docker;
    @Schema(title="The commands to run")
    @PluginProperty(dynamic=true)
    @NotNull
    @NotEmpty
    protected List<String> commands;

    public ScriptOutput run(RunContext runContext) throws Exception {
        List<String> commandsArgs = ScriptService.scriptCommands((List<String>)this.interpreter, (List<String>)this.beforeCommands, this.commands);
        return this.commands(runContext).withCommands(commandsArgs).run();
    }

    @Generated
    private static DockerOptions $default$docker() {
        return ((DockerOptions.DockerOptionsBuilder)DockerOptions.builder().image("r-base")).build();
    }

    @Generated
    protected Commands(CommandsBuilder<?, ?> b) {
        super(b);
        this.docker = b.docker$set ? b.docker$value : Commands.$default$docker();
        this.commands = b.commands;
    }

    @Generated
    public static CommandsBuilder<?, ?> builder() {
        return new CommandsBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Commands(super=" + super.toString() + ", docker=" + this.getDocker() + ", commands=" + this.getCommands() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Commands)) {
            return false;
        }
        Commands other = (Commands)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerOptions this$docker = this.getDocker();
        DockerOptions other$docker = other.getDocker();
        if (this$docker == null ? other$docker != null : !this$docker.equals(other$docker)) {
            return false;
        }
        List<String> this$commands = this.getCommands();
        List<String> other$commands = other.getCommands();
        return !(this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Commands;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DockerOptions $docker = this.getDocker();
        result = result * 59 + ($docker == null ? 43 : $docker.hashCode());
        List<String> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        return result;
    }

    @Override
    @Generated
    public DockerOptions getDocker() {
        return this.docker;
    }

    @Generated
    public List<String> getCommands() {
        return this.commands;
    }

    @Generated
    public Commands() {
        this.docker = Commands.$default$docker();
    }

    @Generated
    public static abstract class CommandsBuilder<C extends Commands, B extends CommandsBuilder<C, B>>
    extends AbstractExecScript.AbstractExecScriptBuilder<C, B> {
        @Generated
        private boolean docker$set;
        @Generated
        private DockerOptions docker$value;
        @Generated
        private List<String> commands;

        @Generated
        public B docker(DockerOptions docker) {
            this.docker$value = docker;
            this.docker$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B commands(List<String> commands) {
            this.commands = commands;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Commands.CommandsBuilder(super=" + super.toString() + ", docker$value=" + this.docker$value + ", commands=" + this.commands + ")";
        }
    }

    @Generated
    private static final class CommandsBuilderImpl
    extends CommandsBuilder<Commands, CommandsBuilderImpl> {
        @Generated
        private CommandsBuilderImpl() {
        }

        @Override
        @Generated
        protected CommandsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Commands build() {
            return new Commands(this);
        }
    }
}

