/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.r;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.scripts.exec.AbstractExecScript;
import io.kestra.plugin.scripts.exec.scripts.models.DockerOptions;
import io.kestra.plugin.scripts.exec.scripts.models.ScriptOutput;
import io.kestra.plugin.scripts.exec.scripts.runners.CommandsWrapper;
import io.kestra.plugin.scripts.exec.scripts.services.ScriptService;
import io.swagger.v3.oas.annotations.media.Schema;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import lombok.Generated;

@Schema(title="Execute an R script.")
@Plugin(examples={@Example(title="Install a package and execute a R script", code={"script: |", "  library(lubridate)", "  ymd(\"20100604\");", "  mdy(\"06-04-2011\");", "  dmy(\"04/06/2012\")", "beforeCommands:", "  - Rscript -e 'install.packages(\"lubridate\")"})})
public class Script
extends AbstractExecScript {
    @Schema(title="Docker options when using the `DOCKER` runner")
    @PluginProperty
    protected DockerOptions docker;
    @Schema(title="The inline script content. This property is intended for the script file's content as a (multiline) string, not a path to a file. To run a command from a file such as `bash myscript.sh` or `python myscript.py`, use the `Commands` task instead.")
    @PluginProperty(dynamic=true)
    protected String script;

    public ScriptOutput run(RunContext runContext) throws Exception {
        CommandsWrapper commands = this.commands(runContext);
        Path path = runContext.tempFile(runContext.render(this.script, commands.getAdditionalVars()).getBytes(StandardCharsets.UTF_8), ".R");
        List<String> commandsArgs = ScriptService.scriptCommands((List<String>)this.interpreter, (List<String>)this.beforeCommands, String.join((CharSequence)" ", "Rscript", path.toAbsolutePath().toString()));
        return commands.withCommands(commandsArgs).run();
    }

    @Generated
    private static DockerOptions $default$docker() {
        return ((DockerOptions.DockerOptionsBuilder)DockerOptions.builder().image("r-base")).build();
    }

    @Generated
    protected Script(ScriptBuilder<?, ?> b) {
        super(b);
        this.docker = b.docker$set ? b.docker$value : Script.$default$docker();
        this.script = b.script;
    }

    @Generated
    public static ScriptBuilder<?, ?> builder() {
        return new ScriptBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Script(super=" + super.toString() + ", docker=" + this.getDocker() + ", script=" + this.getScript() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Script)) {
            return false;
        }
        Script other = (Script)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerOptions this$docker = this.getDocker();
        DockerOptions other$docker = other.getDocker();
        if (this$docker == null ? other$docker != null : !this$docker.equals(other$docker)) {
            return false;
        }
        String this$script = this.getScript();
        String other$script = other.getScript();
        return !(this$script == null ? other$script != null : !this$script.equals(other$script));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Script;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DockerOptions $docker = this.getDocker();
        result = result * 59 + ($docker == null ? 43 : $docker.hashCode());
        String $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        return result;
    }

    @Override
    @Generated
    public DockerOptions getDocker() {
        return this.docker;
    }

    @Generated
    public String getScript() {
        return this.script;
    }

    @Generated
    public Script() {
        this.docker = Script.$default$docker();
    }

    @Generated
    public static abstract class ScriptBuilder<C extends Script, B extends ScriptBuilder<C, B>>
    extends AbstractExecScript.AbstractExecScriptBuilder<C, B> {
        @Generated
        private boolean docker$set;
        @Generated
        private DockerOptions docker$value;
        @Generated
        private String script;

        @Generated
        public B docker(DockerOptions docker) {
            this.docker$value = docker;
            this.docker$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B script(String script) {
            this.script = script;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Script.ScriptBuilder(super=" + super.toString() + ", docker$value=" + this.docker$value + ", script=" + this.script + ")";
        }
    }

    @Generated
    private static final class ScriptBuilderImpl
    extends ScriptBuilder<Script, ScriptBuilderImpl> {
        @Generated
        private ScriptBuilderImpl() {
        }

        @Override
        @Generated
        protected ScriptBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Script build() {
            return new Script(this);
        }
    }
}

