/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.jvm;

import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.scripts.jvm.AbstractJvmScript;
import io.kestra.plugin.scripts.jvm.ScriptEngineService;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import lombok.Generated;

@Schema(description="You can use a full script. \nThe script contains some predefined variables:\n- All the variables you have in expression vars like `execution.id`. For example:\n- `logger`: use as the standard Java logger (`logger.info('my message')`)\n- `runContext` that allows you to:\n  - `runContext.metric(Counter.of(\"file.size\", response.contentLength()))`: send metrics\n  - `runContext.storage().getFile(URI uri)`: get a file from Kestra's internal storage\n  - `runContext.storage().putFile(File file)`: store a file in Kestra's internal storage\n\nThe stdOut & stdErr is not captured, so you must use `logger`.\n")
public abstract class Eval
extends AbstractJvmScript
implements RunnableTask<Output> {
    @Schema(title="A list of output variables that will be usable in outputs.")
    @PluginProperty
    protected List<String> outputs;

    protected Output run(RunContext runContext, String engineName) throws Exception {
        ScriptEngineService.CompiledScript scripts = ScriptEngineService.scripts(runContext, engineName, this.generateScript(runContext), ((Object)((Object)this)).getClass().getClassLoader());
        Bindings bindings = scripts.getBindings().get();
        Object result = scripts.getEngine().eval(this.generateScript(runContext), bindings);
        Output.OutputBuilder builder = Output.builder();
        if (this.outputs != null && this.outputs.size() > 0) {
            builder.outputs(this.gatherOutputs(scripts.getEngine(), bindings));
        }
        return builder.result(result).build();
    }

    protected Map<String, Object> gatherOutputs(ScriptEngine engine, Bindings bindings) throws Exception {
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        this.outputs.forEach(s -> outputs.put((String)s, bindings.get(s)));
        return outputs;
    }

    @Generated
    protected Eval(EvalBuilder<?, ?> b) {
        super(b);
        this.outputs = b.outputs;
    }

    @Override
    @Generated
    public String toString() {
        return "Eval(super=" + super.toString() + ", outputs=" + String.valueOf(this.getOutputs()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Eval)) {
            return false;
        }
        Eval other = (Eval)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$outputs = this.getOutputs();
        List<String> other$outputs = other.getOutputs();
        return !(this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Eval;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        return result;
    }

    @Generated
    public List<String> getOutputs() {
        return this.outputs;
    }

    @Generated
    public Eval() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The resulting object.", description="Mostly the last return of eval (if the language allows it).")
        private final Object result;
        @Schema(title="The captured outputs as declared on task property.")
        private final Map<String, Object> outputs;

        @ConstructorProperties(value={"result", "outputs"})
        @Generated
        Output(Object result, Map<String, Object> outputs) {
            this.result = result;
            this.outputs = outputs;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Object getResult() {
            return this.result;
        }

        @Generated
        public Map<String, Object> getOutputs() {
            return this.outputs;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Object result;
            @Generated
            private Map<String, Object> outputs;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder result(Object result) {
                this.result = result;
                return this;
            }

            @Generated
            public OutputBuilder outputs(Map<String, Object> outputs) {
                this.outputs = outputs;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.result, this.outputs);
            }

            @Generated
            public String toString() {
                return "Eval.Output.OutputBuilder(result=" + String.valueOf(this.result) + ", outputs=" + String.valueOf(this.outputs) + ")";
            }
        }
    }

    @Generated
    public static abstract class EvalBuilder<C extends Eval, B extends EvalBuilder<C, B>>
    extends AbstractJvmScript.AbstractJvmScriptBuilder<C, B> {
        @Generated
        private List<String> outputs;

        @Generated
        public B outputs(List<String> outputs) {
            this.outputs = outputs;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Eval.EvalBuilder(super=" + super.toString() + ", outputs=" + String.valueOf(this.outputs) + ")";
        }
    }
}

