/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.jvm;

import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.FileSerde;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.scripts.jvm.AbstractJvmScript;
import io.kestra.plugin.scripts.jvm.ScriptEngineService;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.script.Bindings;
import javax.script.ScriptException;
import lombok.Generated;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Schema(title="Transform ion format file from Kestra with a groovy script.", description="This allows you to transform the data, previously loaded by Kestra, as you need.\n\nTake a ion format file from Kestra and iterate row per row.\nEach row will populate a `row` global variable. You need to alter this variable that will be saved on output file.\nIf you set the `row` to `null`, the row will be skipped.\nYou can create a variable `rows` to return multiple rows for a single `row`.\n")
public abstract class FileTransform
extends AbstractJvmScript
implements RunnableTask<Output> {
    @NotNull
    @Schema(title="Source file containing rows to transform.", description="Can be Kestra's internal storage URI, a map or a list.")
    @PluginProperty(dynamic=true)
    private String from;
    @Min(value=2L)
    @Schema(title="Number of concurrent parallel transformations to execute.", description="Take care that the order is **not respected** if you use parallelism.")
    @PluginProperty
    private @Min(value=2L) Integer concurrent;

    protected Output run(RunContext runContext, String engineName) throws Exception {
        String from = runContext.render(this.from);
        File tempFile = runContext.workingDir().createTempFile(".ion").toFile();
        ScriptEngineService.CompiledScript scripts = ScriptEngineService.scripts(runContext, engineName, this.generateScript(runContext), ((Object)((Object)this)).getClass().getClassLoader());
        try (FileOutputStream output = new FileOutputStream(tempFile);){
            if (from.startsWith("kestra://")) {
                try (BufferedReader inputStream = new BufferedReader(new InputStreamReader(runContext.storage().getFile(URI.create(from))));){
                    this.finalize(runContext, (Flux<Object>)Flux.create((Consumer)FileSerde.reader((BufferedReader)inputStream), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER), scripts, output);
                }
            } else {
                this.finalize(runContext, (Flux<Object>)Flux.create((Consumer)Rethrow.throwConsumer(emitter -> {
                    Object o = JacksonMapper.toObject((String)from);
                    if (o instanceof List) {
                        ((List)o).forEach(arg_0 -> ((FluxSink)emitter).next(arg_0));
                    } else {
                        emitter.next(o);
                    }
                    emitter.complete();
                }), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER), scripts, output);
            }
            output.flush();
        }
        return Output.builder().uri(runContext.storage().putFile(tempFile)).build();
    }

    protected void finalize(RunContext runContext, Flux<Object> flowable, ScriptEngineService.CompiledScript scripts, OutputStream output) throws IOException, ScriptException {
        Flux sequential = this.concurrent != null ? flowable.parallel(this.concurrent.intValue()).runOn(Schedulers.boundedElastic()).flatMap(this.convert(scripts)).sequential() : flowable.flatMap(this.convert(scripts));
        Mono count = sequential.doOnNext(Rethrow.throwConsumer(row -> FileSerde.write((OutputStream)output, (Object)row))).count();
        Long lineCount = (Long)count.block();
        runContext.metric((AbstractMetricEntry)Counter.of((String)"records", (Long)lineCount, (String[])new String[0]));
    }

    protected Function<Object, Publisher<Object>> convert(ScriptEngineService.CompiledScript script) throws ScriptException {
        return Rethrow.throwFunction(row -> {
            Bindings bindings = script.getBindings().get();
            bindings.put("row", row);
            script.getScript().eval(bindings);
            if (bindings.get("rows") != null) {
                return Flux.fromIterable((Iterable)((Collection)bindings.get("rows")));
            }
            if (bindings.get("row") != null) {
                return Flux.just((Object)bindings.get("row"));
            }
            return Flux.empty();
        });
    }

    @Generated
    protected FileTransform(FileTransformBuilder<?, ?> b) {
        super(b);
        this.from = b.from;
        this.concurrent = b.concurrent;
    }

    @Override
    @Generated
    public String toString() {
        return "FileTransform(super=" + super.toString() + ", from=" + this.getFrom() + ", concurrent=" + this.getConcurrent() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileTransform)) {
            return false;
        }
        FileTransform other = (FileTransform)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$concurrent = this.getConcurrent();
        Integer other$concurrent = other.getConcurrent();
        if (this$concurrent == null ? other$concurrent != null : !((Object)this$concurrent).equals(other$concurrent)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        return !(this$from == null ? other$from != null : !this$from.equals(other$from));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileTransform;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $concurrent = this.getConcurrent();
        result = result * 59 + ($concurrent == null ? 43 : ((Object)$concurrent).hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        return result;
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Generated
    public Integer getConcurrent() {
        return this.concurrent;
    }

    @Generated
    public FileTransform() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="URI of a temporary result file.", description="The file will be serialized as ion file.")
        private final URI uri;

        @ConstructorProperties(value={"uri"})
        @Generated
        Output(URI uri) {
            this.uri = uri;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI uri;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uri);
            }

            @Generated
            public String toString() {
                return "FileTransform.Output.OutputBuilder(uri=" + String.valueOf(this.uri) + ")";
            }
        }
    }

    @Generated
    public static abstract class FileTransformBuilder<C extends FileTransform, B extends FileTransformBuilder<C, B>>
    extends AbstractJvmScript.AbstractJvmScriptBuilder<C, B> {
        @Generated
        private String from;
        @Generated
        private Integer concurrent;

        @Generated
        public B from(String from) {
            this.from = from;
            return (B)((Object)this.self());
        }

        @Generated
        public B concurrent(Integer concurrent) {
            this.concurrent = concurrent;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "FileTransform.FileTransformBuilder(super=" + super.toString() + ", from=" + this.from + ", concurrent=" + this.concurrent + ")";
        }
    }
}

