/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.scripts.ruby;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.runners.ScriptService;
import io.kestra.core.models.tasks.runners.TargetOS;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.scripts.exec.AbstractExecScript;
import io.kestra.plugin.scripts.exec.scripts.models.DockerOptions;
import io.kestra.plugin.scripts.exec.scripts.models.ScriptOutput;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import lombok.Generated;

@Schema(title="Execute a Ruby script from the Command Line Interface.")
@Plugin(examples={@Example(full=true, title="Create a Ruby script and execute it. The easiest way to create a Ruby script is to use the embedded VS Code editor. Create a file named `main.rb` and paste the following code:\n\n```ruby\nrequire 'csv'\nrequire 'json'\n\nfile = File.read('data.json')\ndata_hash = JSON.parse(file)\n\n# Extract headers\nheaders = data_hash.first.keys\n\n# Convert hashes to arrays\ndata = data_hash.map(&:values)\n\n# Prepend headers to data\ndata.unshift(headers)\n\n# Create and write data to CSV file\nCSV.open('output.csv', 'wb') do |csv|\ndata.each { |row| csv << row }\nend\n```\n\nIn order to read that script from the [Namespace File](https://kestra.io/docs/developer-guide/namespace-files) called `main.rb`, you need to enable the `namespaceFiles` property.\n\nAlso, note how we use the `inputFiles` option to read additional files into the script's working directory. In this case, we read the `data.json` file, which contains the data that we want to convert to CSV.\n\nFinally, we use the `outputFiles` option to specify that we want to output the `output.csv` file that is generated by the script. This allows us to access the file in the UI's Output tab and download it, or pass it to other tasks.\n", code={"id: generate_csv\nnamespace: company.team\ntasks:\n  - id: bash\n    type: io.kestra.plugin.scripts.ruby.Commands\n    namespaceFiles:\n      enabled: true\n    inputFiles:\n      data.json: |\n        [\n            {\"Name\": \"Alice\", \"Age\": 30, \"City\": \"New York\"},\n            {\"Name\": \"Bob\", \"Age\": 22, \"City\": \"Los Angeles\"},\n            {\"Name\": \"Charlie\", \"Age\": 35, \"City\": \"Chicago\"}\n        ]\n    beforeCommands:\n      - ruby -v\n    commands:\n      - ruby main.rb\n    outputFiles:\n      - \"*.csv\"\n"})})
public class Commands
extends AbstractExecScript {
    private static final String DEFAULT_IMAGE = "ruby";
    protected String containerImage;
    @Schema(title="The commands to run")
    @PluginProperty(dynamic=true)
    @NotEmpty
    protected List<String> commands;

    protected DockerOptions injectDefaults(DockerOptions original) {
        DockerOptions.DockerOptionsBuilder builder = original.toBuilder();
        if (original.getImage() == null) {
            builder.image(this.getContainerImage());
        }
        return builder.build();
    }

    public ScriptOutput run(RunContext runContext) throws Exception {
        List commandsArgs = ScriptService.scriptCommands((List)this.interpreter, (List)this.getBeforeCommandsWithOptions(), this.commands, (TargetOS)this.targetOS);
        return this.commands(runContext).withCommands(commandsArgs).run();
    }

    @Generated
    private static String $default$containerImage() {
        return DEFAULT_IMAGE;
    }

    @Generated
    protected Commands(CommandsBuilder<?, ?> b) {
        super(b);
        this.containerImage = b.containerImage$set ? b.containerImage$value : Commands.$default$containerImage();
        this.commands = b.commands;
    }

    @Generated
    public static CommandsBuilder<?, ?> builder() {
        return new CommandsBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Commands(super=" + super.toString() + ", containerImage=" + this.getContainerImage() + ", commands=" + String.valueOf(this.getCommands()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Commands)) {
            return false;
        }
        Commands other = (Commands)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$containerImage = this.getContainerImage();
        String other$containerImage = other.getContainerImage();
        if (this$containerImage == null ? other$containerImage != null : !this$containerImage.equals(other$containerImage)) {
            return false;
        }
        List<String> this$commands = this.getCommands();
        List<String> other$commands = other.getCommands();
        return !(this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Commands;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $containerImage = this.getContainerImage();
        result = result * 59 + ($containerImage == null ? 43 : $containerImage.hashCode());
        List<String> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        return result;
    }

    @Generated
    public String getContainerImage() {
        return this.containerImage;
    }

    @Generated
    public List<String> getCommands() {
        return this.commands;
    }

    @Generated
    public Commands() {
        this.containerImage = Commands.$default$containerImage();
    }

    @Generated
    public static abstract class CommandsBuilder<C extends Commands, B extends CommandsBuilder<C, B>>
    extends AbstractExecScript.AbstractExecScriptBuilder<C, B> {
        @Generated
        private boolean containerImage$set;
        @Generated
        private String containerImage$value;
        @Generated
        private List<String> commands;

        @Generated
        public B containerImage(String containerImage) {
            this.containerImage$value = containerImage;
            this.containerImage$set = true;
            return (B)this.self();
        }

        @Generated
        public B commands(List<String> commands) {
            this.commands = commands;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Commands.CommandsBuilder(super=" + super.toString() + ", containerImage$value=" + this.containerImage$value + ", commands=" + String.valueOf(this.commands) + ")";
        }
    }

    @Generated
    private static final class CommandsBuilderImpl
    extends CommandsBuilder<Commands, CommandsBuilderImpl> {
        @Generated
        private CommandsBuilderImpl() {
        }

        @Override
        @Generated
        protected CommandsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Commands build() {
            return new Commands(this);
        }
    }
}

